/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.AbstractTvDataService;
import devplugin.ActionMenu;
import devplugin.Plugin;
import devplugin.PluginInfo;
import devplugin.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.DummyPlugin;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.AbstractPluginProxy;
import tvbrowser.core.plugin.BeanShellPluginProxy;
import tvbrowser.core.plugin.JavaPluginProxy;
import tvbrowser.core.plugin.PluginBaseInfo;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.DefaultTvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.io.IOUtilities;

public class PluginLoader {
    private static final String[] IGNORED_PLUGINS = new String[]{"FavoritesPlugin.jar", "ReminderPlugin.jar", "ProgramInfo.jar", "SearchPlugin.jar", "ShowviewPlugin.jar"};
    private static final String PLUGIN_PROXY_EXTENSION = ".jar.proxy";
    private static final String PLUGIN_INSTALL_EXTENSION = ".inst";
    private static final Logger mLog = Logger.getLogger(PluginLoader.class.getName());
    private static PluginLoader mInstance;
    private static String PLUGIN_DIRECTORY;
    private HashSet<String> mSuccessfullyLoadedPluginFiles;
    private HashMap<Object, File> mDeleteablePlugin;
    private ArrayList<PluginProxy> loadedProxies;
    private ArrayList<String> mNewInstalledPlugins = new ArrayList();
    private boolean mShowMouseInfo = false;

    private PluginLoader() {
        this.mSuccessfullyLoadedPluginFiles = new HashSet();
        this.mDeleteablePlugin = new HashMap();
    }

    public static PluginLoader getInstance() {
        if (mInstance == null) {
            mInstance = new PluginLoader();
        }
        return mInstance;
    }

    public void installPendingPlugins() {
        File[] installableFiles = new File(Settings.propPluginsDirectory.getString()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String fileName) {
                return fileName.endsWith(PluginLoader.PLUGIN_INSTALL_EXTENSION);
            }
        });
        if (installableFiles == null || installableFiles.length == 0) {
            return;
        }
        for (File file : installableFiles) {
            String oldIconName;
            File oldIcon;
            String fileName = file.getAbsolutePath();
            String oldFileName = fileName.substring(0, fileName.length() - PLUGIN_INSTALL_EXTENSION.length());
            File oldFile = new File(oldFileName);
            String oldProxyName = this.getProxyFileName(oldFile);
            File oldProxy = new File(oldProxyName);
            if (oldProxy.exists()) {
                this.deletePluginProxy(oldProxy);
            }
            if ((oldIcon = new File(oldIconName = this.getProxyIconFileName(oldFile))).exists()) {
                this.deletePluginProxy(oldIcon);
            }
            this.deletePluginProxy(oldFile);
            if (!file.renameTo(oldFile)) {
                mLog.warning("Installing pending plugin failed: " + fileName);
            }
            this.mNewInstalledPlugins.add(oldFileName);
        }
    }

    private PluginProxy loadProxy(File proxyFile) {
        JavaPluginProxy proxy;
        String lcFileName = proxyFile.getName().toLowerCase();
        if (!lcFileName.endsWith(".proxy")) {
            mLog.warning("not a valid proxy file " + proxyFile.getAbsolutePath());
            return null;
        }
        if (proxyFile.canRead() && (proxy = this.readPluginProxy(proxyFile)) != null) {
            PluginProxyManager.getInstance().registerPlugin(proxy);
            if (new File(proxy.getPluginFileName()).getParentFile().equals(new File(Settings.propPluginsDirectory.getString()))) {
                File pluginFile = new File(proxy.getPluginFileName());
                this.mDeleteablePlugin.put(proxy, pluginFile);
            }
            return proxy;
        }
        return null;
    }

    public Object loadPlugin(File pluginFile, boolean deleteable) {
        Object plugin;
        block25: {
            plugin = null;
            String lcFileName = pluginFile.getName().toLowerCase();
            if (this.mSuccessfullyLoadedPluginFiles.contains(lcFileName)) {
                mLog.warning("cannot load plugin " + pluginFile.getAbsolutePath() + " - already loaded");
                return null;
            }
            try {
                if (lcFileName.endsWith(".jar")) {
                    plugin = this.loadJavaPlugin(pluginFile);
                } else if (lcFileName.endsWith(".bsh")) {
                    plugin = this.loadBeanShellPlugin(pluginFile);
                } else {
                    mLog.warning("Unknown plugin type: " + pluginFile.getAbsolutePath());
                }
                if (plugin instanceof Plugin) {
                    JavaPluginProxy javaplugin = (JavaPluginProxy)PluginProxyManager.getInstance().getPluginForId(JavaPluginProxy.getJavaPluginId((Plugin)plugin));
                    if (javaplugin != null) {
                        javaplugin.setPlugin((Plugin)plugin, pluginFile.getPath());
                    } else {
                        javaplugin = new JavaPluginProxy((Plugin)plugin, pluginFile.getPath());
                        PluginProxyManager.getInstance().registerPlugin(javaplugin);
                    }
                    if (this.mNewInstalledPlugins.contains(pluginFile.getAbsolutePath())) {
                        String iconText = ((Plugin)plugin).getProgramTableIconText();
                        if (iconText != null && !iconText.isEmpty() && !Settings.propProgramTableIconPlugins.containsItem(((Plugin)plugin).getId())) {
                            Settings.propProgramTableIconPlugins.addItem(((Plugin)plugin).getId());
                        }
                        if (!Settings.propKnownContextMenuPlugins.containsItem(((Plugin)plugin).getId())) {
                            ActionMenu test = ((Plugin)plugin).getContextMenuActions(PluginManagerImpl.getInstance().getExampleProgram());
                            if (test != null) {
                                this.mShowMouseInfo = true;
                            }
                            Settings.propKnownContextMenuPlugins.addItem(((Plugin)plugin).getId());
                        }
                    }
                    if (deleteable) {
                        this.mDeleteablePlugin.put(javaplugin, pluginFile);
                    }
                    this.saveProxyInfo(pluginFile, javaplugin);
                } else if (plugin instanceof AbstractPluginProxy) {
                    PluginProxyManager.getInstance().registerPlugin((AbstractPluginProxy)plugin);
                    if (deleteable) {
                        this.mDeleteablePlugin.put(plugin, pluginFile);
                    }
                } else if (plugin instanceof AbstractTvDataService) {
                    DefaultTvDataServiceProxy proxy = new DefaultTvDataServiceProxy((AbstractTvDataService)plugin);
                    TvDataServiceProxyManager.getInstance().registerTvDataService(proxy);
                    if (deleteable) {
                        this.mDeleteablePlugin.put(proxy, pluginFile);
                    }
                }
                if (plugin == null) break block25;
                String version = null;
                if (plugin instanceof Plugin || plugin instanceof AbstractTvDataService) {
                    try {
                        Method m = plugin.getClass().getMethod("getVersion", new Class[0]);
                        Object o = m.invoke(plugin, new Object[0]);
                        if (o instanceof Version) {
                            version = ((Version)o).toString();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                this.mSuccessfullyLoadedPluginFiles.add(lcFileName);
                mLog.info("Loaded plugin " + pluginFile.getAbsolutePath() + (version != null ? " - " + version : ""));
            }
            catch (Throwable thr) {
                mLog.log(Level.WARNING, "Loading plugin file failed: " + pluginFile.getAbsolutePath(), thr);
                thr.printStackTrace();
            }
        }
        return plugin;
    }

    private JavaPluginProxy readPluginProxy(File proxyFile) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(proxyFile)));
            String name = ((DataInputStream)in).readUTF();
            String author = ((DataInputStream)in).readUTF();
            String description = ((DataInputStream)in).readUTF();
            String license = ((DataInputStream)in).readUTF();
            DummyPlugin.setCurrentVersion(new Version((DataInputStream)in));
            String pluginId = ((DataInputStream)in).readUTF();
            ((DataInputStream)in).readLong();
            String lcFileName = ((DataInputStream)in).readUTF();
            String category = ((DataInputStream)in).readUTF();
            in.close();
            File pluginFile = new File(lcFileName);
            if (!pluginFile.canRead()) {
                this.deletePluginProxy(proxyFile);
                return null;
            }
            PluginInfo info = new PluginInfo(DummyPlugin.class, name, description, author, license);
            String iconFileName = this.getProxyIconFileName(proxyFile);
            return new JavaPluginProxy(info, lcFileName, pluginId, iconFileName, category);
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            this.deletePluginProxy(proxyFile);
            return null;
        }
    }

    private void deletePluginProxy(File proxyFile) {
        String iconName = this.getProxyIconFileName(proxyFile);
        proxyFile.delete();
        File iconFile = new File(iconName);
        iconFile.delete();
    }

    private void saveProxyInfo(File pluginFile, JavaPluginProxy proxy) {
        try {
            Icon pluginIcon;
            String proxyFileName = this.getProxyFileName(pluginFile);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(proxyFileName)));
            PluginInfo info = proxy.getInfo();
            out.writeUTF(info.getName());
            out.writeUTF(info.getAuthor());
            out.writeUTF(info.getDescription());
            String license = info.getLicense();
            if (license == null) {
                license = "";
            }
            out.writeUTF(license);
            info.getVersion().writeData(out);
            out.writeUTF(proxy.getId());
            out.writeLong(pluginFile.length());
            out.writeUTF(proxy.getPluginFileName());
            out.writeUTF(proxy.getPluginCategory());
            out.close();
            String iconFileName = this.getProxyIconFileName(pluginFile);
            File iconFile = new File(iconFileName);
            if (!iconFile.exists() && (pluginIcon = proxy.getPluginIcon()) != null && pluginIcon instanceof ImageIcon) {
                IOUtilities.writeImageIconToFile((ImageIcon)pluginIcon, "png", iconFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getProxyIconFileName(File pluginFile) {
        String name = pluginFile.getName();
        name = StringUtils.substringBefore(name, ".");
        return Settings.getUserSettingsDirName() + File.separatorChar + name + ".icon.png";
    }

    private String getProxyFileName(File pluginFile) {
        return Settings.getUserSettingsDirName() + File.separatorChar + pluginFile.getName() + ".proxy";
    }

    private void loadPlugins(File folder, boolean deleteable) {
        File[] fileArr;
        if (this.loadedProxies == null) {
            File settingsDir;
            File[] proxyFiles;
            this.loadedProxies = new ArrayList();
            final String[] deactivatedPluginArr = Settings.propDeactivatedPlugins.getStringArray();
            if (deactivatedPluginArr != null && deactivatedPluginArr.length > 0 && (proxyFiles = (settingsDir = new File(Settings.getUserSettingsDirName())).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir2, String name) {
                    if (!name.endsWith(PluginLoader.PLUGIN_PROXY_EXTENSION)) {
                        return false;
                    }
                    String mainName = name.substring(0, name.length() - PluginLoader.PLUGIN_PROXY_EXTENSION.length()).toLowerCase();
                    for (String deactivatedId : deactivatedPluginArr) {
                        if (!deactivatedId.contains(mainName)) continue;
                        return true;
                    }
                    return false;
                }
            })) != null) {
                for (File proxyFile : proxyFiles) {
                    PluginProxy proxy = this.loadProxy(proxyFile);
                    if (proxy != null) {
                        this.loadedProxies.add(proxy);
                        mLog.info("Loaded plugin proxy " + proxyFile);
                        continue;
                    }
                    mLog.warning("Failed loading plugin proxy " + proxyFile);
                }
            }
        }
        if ((fileArr = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String fileName) {
                for (String ignored : IGNORED_PLUGINS) {
                    if (!fileName.equalsIgnoreCase(ignored)) continue;
                    return false;
                }
                return true;
            }
        })) == null) {
            return;
        }
        File oldService = null;
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(fileArr));
        block1: for (File file : fileArr) {
            if (!file.getName().equalsIgnoreCase("CleverEPGDataService3.jar")) continue;
            for (File file2 : files) {
                if (!file2.getName().equalsIgnoreCase("CleverEPGDataService.jar")) continue;
                oldService = file2;
                continue block1;
            }
        }
        if (oldService != null) {
            files.remove(oldService);
        }
        for (File file : files) {
            boolean load = true;
            for (PluginProxy proxy : this.loadedProxies) {
                if (!proxy.getPluginFileName().equalsIgnoreCase(file.getPath())) continue;
                load = false;
                break;
            }
            if (!load) continue;
            this.loadPlugin(file, deleteable);
        }
    }

    public void loadAllPlugins() {
        String[] files = Settings.propDeleteFilesAtStart.getStringArray();
        if (files != null && files.length > 0) {
            for (String file : files) {
                try {
                    mLog.info("Deleting " + file);
                    new File(file).delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Settings.propDeleteFilesAtStart.setStringArray(new String[0]);
        }
        String pluginsFolderName = Settings.propPluginsDirectory.getString();
        File f = new File(pluginsFolderName);
        boolean success = true;
        if (!f.exists() && !f.mkdirs()) {
            mLog.warning("Could not create plugins folder " + f.getAbsolutePath());
            success = false;
        }
        if (success) {
            this.loadPlugins(f, true);
        }
        this.loadPlugins(new File("plugins"), false);
        this.loadPlugins(new File("tvdataservice"), false);
    }

    private Object loadJavaPlugin(File jarFile) throws TvBrowserException {
        String pluginName;
        URLClassLoader classLoader;
        Object plugin = null;
        URLClassLoader classLoader2 = null;
        try {
            URL[] urls = new URL[]{jarFile.toURI().toURL()};
            classLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
            try {
                if (!new File(PLUGIN_DIRECTORY).equals(jarFile.getParentFile()) && new File(PLUGIN_DIRECTORY, jarFile.getName()).isFile()) {
                    urls = new URL[]{new File(PLUGIN_DIRECTORY, jarFile.getName()).toURI().toURL()};
                    classLoader2 = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
                }
            }
            catch (MalformedURLException exc) {}
        }
        catch (MalformedURLException exc) {
            throw new TvBrowserException(this.getClass(), "error.1", "Loading Jar file of a plugin failed: {0}.", (Object)jarFile.getAbsolutePath(), (Throwable)exc);
        }
        if ((pluginName = jarFile.getName()).endsWith(".jar")) {
            pluginName = pluginName.substring(0, pluginName.length() - 4);
        }
        boolean isBlockedDataService = false;
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginName.toLowerCase() + "." + pluginName);
            Method getVersion = pluginClass.getMethod("getVersion", new Class[0]);
            Version version1 = null;
            try {
                version1 = (Version)getVersion.invoke(pluginClass, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (version1 == null || version1.toString().equals("0.0.0.0")) {
                mLog.warning("Did not load plugin " + pluginName + ", version is too old.");
                return null;
            }
            if (pluginClass.getSuperclass().equals(AbstractTvDataService.class) || classLoader2 != null) {
                getVersion = pluginClass.getMethod("getVersion", new Class[0]);
                version1 = (Version)getVersion.invoke(pluginClass, new Object[0]);
                if (pluginClass.getSuperclass().equals(AbstractTvDataService.class)) {
                    isBlockedDataService = Settings.propBlockedPluginArray.isBlocked(pluginName.toLowerCase() + "." + pluginName, version1);
                }
            }
            if (classLoader2 != null) {
                try {
                    Class<?> pluginClass2 = classLoader2.loadClass(pluginName.toLowerCase() + "." + pluginName);
                    Method getVersion2 = pluginClass2.getMethod("getVersion", new Class[0]);
                    Version version2 = (Version)getVersion2.invoke(pluginClass2, new Object[0]);
                    if (version2.compareTo(version1) > 0) {
                        return null;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            try {
                Method preInstancing = pluginClass.getMethod("preInstancing", new Class[0]);
                preInstancing.invoke(pluginClass, new Object[0]);
            }
            catch (Throwable ti) {
                // empty catch block
            }
            if (!isBlockedDataService) {
                plugin = pluginClass.newInstance();
            }
        }
        catch (Throwable thr) {
            throw new TvBrowserException(this.getClass(), "error.2", "Could not load plugin {0}.", (Object)jarFile.getAbsolutePath(), thr);
        }
        return plugin;
    }

    private Object loadBeanShellPlugin(File file) {
        return new BeanShellPluginProxy(file);
    }

    public boolean deletePlugin(PluginProxy proxy) {
        if (this.deletePluginOrService(proxy)) {
            try {
                PluginProxyManager.getInstance().removePlugin(proxy);
            }
            catch (TvBrowserException exc) {
                ErrorHandler.handle(exc);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean deleteDataService(TvDataServiceProxy service) {
        return this.deletePluginOrService(service);
    }

    private boolean deletePluginOrService(Object plugin) {
        File file = this.mDeleteablePlugin.get(plugin);
        if (file != null) {
            Settings.propDeleteFilesAtStart.addItem(file.toString());
            String proxyFile = this.getProxyFileName(file);
            Settings.propDeleteFilesAtStart.addItem(proxyFile);
            this.mDeleteablePlugin.remove(plugin);
            return true;
        }
        return false;
    }

    public boolean isPluginDeletable(PluginProxy plugin) {
        return this.mDeleteablePlugin.containsKey(plugin);
    }

    public boolean isDataServiceDeletable(TvDataServiceProxy service) {
        return this.mDeleteablePlugin.containsKey(service);
    }

    public void deleteAllPluginProxies() {
        File settingsDir = new File(Settings.getUserSettingsDirName());
        File[] proxyFiles = settingsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.endsWith(PluginLoader.PLUGIN_PROXY_EXTENSION);
            }
        });
        if (proxyFiles != null) {
            for (File proxyFile : proxyFiles) {
                Settings.propDeleteFilesAtStart.addItem(proxyFile.toString());
            }
        }
    }

    public PluginBaseInfo[] getInfoOfAvailablePlugins() {
        ArrayList<PluginBaseInfo> availablePlugins = new ArrayList<PluginBaseInfo>();
        this.getBaseInfoOfPluginsInDirectory(new File(Settings.propPluginsDirectory.getString()), availablePlugins);
        this.getBaseInfoOfPluginsInDirectory(new File("plugins"), availablePlugins);
        this.getBaseInfoOfPluginsInDirectory(new File("tvdataservice"), availablePlugins);
        return availablePlugins.toArray(new PluginBaseInfo[availablePlugins.size()]);
    }

    private void getBaseInfoOfPluginsInDirectory(File directory, ArrayList<PluginBaseInfo> availablePlugins) {
        if (directory.exists()) {
            File[] pluginFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir2, String name) {
                    for (String ignored : IGNORED_PLUGINS) {
                        if (!name.equalsIgnoreCase(ignored)) continue;
                        return false;
                    }
                    return name.toLowerCase().endsWith(".jar");
                }
            });
            this.getBaseInfoOfPlugins(pluginFiles, availablePlugins);
        }
    }

    private void getBaseInfoOfPlugins(File[] plugins, ArrayList<PluginBaseInfo> availablePlugins) {
        for (File plugin : plugins) {
            URL[] urls;
            File temp = new File(System.getProperty("java.io.tmpdir"), "tvbTestPlugins");
            if (!temp.isDirectory()) {
                temp.mkdirs();
            }
            File pluginCopy = new File(temp, plugin.getName());
            try {
                if (pluginCopy.isFile()) {
                    pluginCopy.delete();
                }
                IOUtilities.copy(plugin, pluginCopy);
                pluginCopy.deleteOnExit();
            }
            catch (IOException e1) {
                pluginCopy = plugin;
            }
            String pluginName = pluginCopy.getName();
            pluginName = pluginName.substring(0, pluginName.length() - 4);
            Class<?> pluginClass = null;
            try {
                urls = new URL[]{pluginCopy.toURI().toURL()};
                URLClassLoader classLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
                pluginClass = classLoader.loadClass(pluginName.toLowerCase() + "." + pluginName);
                Method getVersion = pluginClass.getMethod("getVersion", new Class[0]);
                try {
                    Version version = (Version)getVersion.invoke(pluginClass, new Object[0]);
                    PluginBaseInfo baseInfo = new PluginBaseInfo("java." + pluginClass.getName(), version);
                    if (availablePlugins.contains(baseInfo)) continue;
                    availablePlugins.add(baseInfo);
                }
                catch (Exception e) {}
            }
            catch (Throwable t) {
                urls = null;
                pluginClass = null;
                System.gc();
                PluginBaseInfo baseInfo = new PluginBaseInfo("java." + pluginName.toLowerCase() + "." + pluginName, new Version(0, 0));
                if (!availablePlugins.contains(baseInfo)) {
                    availablePlugins.add(baseInfo);
                }
                mLog.info("Could not load base info for plugin file '" + plugin.getAbsolutePath() + "'. Use default version instead.");
            }
        }
    }

    public boolean hasToShowMouseInfo() {
        return this.mShowMouseInfo;
    }

    static {
        PLUGIN_DIRECTORY = "plugins";
    }
}

