/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.ChannelGroupManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ChannelListChangesDialog;
import tvdataservice.MarkedProgramsMap;
import tvdataservice.MutableChannelDayProgram;
import tvdataservice.TvDataUpdateManager;
import util.exc.ErrorHandler;
import util.io.NetworkUtilities;
import util.ui.EnhancedPanelBuilder;
import util.ui.Localizer;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.progress.ProgressBarProgressMonitor;
import util.ui.progress.ProgressMonitorGroup;

public class TvDataUpdater {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TvDataUpdater.class);
    private static final Logger mLog = Logger.getLogger(TvDataUpdater.class.getName());
    private static TvDataUpdater mSingleton;
    private boolean mIsDownloading;
    private boolean mIsUpdating;
    private boolean mStopDownloading = false;
    private boolean mTvDataWasChanged = false;
    private ArrayList<TvDataUpdateListener> mListenerList;
    private HashSet<ChannelDay> mRecalculatePrograms = new HashSet();

    private TvDataUpdater() {
        this.mListenerList = new ArrayList();
    }

    public static synchronized TvDataUpdater getInstance() {
        if (mSingleton == null) {
            mSingleton = new TvDataUpdater();
        }
        return mSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTvDataUpdateListener(TvDataUpdateListener listener) {
        ArrayList<TvDataUpdateListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            this.mListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTvDataUpdateListener(TvDataUpdateListener listener) {
        ArrayList<TvDataUpdateListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            this.mListenerList.remove(listener);
        }
    }

    public boolean isDownloading() {
        return this.mIsDownloading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTvData(int daysToDownload, TvDataServiceProxy[] services, JProgressBar progressBar, JLabel label) {
        Object dataService;
        if (!TvDataServiceProxyManager.getInstance().licensesAccepted(services)) {
            return;
        }
        this.mIsDownloading = true;
        this.mStopDownloading = false;
        this.mTvDataWasChanged = false;
        this.mIsUpdating = true;
        this.fireTvDataUpdateStarted(Date.getCurrentDate().addDays(daysToDownload));
        daysToDownload += 2;
        File tvdataDir = new File(Settings.propTVDataDirectory.getString());
        if (!tvdataDir.exists()) {
            tvdataDir.mkdir();
        }
        TvDataUpdateManager updateManager = new TvDataUpdateManager(){
            private boolean mMessageShown = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDayProgram(MutableChannelDayProgram program) {
                TvDataUpdater.this.mTvDataWasChanged = true;
                TvDataUpdater.this.doUpdateDayProgram(program);
                HashSet hashSet = TvDataUpdater.this.mRecalculatePrograms;
                synchronized (hashSet) {
                    TvDataUpdater.this.mRecalculatePrograms.add(new ChannelDay(program.getChannel(), program.getDate()));
                    TvDataUpdater.this.mRecalculatePrograms.add(new ChannelDay(program.getChannel(), program.getDate().addDays(-1)));
                }
            }

            @Override
            public boolean isDayProgramAvailable(Date date, Channel channel) {
                return TvDataBase.getInstance().isDayProgramAvailable(date, channel);
            }

            @Override
            public boolean cancelDownload() {
                return TvDataUpdater.this.mStopDownloading;
            }

            @Override
            public boolean checkConnection() {
                boolean result = NetworkUtilities.checkConnection();
                if (!result && !this.mMessageShown) {
                    this.mMessageShown = true;
                    try {
                        UIThreadRunner.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, mLocalizer.msg("noConnectionMessage", "No connection!"), mLocalizer.msg("noConnectionTitle", "No connection!"), 0);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
        };
        Date startDate = new Date().addDays(-1);
        Channel[] subscribedChannels = ChannelList.getSubscribedChannels();
        UpdateJob[] jobArr = this.toUpdateJobArr(subscribedChannels, services);
        ProgressMonitorGroup monitorGroup = new ProgressMonitorGroup(progressBar, label, subscribedChannels.length + 1);
        Throwable downloadException = null;
        for (int i = 0; i < jobArr.length && !this.mStopDownloading; ++i) {
            dataService = jobArr[i].getDataService();
            Channel[] channelArr = jobArr[i].getChannelList();
            ProgressMonitor monitor = monitorGroup.getNextProgressMonitor(channelArr.length);
            try {
                dataService.updateTvData(updateManager, channelArr, startDate, daysToDownload, monitor);
                continue;
            }
            catch (Throwable thr) {
                mLog.log(Level.WARNING, "Updating the TV data for TV data service " + dataService.getInfo().getName() + " failed", thr);
                downloadException = thr;
            }
        }
        if (downloadException != null) {
            String msg = mLocalizer.msg("error.1", "Couldn't download the whole program!");
            ErrorHandler.handle(msg, downloadException);
        }
        this.mIsDownloading = false;
        this.checkLocalDateUsingNTP();
        ProgressBarProgressMonitor monitor = new ProgressBarProgressMonitor(progressBar, label);
        monitor.setMessage(mLocalizer.msg("calculateEntries", "Calculating new entries in the database"));
        dataService = this.mRecalculatePrograms;
        synchronized (dataService) {
            monitor.setMaximum(this.mRecalculatePrograms.size());
        }
        monitor.setValue(0);
        int value = 0;
        HashSet<ChannelDay> hashSet = this.mRecalculatePrograms;
        synchronized (hashSet) {
            for (ChannelDay next : this.mRecalculatePrograms) {
                monitor.setValue(value++);
                TvDataBase.getInstance().reCalculateTvData(next.getChannel(), next.getDate());
            }
            this.mRecalculatePrograms.clear();
        }
        TvDataBase.getInstance().updateTvDataBase();
        this.mIsUpdating = false;
        MarkedProgramsMap.getInstance().revalidatePrograms();
        TvDataBase.getInstance().sendNewProgramsToTvDataListener();
        FavoritesPlugin.getInstance().waitForFinishingUpdateThreads();
        this.checkAndUpdateChannelList(new ProgressBarProgressMonitor(progressBar, label));
        this.fireTvDataUpdateFinished();
        monitor.setMessage("");
        this.checkLocalTime();
        this.mTvDataWasChanged = false;
        this.showInfoDialog();
    }

    private void checkAndUpdateChannelList(ProgressMonitor monitor) {
        int channelAutoUpdatePeriod = Settings.propAutoChannelUpdatePeriod.getInt();
        if (channelAutoUpdatePeriod > -1) {
            Date compare = new Date().addDays(-channelAutoUpdatePeriod + 1);
            if (Settings.propLastChannelUpdate.getDate() == null || Settings.propLastChannelUpdate.getDate().compareTo(compare) < 0) {
                Channel[] currentChannels = ChannelList.getAvailableChannels();
                int currentNetworkTimeout = Settings.propDefaultNetworkConnectionTimeout.getInt();
                Settings.propDefaultNetworkConnectionTimeout.setInt(5000);
                ChannelGroupManager.getInstance().checkForAvailableGroupsAndChannels(monitor);
                ChannelList.reload();
                Settings.propDefaultNetworkConnectionTimeout.setInt(currentNetworkTimeout);
                ChannelListChangesDialog.showChannelChanges(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), Arrays.asList(currentChannels), Arrays.asList(ChannelList.getAvailableChannels()), true);
                Settings.updateChannelFilters(ChannelList.getSubscribedChannels());
            }
        }
    }

    private void showInfoDialog() {
        new Thread("After update info showing"){

            @Override
            public void run() {
                PluginProxy[] pluginProxys;
                EnhancedPanelBuilder pb = new EnhancedPanelBuilder("5dlu,min:grow,5dlu");
                final JPanel centerPanel = pb.getPanel();
                AfterDataUpdateInfoPanel.AfterDataUpdateInfoPanelListener infoPanelListener = new AfterDataUpdateInfoPanel.AfterDataUpdateInfoPanelListener(){

                    @Override
                    public void remove(AfterDataUpdateInfoPanel infoPanel) {
                        for (int i = centerPanel.getComponentCount() - 1; i >= 0; --i) {
                            Component c = centerPanel.getComponent(i);
                            if (c == null || !c.equals(infoPanel)) continue;
                            centerPanel.remove(i);
                            centerPanel.remove(i - 1);
                            break;
                        }
                        infoPanel.closed();
                        centerPanel.updateUI();
                    }
                };
                CellConstraints cc = new CellConstraints();
                InternalPluginProxyIf[] internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys();
                boolean showDialog = false;
                for (InternalPluginProxyIf internalPlugin : internalPlugins) {
                    AfterDataUpdateInfoPanel test = internalPlugin.getAfterDataUpdateInfoPanel();
                    if (test == null) continue;
                    test.setAfterDataUpdateInfoPanelListener(infoPanelListener);
                    pb.addParagraph(internalPlugin.getName());
                    pb.addGrowingRow();
                    pb.add((Component)test, cc.xy(2, pb.getRowCount()));
                    showDialog = true;
                }
                for (PluginProxy pluginProxy : pluginProxys = PluginProxyManager.getInstance().getActivatedPlugins()) {
                    AfterDataUpdateInfoPanel test = pluginProxy.getAfterDataUpdateInfoPanel();
                    if (test == null) continue;
                    test.setAfterDataUpdateInfoPanelListener(infoPanelListener);
                    pb.addParagraph(pluginProxy.getInfo().getName());
                    pb.addGrowingRow();
                    pb.add((Component)test, cc.xy(2, pb.getRowCount()));
                    showDialog = true;
                }
                if (showDialog) {
                    final JDialog infoDialog = new JDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
                    infoDialog.setTitle(mLocalizer.msg("afterUpdateInfo", "Informations of data update"));
                    JScrollPane scrollPane = new JScrollPane(centerPanel);
                    scrollPane.setBorder(BorderFactory.createEmptyBorder());
                    JPanel center = new JPanel(new BorderLayout());
                    center.setBorder(Borders.DIALOG);
                    center.add((Component)scrollPane, "Center");
                    JButton close = new JButton(Localizer.getLocalization("i18n_close"));
                    close.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            infoDialog.dispose();
                        }
                    });
                    JPanel buttons = new JPanel(new FormLayout("min:grow,default,min:grow", "5dlu,default,5dlu,default"));
                    buttons.add((Component)new JSeparator(0), cc.xyw(1, 2, 3));
                    buttons.add((Component)close, cc.xy(2, 4));
                    center.add((Component)buttons, "South");
                    infoDialog.setContentPane(center);
                    infoDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            for (int i = 0; i < centerPanel.getComponentCount(); ++i) {
                                Component c = centerPanel.getComponent(i);
                                if (!(c instanceof AfterDataUpdateInfoPanel)) continue;
                                ((AfterDataUpdateInfoPanel)c).closed();
                            }
                        }
                    });
                    WindowClosingIf closing = new WindowClosingIf(){

                        @Override
                        public JRootPane getRootPane() {
                            return infoDialog.getRootPane();
                        }

                        @Override
                        public void close() {
                            infoDialog.dispose();
                        }
                    };
                    UiUtilities.registerForClosing(closing);
                    Settings.layoutWindow("AfterTvDataUpdateInfoDialog", infoDialog, new Dimension(900, 500));
                    infoDialog.setVisible(true);
                }
            }
        }.start();
    }

    public boolean isUpdating() {
        return this.mIsUpdating;
    }

    private void checkLocalTime() {
        if (this.tvDataWasChanged()) {
            int count = 0;
            count += this.wrongTimeZone("Das Erste (ARD)", "Tagesschau", 1200);
            count += this.wrongTimeZone("ZDF", "ZDF-Morgenmagazin", 330);
            count += this.wrongTimeZone("Sat.1", "Sat.1 Nachrichten", 1200);
            if ((count += this.wrongTimeZone("RTL2", "RTL II News", 1200)) >= 2) {
                DontShowAgainOptionBox.showOptionDialog("wrongTimeZone", null, mLocalizer.msg("timezone", ""));
            }
        }
    }

    private int wrongTimeZone(String channelName, String programTitle, int minutesAfterMidnight) {
        Date currentDate = Date.getCurrentDate();
        for (Channel channel : ChannelList.getSubscribedChannels()) {
            if (!channel.getDefaultName().equalsIgnoreCase(channelName)) continue;
            int wrongDays = 0;
            block1: for (int days = 0; days < 3; ++days) {
                Iterator<Program> it;
                ChannelDayProgram dayProgram = TvDataBase.getInstance().getDayProgram(currentDate.addDays(days), channel);
                if (dayProgram == null || (it = dayProgram.getPrograms()) == null) continue;
                while (it.hasNext()) {
                    int delta;
                    Program program = it.next();
                    if (!program.getTitle().equals(programTitle) || (delta = Math.abs(program.getStartTime() - minutesAfterMidnight)) != 60 && delta != 120) continue;
                    ++wrongDays;
                    continue block1;
                }
            }
            if (wrongDays >= 3) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private void checkLocalDateUsingNTP() {
        if (!this.tvDataWasChanged() && Settings.propNTPTimeCheck.getBoolean() && (Settings.propLastNTPCheck.getDate() == null || Settings.propLastNTPCheck.getDate().compareTo(Date.getCurrentDate()) < 0)) {
            Settings.propLastNTPCheck.setDate(Date.getCurrentDate());
            int serverNum = (int)(Math.random() * 4.0);
            int differenceSecs = NetworkUtilities.getTimeDifferenceSeconds(Integer.toString(serverNum) + ".tvbrowser.pool.ntp.org");
            if (Math.abs(differenceSecs) >= 86400) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                Calendar date = Calendar.getInstance();
                String localTime = dateFormat.format(date.getTime());
                date.add(13, differenceSecs);
                String internetTime = dateFormat.format(date.getTime());
                JOptionPane.showMessageDialog(null, mLocalizer.msg("downloadFailed", "TV-Browser could not download any data. A check with an internet time server showed that your local computer time differs more than a day from the official time.\n\nPlease check the date and time settings of your computer.\n\nYour date and time: {0}\nInternet date and time: {1}", localTime, internetTime), Localizer.getLocalization("i18n_error"), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTvDataUpdateStarted(Date until) {
        ArrayList<TvDataUpdateListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            for (int i = 0; i < this.mListenerList.size(); ++i) {
                TvDataUpdateListener lst = this.mListenerList.get(i);
                try {
                    lst.tvDataUpdateStarted(until);
                    continue;
                }
                catch (Throwable thr) {
                    mLog.log(Level.WARNING, "Firing event 'TV data update started' failed", thr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTvDataUpdateFinished() {
        ArrayList<TvDataUpdateListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            for (int i = 0; i < this.mListenerList.size(); ++i) {
                TvDataUpdateListener lst = this.mListenerList.get(i);
                try {
                    lst.tvDataUpdateFinished();
                    continue;
                }
                catch (Throwable thr) {
                    mLog.log(Level.WARNING, "Firing event 'TV data update finished' failed", thr);
                }
            }
        }
    }

    public void stopDownload() {
        this.mStopDownloading = true;
    }

    private void doUpdateDayProgram(MutableChannelDayProgram program) {
        TvDataBase.getInstance().setDayProgram(program);
    }

    private UpdateJob[] toUpdateJobArr(Channel[] subscribedChannels, TvDataServiceProxy[] services) {
        ArrayList<UpdateJob> jobList = new ArrayList<UpdateJob>();
        for (Channel channel : subscribedChannels) {
            if (channel instanceof DummyChannel) continue;
            UpdateJob job = null;
            for (int i = 0; i < jobList.size(); ++i) {
                UpdateJob currJob = (UpdateJob)jobList.get(i);
                if (!currJob.getDataService().getId().equals(channel.getDataServiceId())) continue;
                job = currJob;
                break;
            }
            if (job == null) {
                TvDataServiceProxy service = channel.getDataServiceProxy();
                boolean useService = false;
                for (TvDataServiceProxy service2 : services) {
                    if (!service2.getId().equals(service.getId())) continue;
                    useService = true;
                    break;
                }
                if (!useService) continue;
                job = new UpdateJob(channel.getDataServiceProxy());
                jobList.add(job);
            }
            job.addChannel(channel);
        }
        UpdateJob[] jobArr = new UpdateJob[jobList.size()];
        jobList.toArray(jobArr);
        return jobArr;
    }

    public boolean tvDataWasChanged() {
        return this.mTvDataWasChanged;
    }

    private class ChannelDay {
        private Date mDate;
        private Channel mChannel;

        public ChannelDay(Channel channel, Date date) {
            this.mChannel = channel;
            this.mDate = date;
        }

        public Date getDate() {
            return this.mDate;
        }

        public Channel getChannel() {
            return this.mChannel;
        }

        public int hashCode() {
            return this.mDate.hashCode() + this.mChannel.hashCode();
        }

        public boolean equals(Object obj) {
            ChannelDay oth = (ChannelDay)obj;
            return this.mDate.equals(oth.getDate()) && this.mChannel.equals(oth.getChannel());
        }
    }

    private static class UpdateJob {
        private TvDataServiceProxy mTvDataServiceProxy;
        private ArrayList<Channel> mChannelList;

        public UpdateJob(TvDataServiceProxy dataService) {
            this.mTvDataServiceProxy = dataService;
            this.mChannelList = new ArrayList();
        }

        public void addChannel(Channel channel) {
            this.mChannelList.add(channel);
        }

        public TvDataServiceProxy getDataService() {
            return this.mTvDataServiceProxy;
        }

        public Channel[] getChannelList() {
            Channel[] channelArr = new Channel[this.mChannelList.size()];
            this.mChannelList.toArray(channelArr);
            return channelArr;
        }
    }
}

