/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import bsh.EvalError;
import bsh.Interpreter;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.beanshell.BeanShellProgramFilterIf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.exc.ErrorHandler;
import util.ui.LineNumberHeader;
import util.ui.Localizer;
import util.ui.beanshell.BeanShellEditor;

public class BeanShellFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(BeanShellFilterComponent.class);
    private BeanShellEditor mScriptEditor;
    private String mScriptSource = "import devplugin.beanshell.BeanShellProgramFilterIf;\nimport devplugin.Program;\nimport devplugin.ProgramFieldType;\n\naccept(Program p) {\n\n\t// " + mLocalizer.msg("addCodeHere", "Add Code here!") + "\n\n" + "\treturn true;\n" + "}\n\n" + "return (BeanShellProgramFilterIf) this;";
    private BeanShellProgramFilterIf mScript;

    public BeanShellFilterComponent() {
        this("", "");
    }

    public BeanShellFilterComponent(String name, String description) {
        super(name, description);
    }

    private void compileSource() throws EvalError {
        if (this.mScriptSource != null && this.mScript == null) {
            this.mScript = (BeanShellProgramFilterIf)new Interpreter().eval(this.mScriptSource);
        }
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mScriptSource = (String)in.readObject();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mScriptSource);
    }

    public String toString() {
        return mLocalizer.msg("BeanShellFilter", "BeanShell-Filter");
    }

    @Override
    public void saveSettings() {
        this.mScriptSource = this.mScriptEditor.getText();
        try {
            this.mScript = null;
            this.compileSource();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mScript = null;
        }
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel(new BorderLayout());
        this.mScriptEditor = new BeanShellEditor();
        this.mScriptEditor.setText(this.mScriptSource);
        JScrollPane scrollPane = new JScrollPane(this.mScriptEditor);
        scrollPane.setBackground(Color.WHITE);
        LineNumberHeader header = new LineNumberHeader(this.mScriptEditor);
        scrollPane.setRowHeaderView(header);
        content.add((Component)scrollPane, "Center");
        JPanel buttonp = new JPanel(new FlowLayout(2));
        JButton test = new JButton(mLocalizer.msg("testScript", "Test Script"));
        test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BeanShellFilterComponent.this.testScript();
            }
        });
        buttonp.add(test);
        content.add((Component)buttonp, "South");
        return content;
    }

    protected void testScript() {
        boolean error = false;
        try {
            BeanShellProgramFilterIf filter = (BeanShellProgramFilterIf)new Interpreter().eval(this.mScriptEditor.getText());
            filter.accept(Plugin.getPluginManager().getExampleProgram());
        }
        catch (Exception e) {
            ErrorHandler.handle(mLocalizer.msg("errorParsing", "Error while parsing Script"), e);
            error = true;
        }
        if (!error) {
            JOptionPane.showMessageDialog(null, mLocalizer.msg("SyntaxOK", "Syntax is OK."));
        }
    }

    @Override
    public boolean accept(Program program) {
        try {
            if (this.mScript == null) {
                this.compileSource();
            }
            return this.mScript.accept(program);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

