/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import devplugin.ThemeIcon;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import tvbrowser.core.icontheme.Directory;
import util.io.IniFileReader;
import util.ui.UiUtilities;

public abstract class IconTheme
implements Comparable<IconTheme> {
    private File mIconBase;
    private static final Logger mLog = Logger.getLogger(IconTheme.class.getName());
    private String mThemeName;
    private String mThemeComment;
    private ArrayList<Directory> mDirectories;

    public IconTheme(File iconDir) {
        this.mIconBase = iconDir;
    }

    public boolean loadTheme() {
        return this.loadThemeFile();
    }

    private boolean loadThemeFile() {
        try {
            this.mDirectories = new ArrayList();
            if (!this.entryExists("index.theme")) {
                return false;
            }
            IniFileReader iniReader = new IniFileReader(this.getInputStream("index.theme"));
            HashMap<String, String> iconSection = iniReader.getSection("Icon Theme");
            this.mThemeName = iconSection.get("Name");
            this.mThemeComment = iconSection.get("Comment");
            String[] directories = iconSection.get("Directories").split(",");
            int len = directories.length;
            for (int i = 0; i < len; ++i) {
                HashMap<String, String> dirMap = iniReader.getSection(directories[i]);
                String context = dirMap.get("Context");
                String type = dirMap.get("Type");
                int size = this.parseInt(dirMap.get("Size"));
                int maxsize = this.parseInt(dirMap.get("MaxSize"));
                int minsize = this.parseInt(dirMap.get("MinSize"));
                int threshold = this.parseInt(dirMap.get("Threshold"));
                Directory dir2 = new Directory(directories[i], context, type, size, maxsize, minsize, threshold);
                this.mDirectories.add(dir2);
            }
            return true;
        }
        catch (Exception e) {
            mLog.log(Level.SEVERE, "Problems loading Icon theme", e);
            e.printStackTrace();
            return false;
        }
    }

    private int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        try {
            int num = Integer.parseInt(str);
            return num;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getName() {
        return this.mThemeName;
    }

    public String getComment() {
        return this.mThemeComment;
    }

    public File getBase() {
        return this.mIconBase;
    }

    public ImageIcon getIcon(ThemeIcon icon) {
        StringBuilder iconFile;
        for (Directory dir2 : this.mDirectories) {
            if (!dir2.getName().toLowerCase().contains("/" + icon.getCategory().toLowerCase()) || !this.sizeMatches(dir2, icon.getSize()) || !this.entryExists((iconFile = new StringBuilder(dir2.getName()).append("/").append(icon.getName()).append(".png")).toString())) continue;
            if (this.getBase().isDirectory()) {
                icon.setAddress(this.getBase().getAbsolutePath() + "/" + iconFile.toString());
            } else if (this.getBase().isFile()) {
                icon.setAddress(this.getBase().getAbsolutePath() + "!/" + iconFile.toString());
            }
            return this.getImageFromTheme(iconFile.toString());
        }
        for (Directory dir2 : this.mDirectories) {
            if (!this.sizeMatches(dir2, icon.getSize()) || !this.entryExists((iconFile = new StringBuilder(dir2.getName()).append("/").append(icon.getName()).append(".png")).toString())) continue;
            if (this.getBase().isDirectory()) {
                icon.setAddress(this.getBase().getAbsolutePath() + "/" + iconFile.toString());
            } else if (this.getBase().isFile()) {
                icon.setAddress(this.getBase().getAbsolutePath() + "!/" + iconFile.toString());
            }
            return this.getImageFromTheme(iconFile.toString());
        }
        int minSize = Integer.MAX_VALUE;
        String closestMatch = null;
        for (Directory dir3 : this.mDirectories) {
            StringBuilder iconFile2;
            int distance = this.sizeDistance(dir3, icon.getSize());
            if (distance >= minSize || !this.entryExists((iconFile2 = new StringBuilder(dir3.getName()).append("/").append(icon.getName()).append(".png")).toString())) continue;
            if (this.getBase().isDirectory()) {
                icon.setAddress(this.getBase().getAbsolutePath() + "/" + iconFile2.toString());
            } else if (this.getBase().isFile()) {
                icon.setAddress(this.getBase().getAbsolutePath() + "!/" + iconFile2.toString());
            }
            closestMatch = iconFile2.toString();
            minSize = distance;
        }
        if (closestMatch != null) {
            ImageIcon closestIcon = this.getImageFromTheme(closestMatch);
            return (ImageIcon)UiUtilities.scaleIcon(closestIcon, icon.getSize(), icon.getSize());
        }
        return null;
    }

    private boolean sizeMatches(Directory dir2, int size) {
        if (dir2.getType().equals("Fixed")) {
            return size == dir2.getSize();
        }
        if (dir2.getType().equals("Scaled")) {
            return dir2.getMinSize() <= size && size <= dir2.getMaxSize();
        }
        if (dir2.getType().equals("Threshold")) {
            return dir2.getSize() - dir2.getThreshold() <= size && size <= dir2.getSize() + dir2.getThreshold();
        }
        return false;
    }

    private int sizeDistance(Directory dir2, int size) {
        if (dir2.getType().equals("Fixed")) {
            return Math.abs(dir2.getSize() - size);
        }
        if (dir2.getType().equals("Scaled")) {
            if (size < dir2.getMinSize()) {
                return dir2.getMinSize() - size;
            }
            if (size > dir2.getMaxSize()) {
                return size - dir2.getMaxSize();
            }
            return 0;
        }
        if (dir2.getType().equals("Threshold")) {
            if (size < dir2.getSize() - dir2.getThreshold()) {
                return dir2.getMinSize() - size;
            }
            if (size > dir2.getSize() + dir2.getThreshold()) {
                return size - dir2.getMaxSize();
            }
            return 0;
        }
        return 0;
    }

    public int hashCode() {
        return this.getBase().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IconTheme other = (IconTheme)obj;
        return !(this.getBase() == null ? other.getBase() != null : !this.getBase().getAbsolutePath().equalsIgnoreCase(other.getBase().getAbsolutePath()));
    }

    protected abstract InputStream getInputStream(String var1);

    protected abstract boolean entryExists(String var1);

    protected abstract ImageIcon getImageFromTheme(String var1);

    @Override
    public int compareTo(IconTheme o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }
}

