/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import tvbrowser.core.icontheme.IconTheme;

public class ZipIconTheme
extends IconTheme {
    private HashMap<String, ZipEntry> mZipFileEntries;

    public ZipIconTheme(File iconZip) {
        super(iconZip);
        this.loadEntries();
    }

    private void loadEntries() {
        this.mZipFileEntries = new HashMap();
        try {
            JarFile zf = new JarFile(this.getBase());
            Enumeration<JarEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.mZipFileEntries.put(entry.getName(), entry);
            }
        }
        catch (IOException e) {
            this.mZipFileEntries = new HashMap();
        }
    }

    @Override
    protected InputStream getInputStream(String entry) {
        ZipEntry zipEntry = this.mZipFileEntries.get(entry);
        try {
            return new JarFile(this.getBase()).getInputStream(zipEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected boolean entryExists(String entry) {
        return this.mZipFileEntries.containsKey(entry);
    }

    @Override
    protected ImageIcon getImageFromTheme(String image) {
        try {
            int offset;
            ZipEntry zipEntry = this.mZipFileEntries.get(image);
            InputStream in = new JarFile(this.getBase()).getInputStream(zipEntry);
            byte[] bytes = new byte[(int)zipEntry.getSize()];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + image);
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(bytes));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

