/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ContextMenuIf;
import devplugin.ImportanceValue;
import devplugin.PluginCommunication;
import devplugin.PluginInfo;
import devplugin.PluginTreeNode;
import devplugin.PluginsFilterComponent;
import devplugin.PluginsProgramFilter;
import devplugin.Program;
import devplugin.ProgramInfo;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.ToolTipIcon;
import java.awt.Frame;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.ActionMenuProxy;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.SettingsTabProxy;
import tvdataservice.MutableChannelDayProgram;
import tvdataservice.MutableProgram;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.Localizer;

public abstract class AbstractPluginProxy
implements PluginProxy,
ContextMenuIf {
    public static final String DEFAULT_PLUGIN_ICON_NAME = "imgs/Jar16.gif";
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(AbstractPluginProxy.class);
    private boolean mIsActivated = false;
    private PluginTreeNode mArtificialRootNode = new PluginTreeNode(this, false);

    protected AbstractPluginProxy() {
    }

    @Override
    public final boolean isActivated() {
        return this.mIsActivated;
    }

    final void setActivated(boolean activated) {
        this.mIsActivated = activated;
    }

    abstract void setParentFrame(Frame var1);

    final void loadSettings(File userDirectory) throws TvBrowserException {
        try {
            this.doLoadSettings(userDirectory);
        }
        catch (Throwable t) {
            throw new TvBrowserException(AbstractPluginProxy.class, "error.loading.runtimeException", "The plugin {0} caused an error when loading the plugin settings.", (Object)this.getInfo().getName(), t);
        }
    }

    protected abstract void doLoadSettings(File var1) throws TvBrowserException;

    final synchronized void saveSettings(File userDirectory, boolean log) throws TvBrowserException {
        if (!this.mIsActivated) {
            throw new TvBrowserException(AbstractPluginProxy.class, "error.saving.notActivated", "The plugin {0} can't save its settings, because it is not activated.", this.getInfo().getName());
        }
        try {
            this.doSaveSettings(userDirectory, log);
        }
        catch (Throwable t) {
            throw new TvBrowserException(AbstractPluginProxy.class, "error.saving.runtimeException", "The plugin {0} caused an error when saving the plugin settings.", (Object)this.getInfo().getName(), t);
        }
    }

    protected abstract void doSaveSettings(File var1, boolean var2) throws TvBrowserException;

    @Override
    public final PluginInfo getInfo() {
        try {
            return this.doGetInfo();
        }
        catch (RuntimeException exc) {
            String msg = mLocalizer.msg("error.getInfo", "The plugin {0} caused an error when getting the plugin information.", this.getClass().getName());
            ErrorHandler.handle(msg, exc);
            return new PluginInfo();
        }
    }

    protected abstract PluginInfo doGetInfo();

    @Override
    public final SettingsTabProxy getSettingsTab() {
        try {
            this.assertActivatedState();
            return this.doGetSettingsTab();
        }
        catch (Throwable t) {
            this.handlePluginException(t);
            return null;
        }
    }

    protected abstract SettingsTabProxy doGetSettingsTab();

    @Override
    public final ActionMenu getContextMenuActions(Program program) {
        try {
            ActionMenu menu = this.doGetContextMenuActions(program);
            if (menu != null) {
                return new ActionMenuProxy(this, menu);
            }
            return null;
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract ActionMenu doGetContextMenuActions(Program var1);

    @Override
    public final ActionMenu getContextMenuActions(Channel channel) {
        try {
            ActionMenu menu = this.doGetContextMenuActions(channel);
            if (menu != null) {
                return new ActionMenuProxy(this, menu);
            }
            return null;
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract ActionMenu doGetContextMenuActions(Channel var1);

    @Override
    public final ActionMenu getButtonAction() {
        try {
            ActionMenu menu = this.doGetButtonAction();
            if (menu != null) {
                return new ActionMenuProxy(this, menu);
            }
            return null;
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract ActionMenu doGetButtonAction();

    @Override
    public Icon[] getMarkIcons(Program p) {
        try {
            return this.doGetMarkIcons(p);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    @Override
    public Icon getMarkIcon() {
        Icon[] icon = this.getMarkIcons(null);
        if (icon != null && icon.length > 0) {
            return icon[0];
        }
        return null;
    }

    protected abstract Icon[] doGetMarkIcons(Program var1);

    @Override
    public final String getProgramTableIconText() {
        try {
            return this.doGetProgramTableIconText();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract String doGetProgramTableIconText();

    @Override
    public ToolTipIcon[] getProgramTableToolTipIcons(Program program) {
        try {
            return this.doGetProgramTableToolTipIcons(program);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract ToolTipIcon[] doGetProgramTableToolTipIcons(Program var1);

    @Override
    public final Icon[] getProgramTableIcons(Program program) {
        try {
            this.assertActivatedState();
            return this.doGetProgramTableIcons(program);
        }
        catch (Throwable t) {
            this.handlePluginException(t);
            return null;
        }
    }

    protected abstract Icon[] doGetProgramTableIcons(Program var1);

    @Override
    public final void handleTvDataUpdateFinished() {
        try {
            this.assertActivatedState();
            this.doHandleTvDataUpdateFinished();
        }
        catch (Throwable t) {
            this.handlePluginException(t);
        }
    }

    protected abstract void doHandleTvDataUpdateFinished();

    public void handleTvDataAdded(MutableChannelDayProgram newProg) {
        try {
            this.assertActivatedState();
            this.doHandleTvDataAdded(newProg);
        }
        catch (Throwable t) {
            this.handlePluginException(t);
        }
    }

    protected abstract void doHandleTvDataAdded(MutableChannelDayProgram var1);

    @Override
    public final void handleTvDataAdded(ChannelDayProgram newProg) {
        try {
            this.assertActivatedState();
            this.doHandleTvDataAdded(newProg);
        }
        catch (Throwable t) {
            this.handlePluginException(t);
        }
    }

    protected abstract void doHandleTvDataAdded(ChannelDayProgram var1);

    @Override
    public final void handleTvDataDeleted(ChannelDayProgram oldProg) {
        try {
            this.assertActivatedState();
            this.doHandleTvDataDeleted(oldProg);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
        }
    }

    protected abstract void doHandleTvDataDeleted(ChannelDayProgram var1);

    @Override
    public final void handleTvDataTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
        try {
            this.assertActivatedState();
            this.doHandleTvDataTouched(removedDayProgram, addedDayProgram);
        }
        catch (Throwable t) {
            this.handlePluginException(t);
        }
    }

    protected abstract void doHandleTvDataTouched(ChannelDayProgram var1, ChannelDayProgram var2);

    @Override
    public void onActivation() {
        try {
            this.doOnActivation();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
        }
    }

    protected abstract void doOnActivation() throws Throwable;

    @Override
    public void onDeactivation() {
        try {
            this.doOnDeactivation();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
        }
    }

    protected abstract void doOnDeactivation() throws Throwable;

    @Override
    public boolean canUseProgramTree() {
        try {
            boolean canUse = this.doCanUseProgramTree();
            if ((canUse || !this.doGetAllowsArtificialPluginTree()) && this.mArtificialRootNode != null) {
                this.mArtificialRootNode = null;
            }
            return canUse || this.mArtificialRootNode != null && this.mArtificialRootNode.size() < 100;
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return false;
        }
    }

    @Override
    public void handleTvBrowserStartFinished() {
        try {
            this.doHandleTvBrowserStartFinished();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
        }
    }

    protected abstract void doHandleTvBrowserStartFinished();

    protected abstract boolean doCanUseProgramTree();

    public final String toString() {
        return this.getInfo().getName();
    }

    @Override
    public void handlePluginException(final Throwable t) {
        final String msg = mLocalizer.msg("error.runtimeExceptionAskDeactivation", "The plugin {0} caused an error. Should it be deactivated?", this.getInfo().getName());
        final AbstractPluginProxy proxy = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ErrorHandler.handle(msg, t, 1) == 2) {
                    try {
                        PluginProxyManager.getInstance().deactivatePlugin(proxy);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
                    Settings.propDeactivatedPlugins.setStringArray(deactivatedPlugins);
                }
            }
        });
    }

    @Override
    public final boolean canReceiveProgramsWithTarget() {
        try {
            return this.doCanReceiveProgramsWithTarget();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return false;
        }
    }

    protected abstract boolean doCanReceiveProgramsWithTarget();

    @Override
    public final boolean receivePrograms(Program[] programArr, ProgramReceiveTarget receiveTarget) {
        try {
            this.assertActivatedState();
            return this.doReceivePrograms(programArr, receiveTarget);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return false;
        }
    }

    protected abstract boolean doReceivePrograms(Program[] var1, ProgramReceiveTarget var2);

    @Override
    public final boolean receiveValues(String[] values, ProgramReceiveTarget receiveTarget) {
        try {
            this.assertActivatedState();
            return this.doReceiveValues(values, receiveTarget);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return false;
        }
    }

    protected abstract boolean doReceiveValues(String[] var1, ProgramReceiveTarget var2);

    @Override
    public final ProgramReceiveTarget[] getProgramReceiveTargets() {
        try {
            this.assertActivatedState();
            return this.doGetProgramReceiveTargets();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract ProgramReceiveTarget[] doGetProgramReceiveTargets();

    @Override
    public PluginsProgramFilter[] getAvailableFilter() {
        try {
            this.assertActivatedState();
            return this.doGetAvailableFilter();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract PluginsProgramFilter[] doGetAvailableFilter();

    @Override
    public boolean isAllowedToDeleteProgramFilter(PluginsProgramFilter programFilter) {
        try {
            this.assertActivatedState();
            return this.doIsAllowedToDeleteProgramFilter(programFilter);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return false;
        }
    }

    protected abstract boolean doIsAllowedToDeleteProgramFilter(PluginsProgramFilter var1);

    @Override
    public Class<? extends PluginsFilterComponent>[] getAvailableFilterComponentClasses() {
        try {
            this.assertActivatedState();
            return this.doGetAvailableFilterComponentClasses();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    protected abstract Class<? extends PluginsFilterComponent>[] doGetAvailableFilterComponentClasses();

    @Override
    public int getMarkPriorityForProgram(Program p) {
        try {
            this.assertActivatedState();
            return this.doGetMarkPriorityForProgram(p);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return 0;
        }
    }

    protected abstract int doGetMarkPriorityForProgram(Program var1);

    protected void assertActivatedState() throws TvBrowserException {
        if (!this.isActivated()) {
            throw new TvBrowserException(AbstractPluginProxy.class, "error.notActive", "It was attempted to call an operation of the inactive plugin {0} that may only be called on activated plugins.", this.getInfo().getName());
        }
    }

    @Override
    public Icon getPluginIcon() {
        ActionMenu actionMenu = this.getButtonAction();
        Icon icon = this.getMenuIcon(actionMenu);
        if (icon == null) {
            icon = this.getMarkIcon();
        }
        if (icon == null && this.isActivated()) {
            actionMenu = this.getContextMenuActions(PluginManagerImpl.getInstance().getExampleProgram());
            icon = this.getMenuIcon(actionMenu);
        }
        if (icon != null) {
            return icon;
        }
        return new ImageIcon(DEFAULT_PLUGIN_ICON_NAME);
    }

    private Icon getMenuIcon(ActionMenu actionMenu) {
        Action action;
        if (actionMenu != null && (action = actionMenu.getAction()) != null) {
            return (Icon)action.getValue("SmallIcon");
        }
        return null;
    }

    @Override
    public final boolean hasArtificialPluginTree() {
        return this.getAllowsArtificialPluginTree() && this.mArtificialRootNode != null;
    }

    private final boolean getAllowsArtificialPluginTree() {
        try {
            return this.doGetAllowsArtificialPluginTree();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return true;
        }
    }

    protected abstract boolean doGetAllowsArtificialPluginTree();

    @Override
    public final void addToArtificialPluginTree(MutableProgram program) {
        if (this.mArtificialRootNode != null) {
            this.mArtificialRootNode.addProgram(program);
        }
    }

    @Override
    public final PluginTreeNode getArtificialRootNode() {
        return this.getAllowsArtificialPluginTree() ? this.mArtificialRootNode : null;
    }

    public final void removeArtificialPluginTree() {
        this.mArtificialRootNode = null;
    }

    @Override
    public int compareTo(ProgramReceiveIf other) {
        return this.getInfo().getName().compareTo(other.toString());
    }

    @Override
    public final ImportanceValue getImportanceValueForProgram(Program p) {
        try {
            return this.doGetImportanceValueForProgram(p);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return new ImportanceValue(1, 10);
        }
    }

    protected abstract ImportanceValue doGetImportanceValueForProgram(Program var1);

    @Override
    public PluginCommunication getCommunicationClass() {
        try {
            return this.doGetCommunicationClass();
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    public abstract PluginCommunication doGetCommunicationClass();

    @Override
    public ProgramInfo[] getAddtionalProgramInfoForProgram(Program p, String uniqueId) {
        try {
            return this.doGetAddtionalProgramInfoForProgram(p, uniqueId);
        }
        catch (Throwable exc) {
            this.handlePluginException(exc);
            return null;
        }
    }

    public abstract ProgramInfo[] doGetAddtionalProgramInfoForProgram(Program var1, String var2);
}

