/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ContextMenuAction;
import devplugin.Date;
import devplugin.ImportanceValue;
import devplugin.Plugin;
import devplugin.PluginCenterPanelWrapper;
import devplugin.PluginCommunication;
import devplugin.PluginInfo;
import devplugin.PluginTreeNode;
import devplugin.PluginsFilterComponent;
import devplugin.PluginsProgramFilter;
import devplugin.Program;
import devplugin.ProgramInfo;
import devplugin.ProgramRatingIf;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import devplugin.ToolTipIcon;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import tvbrowser.TVBrowser;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.AbstractPluginProxy;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.SettingsTabProxy;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MutableChannelDayProgram;
import util.exc.TvBrowserException;
import util.io.IOUtilities;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class JavaPluginProxy
extends AbstractPluginProxy {
    private static final Logger mLog = Logger.getLogger(JavaPluginProxy.class.getName());
    private Plugin mPlugin;
    private String mId;
    private PluginInfo mPluginInfo;
    private String mPluginFileName;
    private Icon mPluginIcon;
    private String mIconFileName;
    private String mPluginCategory;

    public JavaPluginProxy(Plugin plugin, String pluginFileName) {
        this.mPlugin = plugin;
        this.mPluginFileName = pluginFileName;
    }

    public JavaPluginProxy(PluginInfo info, String pluginFileName, String pluginId, Icon pluginIcon, String category) {
        this.mPluginInfo = info;
        this.mPluginFileName = pluginFileName;
        this.mId = pluginId;
        this.mPluginIcon = pluginIcon;
        this.mPluginCategory = category;
    }

    public JavaPluginProxy(PluginInfo info, String pluginFileName, String pluginId, String iconFileName, String category) {
        this.mPluginInfo = info;
        this.mPluginFileName = pluginFileName;
        this.mId = pluginId;
        this.mIconFileName = iconFileName;
        this.mPluginCategory = category;
    }

    public static String getJavaPluginId(Plugin javaPlugin) {
        return "java." + javaPlugin.getClass().getName();
    }

    @Override
    public String getId() {
        if (this.mId == null) {
            this.mId = JavaPluginProxy.getJavaPluginId(this.mPlugin);
        }
        return this.mId;
    }

    @Override
    void setParentFrame(Frame parent) {
        if (this.mPlugin != null) {
            this.mPlugin.setParent(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLoadSettings(File userDirectory) throws TvBrowserException {
        InputStream in;
        File propFile;
        block28: {
            String pluginClassName = this.mPlugin.getClass().getName();
            File oldDatFile = new File(userDirectory, pluginClassName + ".dat");
            File oldPropFile = new File(userDirectory, pluginClassName + ".prop");
            File datFile = new File(userDirectory, this.getId() + ".dat");
            propFile = new File(userDirectory, this.getId() + ".prop");
            oldDatFile.renameTo(datFile);
            oldPropFile.renameTo(propFile);
            if (datFile.exists()) {
                in = null;
                try {
                    in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(datFile), 16384));
                    this.mPlugin.readData((ObjectInputStream)in);
                }
                catch (Throwable thr) {
                    File datFileBackup = new File(userDirectory, this.getId() + ".dat_old");
                    if (datFileBackup.isFile()) {
                        try {
                            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(datFileBackup), 16384));
                            this.mPlugin.readData((ObjectInputStream)in);
                            mLog.severe("Date file '" + datFile.getAbsolutePath() + "' could not be read. Read old file instead: '" + datFileBackup.getAbsolutePath() + "'.");
                            break block28;
                        }
                        catch (Throwable thr1) {
                            throw new TvBrowserException(this.getClass(), "error.3", "Loading data for plugin {0} failed.\n({1})", (Object)this.getInfo().getName(), (Object)datFileBackup.getAbsolutePath(), thr);
                        }
                    }
                    throw new TvBrowserException(this.getClass(), "error.3", "Loading data for plugin {0} failed.\n({1})", (Object)this.getInfo().getName(), (Object)datFile.getAbsolutePath(), thr);
                }
                finally {
                    if (in != null) {
                        try {
                            ((ObjectInputStream)in).close();
                        }
                        catch (IOException exc) {}
                    }
                }
            }
        }
        in = null;
        try {
            if (propFile.exists()) {
                Properties prop = new Properties();
                in = new BufferedInputStream(new FileInputStream(propFile), 16384);
                prop.load(in);
                ((BufferedInputStream)in).close();
                this.mPlugin.loadSettings(prop);
            } else {
                this.mPlugin.loadSettings(new Properties());
            }
        }
        catch (Throwable thr) {
            throw new TvBrowserException(this.getClass(), "error.4", "Loading settings for plugin {0} failed.\n({1})", (Object)this.getInfo().getName(), (Object)propFile.getAbsolutePath(), thr);
        }
        finally {
            if (in != null) {
                try {
                    ((BufferedInputStream)in).close();
                }
                catch (IOException exc) {}
            }
        }
    }

    @Override
    protected void doSaveSettings(File userDirectory, boolean log) throws TvBrowserException {
        if (log) {
            mLog.info("Storing plugin settings for " + this.getId() + "...");
        }
        File tmpDatFile = new File(userDirectory, this.getId() + ".dat.temp");
        File oldDatFile = new File(userDirectory, this.getId() + ".dat_old");
        try {
            StreamUtilities.objectOutputStream(tmpDatFile, new ObjectOutputStreamProcessor(){

                @Override
                public void process(ObjectOutputStream out) throws IOException {
                    JavaPluginProxy.this.mPlugin.writeData(out);
                    out.close();
                }
            });
            File datFile = new File(userDirectory, this.getId() + ".dat");
            if (oldDatFile.isFile()) {
                oldDatFile.delete();
            }
            datFile.renameTo(oldDatFile);
            tmpDatFile.renameTo(datFile);
        }
        catch (Throwable thr) {
            throw new TvBrowserException(this.getClass(), "error.5", "Saving data for plugin {0} failed.\n({1})", (Object)this.getInfo().getName(), (Object)tmpDatFile.getAbsolutePath(), thr);
        }
        FileOutputStream fOut = null;
        File tmpPropFile = new File(userDirectory, this.getId() + ".prop.temp");
        try {
            Properties prop = this.mPlugin.storeSettings();
            if (prop != null) {
                fOut = new FileOutputStream(tmpPropFile);
                prop.store(fOut, "Settings for plugin " + this.getInfo().getName());
                fOut.close();
            }
            File propFile = new File(userDirectory, this.getId() + ".prop");
            propFile.delete();
            tmpPropFile.renameTo(propFile);
        }
        catch (Throwable thr) {
            throw new TvBrowserException(this.getClass(), "error.6", "Saving settings for plugin {0} failed.\n({1})", (Object)this.getInfo().getName(), (Object)tmpPropFile.getAbsolutePath(), thr);
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    @Override
    protected PluginInfo doGetInfo() {
        if (this.mPluginInfo != null) {
            return this.mPluginInfo;
        }
        PluginInfo info = null;
        try {
            info = this.mPlugin.getInfo();
        }
        catch (NoSuchMethodError e) {
            String name = Plugin.mLocalizer.msg("unkown", "Unknown");
            String desc = Plugin.mLocalizer.msg("noDescription", "No description");
            String author = Plugin.mLocalizer.msg("noAuthor", "No author given");
            return new PluginInfo(Plugin.class, name, desc, author);
        }
        return info;
    }

    @Override
    protected SettingsTabProxy doGetSettingsTab() {
        SettingsTab tab = this.mPlugin.getSettingsTab();
        if (tab == null) {
            return null;
        }
        return new SettingsTabProxy(tab);
    }

    @Override
    protected ActionMenu doGetContextMenuActions(Program program) {
        if (program != null && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
            if (this.accessControl(program.getChannel()) || filter != null && !filter.accept(program)) {
                return null;
            }
        }
        return this.mPlugin.getContextMenuActions(program);
    }

    @Override
    protected ActionMenu doGetContextMenuActions(Channel channel) {
        if (!this.accessControl(channel)) {
            return this.mPlugin.getContextMenuActions(channel);
        }
        return null;
    }

    @Override
    protected ActionMenu doGetButtonAction() {
        if (this.mPlugin != null) {
            Action action;
            ActionMenu actMenu = this.mPlugin.getButtonAction();
            if (actMenu != null && (action = actMenu.getAction()) != null && !(action instanceof ContextMenuAction)) {
                if (action.getValue("SmallIcon") == null) {
                    mLog.warning("Small icon missing for button action " + action.getValue("Name"));
                    action.putValue("SmallIcon", TVBrowserIcons.warning(16));
                }
                if (action.getValue("BigIcon") == null) {
                    mLog.warning("Big icon missing for button action " + action.getValue("Name"));
                    action.putValue("BigIcon", TVBrowserIcons.warning(22));
                }
            }
            return actMenu;
        }
        return null;
    }

    @Override
    protected Icon[] doGetMarkIcons(Program p) {
        if (this.mPlugin != null && p != null) {
            UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
            if (!this.accessControl(p.getChannel()) && (filter == null || filter.accept(p))) {
                return this.mPlugin.getMarkIcons(p);
            }
        }
        return null;
    }

    @Override
    protected String doGetProgramTableIconText() {
        return this.mPlugin.getProgramTableIconText();
    }

    @Override
    protected Icon[] doGetProgramTableIcons(Program program) {
        if (program != null && !this.accessControl(program.getChannel())) {
            return this.mPlugin.getProgramTableIcons(program);
        }
        return null;
    }

    @Override
    protected void doHandleTvDataUpdateFinished() {
        this.mPlugin.handleTvDataUpdateFinished();
    }

    @Override
    protected void doHandleTvDataAdded(ChannelDayProgram newProg) {
        if (newProg != null && !this.accessControl(newProg.getChannel())) {
            this.mPlugin.handleTvDataAdded(newProg);
        }
    }

    @Override
    protected void doHandleTvDataDeleted(ChannelDayProgram oldProg) {
        if (oldProg != null && !this.accessControl(oldProg.getChannel())) {
            this.mPlugin.handleTvDataDeleted(oldProg);
        }
    }

    @Override
    protected void doHandleTvBrowserStartFinished() {
        this.mPlugin.handleTvBrowserStartFinished();
    }

    @Override
    public void doOnActivation() throws Throwable {
        if (!TVBrowser.isSafeMode()) {
            this.plugin().onActivation();
        }
    }

    private Plugin plugin() {
        if (this.mPlugin == null) {
            this.mPlugin = (Plugin)PluginLoader.getInstance().loadPlugin(new File(this.mPluginFileName), false);
        }
        return this.mPlugin;
    }

    @Override
    public void doOnDeactivation() throws Throwable {
        if (this.mPlugin != null) {
            this.mPlugin.onDeactivation();
        }
    }

    @Override
    public boolean doCanUseProgramTree() {
        return this.mPlugin.canUseProgramTree();
    }

    @Override
    public PluginTreeNode getRootNode() {
        return this.mPlugin.getRootNode();
    }

    @Override
    protected boolean doCanReceiveProgramsWithTarget() {
        return this.mPlugin.canReceiveProgramsWithTarget();
    }

    @Override
    protected boolean doReceivePrograms(Program[] programArr, ProgramReceiveTarget receiveTarget) {
        boolean value;
        if (programArr != null && this.accessControl()) {
            ArrayList<Program> accessPrograms = new ArrayList<Program>();
            for (Program p : programArr) {
                if (p.getChannel().isAccessControl()) continue;
                accessPrograms.add(p);
            }
            programArr = accessPrograms.toArray(new Program[accessPrograms.size()]);
        }
        if (!(value = this.mPlugin.receivePrograms(programArr, receiveTarget))) {
            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("error.noTarget", "The programs for the target \"{0}\" couldn't be processed by \"{1}\".", receiveTarget, this.mPlugin.getInfo().getName()), Localizer.getLocalization("i18n_error"), 0);
        }
        return value;
    }

    @Override
    protected ProgramReceiveTarget[] doGetProgramReceiveTargets() {
        ProgramReceiveTarget[] targets = this.mPlugin.getProgramReceiveTargets();
        return targets != null ? targets : ProgramReceiveTarget.createDefaultTargetArrayForProgramReceiveIf(this.mPlugin);
    }

    @Override
    protected PluginsProgramFilter[] doGetAvailableFilter() {
        return this.mPlugin.getAvailableFilter();
    }

    @Override
    protected boolean doIsAllowedToDeleteProgramFilter(PluginsProgramFilter programFilter) {
        return this.mPlugin.isAllowedToDeleteProgramFilter(programFilter);
    }

    @Override
    protected Class<? extends PluginsFilterComponent>[] doGetAvailableFilterComponentClasses() {
        return this.mPlugin.getAvailableFilterComponentClasses();
    }

    @Override
    protected int doGetMarkPriorityForProgram(Program p) {
        UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
        if (p != null && (this.accessControl(p.getChannel()) || filter != null && !filter.accept(p))) {
            return -1;
        }
        return this.mPlugin.getMarkPriorityForProgram(p);
    }

    @Override
    public String getPluginFileName() {
        return this.mPluginFileName;
    }

    public void setPlugin(Plugin plugin, String fileName) {
        this.mPlugin = plugin;
        this.mPluginFileName = fileName;
    }

    @Override
    public Icon getPluginIcon() {
        File iconFile;
        if (this.mPluginIcon == null && this.mIconFileName != null && (iconFile = new File(this.mIconFileName)).canRead()) {
            this.mPluginIcon = IOUtilities.readImageIconFromFile(iconFile);
        }
        if (this.mPluginIcon != null) {
            return this.mPluginIcon;
        }
        return super.getPluginIcon();
    }

    @Override
    public ProgramRatingIf[] getProgramRatingIfs() {
        return this.mPlugin.getRatingInterfaces();
    }

    @Override
    public String getButtonActionDescription() {
        return this.mPlugin.getInfo().getDescription();
    }

    @Override
    protected void doHandleTvDataAdded(MutableChannelDayProgram newProg) {
        if (newProg != null && !this.accessControl(newProg.getChannel())) {
            this.mPlugin.handleTvDataAdded(newProg);
        }
    }

    @Override
    protected boolean doReceiveValues(String[] values, ProgramReceiveTarget receiveTarget) {
        return this.mPlugin.receiveValues(values, receiveTarget);
    }

    @Override
    protected void doHandleTvDataTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
        if (removedDayProgram != null && !this.accessControl(removedDayProgram.getChannel()) || addedDayProgram != null && !this.accessControl(addedDayProgram.getChannel()) || removedDayProgram == null && addedDayProgram == null) {
            this.mPlugin.handleTvDataTouched(removedDayProgram, addedDayProgram);
        }
    }

    @Override
    protected ImportanceValue doGetImportanceValueForProgram(Program p) {
        UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(this, true);
        if (p != null && (this.accessControl(p.getChannel()) || filter != null && !filter.accept(p))) {
            return new ImportanceValue(1, -1);
        }
        return this.mPlugin.getImportanceValueForProgram(p);
    }

    @Override
    public String getPluginCategory() {
        if (this.mPlugin != null) {
            return this.mPlugin.getPluginCategory();
        }
        return this.mPluginCategory;
    }

    @Override
    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return this.mPlugin.getPluginCenterPanelWrapper();
    }

    @Override
    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        if (this.mPlugin != null) {
            return this.mPlugin.getAfterDataUpdateInfoPanel();
        }
        return null;
    }

    @Override
    public void handleTvBrowserSettingsChanged() {
        if (this.mPlugin != null) {
            this.mPlugin.handleTvBrowserSettingsChanged();
        }
    }

    @Override
    public void handleTvDataUpdateStarted(Date until) {
        if (this.mPlugin != null) {
            this.mPlugin.handleTvDataUpdateStarted(until);
        }
    }

    @Override
    public PluginCommunication doGetCommunicationClass() {
        if (this.mPlugin != null) {
            return this.mPlugin.getCommunicationClass();
        }
        return null;
    }

    private boolean accessControl(Channel ch) {
        return ch != null && ch.isAccessControl() && this.accessControl();
    }

    private boolean accessControl() {
        if (Settings.propAccessControl.getStringArray().length > 0) {
            int startIndex = this.mPlugin.getId().indexOf(".") + 1;
            if (Settings.propAccessControl.containsItem(this.mPlugin.getId().substring(startIndex, this.mPlugin.getId().indexOf(".", startIndex)))) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doGetAllowsArtificialPluginTree() {
        return this.mPlugin.isAllowingArtificialPluginTree();
    }

    @Override
    protected ToolTipIcon[] doGetProgramTableToolTipIcons(Program program) {
        return this.mPlugin.getProgramTableToolTipIcons(program);
    }

    @Override
    public ProgramInfo[] doGetAddtionalProgramInfoForProgram(Program p, String uniqueId) {
        return this.mPlugin.getAddtionalProgramInfoForProgram(p, uniqueId);
    }
}

