/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ContextMenuAction;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.PluginCenterPanel;
import devplugin.PluginCenterPanelWrapper;
import devplugin.PluginTreeNode;
import devplugin.Program;
import devplugin.ProgramItem;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.common.ConfigurationHandler;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderDialog;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListDialog;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderListPanel;
import tvbrowser.extras.reminderplugin.ReminderPropertyDefaults;
import tvbrowser.extras.reminderplugin.ReminderTimerListener;
import tvbrowser.extras.reminderplugin.RemovedProgramsPanel;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.io.IOUtilities;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public class ReminderPlugin {
    static Localizer mLocalizer = Localizer.getLocalizerFor(ReminderPlugin.class);
    private static final Logger mLog = Logger.getLogger(ReminderPlugin.class.getName());
    private ReminderList mReminderList;
    private Properties mSettings;
    private static ReminderPlugin mInstance;
    private static String DATAFILE_PREFIX;
    private static String DATAFILE_NAME;
    private ConfigurationHandler mConfigurationHandler;
    private static final PluginTreeNode mRootNode;
    private boolean mHasRightToStartTimer = false;
    private boolean mHasRightToSave = true;
    private static final String TOGGLE_ACTION_ID = "reminderPauseAction";
    public static final String REMINDER_LIST_ACTION_ID = "reminderListAction";
    private ProgramReceiveTarget[] mClientPluginTargets;
    private int mMarkPriority = -2;
    private PluginCenterPanelWrapper mWrapper;
    private JPanel mCenterPanel;
    private ReminderListPanel mReminderListPanel;
    private AbstractAction toggleTimer;
    private Thread mInfoCreationThread;
    private AfterDataUpdateInfoPanel mInfoPanel;

    private ReminderPlugin() {
        mInstance = this;
        this.toggleTimer = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ReminderPlugin.this.mReminderList != null) {
                    ReminderPlugin.this.mReminderList.toggleTimer();
                    if (ReminderPlugin.this.mReminderList.isActive()) {
                        this.putValue("Name", mLocalizer.msg("stopTimer", "Pause Reminder"));
                        ReminderPlugin.this.toggleTimer.putValue("ShortDescription", mLocalizer.msg("stopTimerDesc", "Pause Reminder until reactivation"));
                        this.putValue("ActionIsSelected", false);
                    } else {
                        this.putValue("Name", mLocalizer.msg("continueTimer", "Continue Reminder"));
                        ReminderPlugin.this.toggleTimer.putValue("ShortDescription", mLocalizer.msg("continueTimer", "Continue Reminder"));
                        this.putValue("ActionIsSelected", true);
                    }
                    MainFrame.getInstance().updateToolbar();
                }
            }
        };
        this.toggleTimer.putValue("Name", mLocalizer.msg("stopTimer", "Pause Reminder"));
        this.toggleTimer.putValue("ActionId", TOGGLE_ACTION_ID);
        this.toggleTimer.putValue("ShortDescription", mLocalizer.msg("stopTimerDesc", "Pause Reminder until reactivation"));
        this.toggleTimer.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 16));
        this.toggleTimer.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 22));
        this.toggleTimer.putValue("ActionType", 1);
        this.toggleTimer.putValue("ActionIsSelected", false);
        this.mWrapper = new PluginCenterPanelWrapper(){
            ReminderCenterPanel centerPanel;
            {
                this.centerPanel = new ReminderCenterPanel();
            }

            @Override
            public PluginCenterPanel[] getCenterPanels() {
                return new PluginCenterPanel[]{this.centerPanel};
            }

            @Override
            public void scrolledToDate(Date date) {
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    ReminderPlugin.this.mReminderListPanel.scrollTo(0, date, -1);
                }
            }

            @Override
            public void scrolledToNow() {
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    ReminderPlugin.this.mReminderListPanel.scrollTo(1, null, -1);
                }
            }

            @Override
            public void scrolledToTime(int time) {
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    int type = 2;
                    if (!Boolean.parseBoolean(ReminderPropertyDefaults.getPropertyDefaults().getValueFromProperties("scrollTimeTypeNext", ReminderPlugin.this.mSettings))) {
                        type = 3;
                    }
                    ReminderPlugin.this.mReminderListPanel.scrollTo(type, null, time);
                }
                super.scrolledToTime(time);
            }
        };
        this.mCenterPanel = UiUtilities.createPersonaBackgroundPanel();
        this.mClientPluginTargets = new ProgramReceiveTarget[0];
        this.mConfigurationHandler = new ConfigurationHandler(ReminderPlugin.getReminderPluginId());
        this.loadSettings();
        this.mReminderList = new ReminderList();
        this.mReminderList.setReminderTimerListener(new ReminderTimerListener(this.mSettings, this.mReminderList));
        this.loadReminderData();
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){
            private boolean mCanCreateInfoPanel;

            @Override
            public void tvDataUpdateStarted(Date until) {
                this.mCanCreateInfoPanel = false;
                ReminderPlugin.this.mHasRightToSave = false;
                ReminderPlugin.this.mInfoCreationThread = new Thread(){

                    @Override
                    public void run() {
                        while (!mCanCreateInfoPanel) {
                            try {
                                1.sleep(500L);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (ReminderPlugin.this.mSettings.getProperty("showRemovedDialog", "true").compareTo("true") == 0) {
                            Program[] removedPrograms = ReminderPlugin.this.mReminderList.updatePrograms();
                            if (removedPrograms.length > 0) {
                                ReminderPlugin.this.mInfoPanel = new RemovedProgramsPanel(removedPrograms);
                            } else {
                                ReminderPlugin.this.mInfoPanel = null;
                            }
                        } else {
                            ReminderPlugin.this.mReminderList.updatePrograms();
                            ReminderPlugin.this.mInfoPanel = null;
                        }
                        ReminderPlugin.this.mHasRightToSave = true;
                        ReminderPlugin.this.saveReminders();
                        ReminderListDialog.updateReminderList();
                    }
                };
                ReminderPlugin.this.mInfoCreationThread.start();
            }

            @Override
            public void tvDataUpdateFinished() {
                this.mCanCreateInfoPanel = true;
            }
        });
    }

    public static synchronized ReminderPlugin getInstance() {
        if (mInstance == null) {
            new ReminderPlugin();
        }
        return mInstance;
    }

    public String toString() {
        return ReminderPlugin.getName();
    }

    static String getName() {
        return mLocalizer.msg("pluginName", "Reminder");
    }

    public void handleTvBrowserStartFinished() {
        this.updateRootNode(false);
        this.mHasRightToStartTimer = true;
        this.mReminderList.removeExpiredItems();
        this.mReminderList.startTimer();
        this.addPanel();
    }

    void addPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ReminderPlugin.this.mSettings.getProperty("provideTab", "true").equals("true")) {
                    if (ReminderPlugin.this.mReminderListPanel == null) {
                        ReminderPlugin.this.mReminderListPanel = new ReminderListPanel(ReminderPlugin.this.mReminderList, null);
                        Persona.getInstance().registerPersonaListener(ReminderPlugin.this.mReminderListPanel);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ReminderPlugin.this.mCenterPanel.add((Component)ReminderPlugin.this.mReminderListPanel, "Center");
                                ReminderPlugin.this.mReminderListPanel.updatePersona();
                                ReminderPlugin.this.mCenterPanel.repaint();
                            }
                        });
                    }
                } else {
                    if (ReminderPlugin.this.mReminderListPanel != null) {
                        Persona.getInstance().removePersonaListerner(ReminderPlugin.this.mReminderListPanel);
                    }
                    ReminderPlugin.this.mReminderListPanel = null;
                }
            }
        });
    }

    protected boolean isAllowedToStartTimer() {
        return this.mHasRightToStartTimer;
    }

    private void loadSettings() {
        try {
            Properties prop = this.mConfigurationHandler.loadSettings();
            this.loadSettings(prop);
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not load reminder data.", e);
        }
    }

    private ObjectInputStream getObjectInputStream(File f) throws IOException {
        return new ObjectInputStream(new BufferedInputStream(new FileInputStream(f), 16384));
    }

    private void loadReminderData() {
        try {
            File newFile = new File(Settings.getUserSettingsDirName(), DATAFILE_NAME);
            if (newFile.exists()) {
                StreamUtilities.objectInputStream(newFile, 16384, new ObjectInputStreamProcessor(){

                    @Override
                    public void process(ObjectInputStream inputStream) throws IOException {
                        try {
                            ReminderPlugin.this.readData(inputStream);
                        }
                        catch (ClassNotFoundException e) {
                            ErrorHandler.handle("Could not load reminder data", e);
                        }
                    }
                });
            } else {
                this.tryToReadDataFromPreviousVersions();
            }
            this.mReminderList.removeExpiredItems();
            this.mReminderList.setReminderTimerListener(new ReminderTimerListener(this.mSettings, this.mReminderList));
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not load reminder data", e);
        }
    }

    private void tryToReadDataFromPreviousVersions() {
        boolean oldDataRead = false;
        try {
            File datFile;
            File nodeFile = new File(Settings.getUserSettingsDirName(), "java.reminderplugin.ReminderPlugin.node");
            if (nodeFile.exists()) {
                StreamUtilities.objectInputStream(nodeFile, 16384, new ObjectInputStreamProcessor(){

                    @Override
                    public void process(ObjectInputStream inputStream) throws IOException {
                        try {
                            ReminderPlugin.this.readReminderFromTVBrowser21and20(inputStream);
                        }
                        catch (ClassNotFoundException e) {
                            mLog.log(Level.WARNING, "Could not read data from previous version", e);
                        }
                    }
                });
                oldDataRead = true;
                nodeFile.delete();
            }
            if ((datFile = new File(Settings.getUserSettingsDirName(), "java.reminderplugin.ReminderPlugin.dat")).exists()) {
                if (!oldDataRead) {
                    StreamUtilities.objectInputStream(datFile, 16384, new ObjectInputStreamProcessor(){

                        @Override
                        public void process(ObjectInputStream inputStream) throws IOException {
                            try {
                                ReminderPlugin.this.readReminderFromBeforeTVBrowser20(inputStream);
                            }
                            catch (ClassNotFoundException e) {
                                mLog.log(Level.WARNING, "Could not read data from previous version", e);
                            }
                        }
                    });
                }
                datFile.delete();
            }
        }
        catch (IOException e) {
            mLog.log(Level.WARNING, "Could not read data from previous version", e);
        }
    }

    public Properties getSettings() {
        return this.mSettings;
    }

    public synchronized void store() {
        try {
            String userDirectoryName = Settings.getUserSettingsDirName();
            File userDirectory = new File(userDirectoryName);
            File tmpDatFile = new File(userDirectory, DATAFILE_NAME + ".temp");
            File datFile = new File(userDirectory, DATAFILE_NAME);
            StreamUtilities.objectOutputStream(tmpDatFile, new ObjectOutputStreamProcessor(){

                @Override
                public void process(ObjectOutputStream out) throws IOException {
                    ReminderPlugin.this.writeData(out);
                    out.flush();
                    out.close();
                }
            });
            datFile.delete();
            tmpDatFile.renameTo(datFile);
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not store reminder data.", e);
        }
        try {
            this.mConfigurationHandler.storeSettings(this.mSettings);
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not store reminder settings.", e);
        }
    }

    private void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.mReminderList.setReminderTimerListener(null);
        this.mReminderList.read(in);
        if (version == 3) {
            this.mClientPluginTargets = new ProgramReceiveTarget[in.readInt()];
            for (int i = 0; i < this.mClientPluginTargets.length; ++i) {
                this.mClientPluginTargets[i] = new ProgramReceiveTarget(in);
            }
        }
    }

    private void readReminderFromTVBrowser21and20(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int cnt = in.readInt();
        for (int i = 0; i < cnt; ++i) {
            int minutes;
            int type = in.readInt();
            if (type != 2) continue;
            ProgramItem item = new ProgramItem();
            item.read(in);
            String m = item.getProperty("minutes");
            try {
                minutes = Integer.parseInt(m);
            }
            catch (NumberFormatException e) {
                minutes = 10;
            }
            Program program = item.getProgram();
            if (program != null) {
                this.mReminderList.add(program, new ReminderContent(minutes));
            }
            in.readInt();
        }
        in.close();
    }

    private void readReminderFromBeforeTVBrowser20(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 1) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                in.readInt();
                int reminderMinutes = in.readInt();
                Date programDate = Date.readData(in);
                String programId = (String)in.readObject();
                Program program = Plugin.getPluginManager().getProgram(programDate, programId);
                if (program == null) continue;
                this.mReminderList.add(program, new ReminderContent(reminderMinutes));
            }
        } else if (version == 2) {
            this.mReminderList.setReminderTimerListener(null);
            this.mReminderList.read(in);
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        this.mReminderList.writeData(out);
        out.writeInt(this.mClientPluginTargets.length);
        for (ProgramReceiveTarget target : this.mClientPluginTargets) {
            target.writeData(out);
        }
    }

    private void loadSettings(Properties settings) {
        if (settings == null) {
            settings = new Properties();
        }
        if (settings.getProperty("usemsgbox") == null) {
            settings.setProperty("usemsgbox", "true");
        }
        if (settings.getProperty("numberofremindoptions") != null && settings.getProperty("defaultReminderEntry") != null) {
            int defaultRemind = Integer.parseInt(settings.getProperty("defaultReminderEntry")) - 5;
            settings.setProperty("defaultReminderEntry", String.valueOf(defaultRemind));
            settings.remove("numberofremindoptions");
        } else if (settings.getProperty("defaultReminderEntry") == null) {
            settings.setProperty("defaultReminderEntry", String.valueOf(0));
        }
        this.mSettings = settings;
        if (settings.containsKey("usethisplugin") || settings.containsKey("usesendplugin")) {
            String plugins = settings.getProperty("usethisplugin", "").trim();
            boolean sendEnabled = settings.getProperty("usesendplugin", "").compareToIgnoreCase("true") == 0;
            settings.remove("usethisplugin");
            settings.remove("usesendplugin");
            if (plugins.length() > 0 && sendEnabled) {
                if (plugins.indexOf(59) == -1) {
                    this.mClientPluginTargets = new ProgramReceiveTarget[1];
                    this.mClientPluginTargets[0] = ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(plugins);
                } else {
                    String[] ids = plugins.split(";");
                    this.mClientPluginTargets = new ProgramReceiveTarget[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        this.mClientPluginTargets[i] = ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(ids[i]);
                    }
                }
            }
        }
        if (settings.containsKey("autoCloseReminderAtProgramEnd")) {
            if (settings.getProperty("autoCloseReminderAtProgramEnd", "true").equalsIgnoreCase("true")) {
                settings.setProperty("autoCloseBehaviour", "onEnd");
            }
            settings.remove("autoCloseReminderAtProgramEnd");
        }
    }

    protected ActionMenu getContextMenuActions(final Frame parentFrame, final Program program) {
        try {
            if (this.mReminderList.contains(program)) {
                final ReminderListItem item = this.mReminderList.getReminderItem(program);
                RemindValue[] values = ReminderPlugin.calculatePossibleReminders(program);
                ArrayList<ActionMenu> actions = new ArrayList<ActionMenu>(values.length + 3);
                actions.add(new ActionMenu(new AbstractAction(ReminderFrame.DONT_REMIND_AGAIN_VALUE.toString()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ReminderPlugin.this.mReminderList.removeWithoutChecking(program);
                        ReminderPlugin.this.updateRootNode(true);
                    }
                }));
                actions.add(new ActionMenu(ContextMenuSeparatorAction.getInstance()));
                for (final RemindValue value : values) {
                    actions.add(new ActionMenu((Action)new AbstractAction(value.toString()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            item.setMinutes(value.getMinutes());
                            ReminderPlugin.this.saveReminders();
                        }
                    }, item.getMinutes() == value.getMinutes()));
                }
                actions.add(new ActionMenu(ContextMenuSeparatorAction.getInstance()));
                actions.add(new ActionMenu(new AbstractAction(mLocalizer.msg("comment", "Change comment"), TVBrowserIcons.edit(16)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        item.changeComment(parentFrame);
                    }
                }));
                return new ActionMenu(ReminderPlugin.getName(), (Icon)IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), actions.toArray(new ActionMenu[actions.size()]));
            }
            if ((program.isExpired() || program.isOnAir()) && !program.equals(Plugin.getPluginManager().getExampleProgram())) {
                return null;
            }
            ContextMenuAction action = new ContextMenuAction();
            action.setText(mLocalizer.msg("contextMenuText", "Remind me"));
            action.setSmallIcon(IconLoader.getInstance().getIconFromTheme("actions", "appointment-new", 16));
            action.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    final Window w = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                    try {
                        UIThreadRunner.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ReminderDialog dlg = new ReminderDialog(w, program, ReminderPlugin.this.mSettings);
                                Settings.layoutWindow("extras.remiderContext", dlg);
                                if (ReminderPlugin.this.mSettings.getProperty("showTimeSelectionDialog", "true").compareTo("true") == 0) {
                                    UiUtilities.centerAndShow(dlg);
                                    if (dlg.getOkPressed()) {
                                        ReminderPlugin.this.mReminderList.add(program, dlg.getReminderContent());
                                        ReminderPlugin.this.mReminderList.unblockProgram(program);
                                        ReminderPlugin.this.updateRootNode(true);
                                    }
                                    dlg.dispose();
                                } else {
                                    ReminderPlugin.this.mReminderList.add(program, dlg.getReminderContent());
                                    ReminderPlugin.this.mReminderList.unblockProgram(program);
                                    ReminderPlugin.this.updateRootNode(true);
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            });
            return new ActionMenu(action);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public int getDefaultReminderTime() {
        String defaultReminderEntryStr = (String)this.mSettings.get("defaultReminderEntry");
        int minutes = 10;
        if (defaultReminderEntryStr != null) {
            try {
                int inx = Integer.parseInt(defaultReminderEntryStr);
                if (inx < ReminderFrame.REMIND_BEFORE_VALUE_ARR.length) {
                    minutes = ReminderFrame.REMIND_BEFORE_VALUE_ARR[inx].getMinutes();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return minutes;
    }

    public void addPrograms(Program[] programArr) {
        this.mReminderList.addAndCheckBlocked(programArr, this.getDefaultReminderTime());
        this.updateRootNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeProgram(Program prog) {
        ReminderListItem item = null;
        ReminderList reminderList = this.mReminderList;
        synchronized (reminderList) {
            item = this.mReminderList.getReminderItem(prog);
            this.mReminderList.remove(prog);
        }
        if (item != null) {
            return item.getMinutes();
        }
        return -42;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrograms(Program[] progArr) {
        ReminderList reminderList = this.mReminderList;
        synchronized (reminderList) {
            this.mReminderList.remove(progArr);
        }
    }

    public void addProgram(Program prog, int reminderMinutes) {
        this.mReminderList.add(prog, new ReminderContent(reminderMinutes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReminderMinutesForProgram(Program prog) {
        ReminderListItem item = null;
        ReminderList reminderList = this.mReminderList;
        synchronized (reminderList) {
            item = this.mReminderList.getReminderItem(prog);
        }
        if (item != null) {
            return item.getMinutes();
        }
        return -31;
    }

    public static PluginTreeNode getRootNode() {
        return mRootNode;
    }

    synchronized void updateRootNode(boolean save, boolean scroll) {
        mRootNode.removeAllActions();
        mRootNode.getMutableTreeNode().setIcon(IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
        AbstractAction editReminders = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderListDialog dlg = new ReminderListDialog((Window)MainFrame.getInstance(), ReminderPlugin.this.mReminderList);
                UiUtilities.centerAndShow(dlg);
            }
        };
        editReminders.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
        editReminders.putValue("Name", mLocalizer.ellipsisMsg("buttonText", "Edit reminder list"));
        AbstractAction openSettings = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showSettingsDialog("#reminder");
            }
        };
        openSettings.putValue("SmallIcon", TVBrowserIcons.preferences(16));
        openSettings.putValue("Name", Localizer.getLocalization("i18n_settings"));
        mRootNode.addAction(editReminders);
        mRootNode.addAction(null);
        mRootNode.addAction(openSettings);
        mRootNode.removeAllChildren();
        ReminderListItem[] items = this.mReminderList.getReminderItems();
        ArrayList<Program> listNewPrograms = new ArrayList<Program>(items.length);
        for (ReminderListItem reminderItem : items) {
            listNewPrograms.add(reminderItem.getProgram());
        }
        try {
            mRootNode.addPrograms(listNewPrograms);
        }
        catch (Throwable t) {
            // empty catch block
        }
        mRootNode.update();
        if (save && this.mHasRightToSave) {
            this.saveReminders();
        }
        if (this.mReminderListPanel != null) {
            this.mReminderListPanel.installTableModel(scroll);
        }
    }

    public void updateRootNode(boolean save) {
        this.updateRootNode(save, true);
    }

    private void saveReminders() {
        this.store();
    }

    protected ActionMenu getButtonAction() {
        try {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ReminderPlugin.getInstance().showManageRemindersDialog();
                }
            };
            action.putValue("Name", mLocalizer.msg("showReminderList", "Show Reminder list"));
            action.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
            action.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 22));
            action.putValue("ShortDescription", mLocalizer.msg("description", "Reminds you of programs to not miss them."));
            action.putValue("ActionId", REMINDER_LIST_ACTION_ID);
            return new ActionMenu(ReminderPlugin.getName(), (Icon)IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), new Action[]{action, this.toggleTimer});
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Object playSound(String fileName) {
        try {
            if (StringUtils.endsWithIgnoreCase(fileName, ".mid")) {
                final Sequencer sequencer = MidiSystem.getSequencer();
                sequencer.open();
                final FileInputStream midiFile = new FileInputStream(fileName);
                sequencer.setSequence(MidiSystem.getSequence(midiFile));
                sequencer.start();
                new Thread("Reminder MIDI sequencer"){

                    @Override
                    public void run() {
                        this.setPriority(1);
                        while (sequencer.isRunning()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception ee) {}
                        }
                        try {
                            sequencer.close();
                            midiFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
                return sequencer;
            }
            final AudioInputStream ais = AudioSystem.getAudioInputStream(new File(fileName));
            final AudioFormat format = ais.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (AudioSystem.isLineSupported(info)) {
                final SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format);
                line.start();
                new Thread("Reminder audio playing"){
                    private boolean stopped;

                    @Override
                    public void run() {
                        try {
                            byte[] myData = new byte[1024 * format.getFrameSize()];
                            int numBytesToRead = myData.length;
                            int numBytesRead = 0;
                            int totalToRead = (int)((long)format.getFrameSize() * ais.getFrameLength());
                            this.stopped = false;
                            line.addLineListener(new LineListener(){

                                @Override
                                public void update(LineEvent event) {
                                    if (!(event.getType() == LineEvent.Type.START || line == null || event.getType() != LineEvent.Type.STOP && line.isRunning())) {
                                        stopped = true;
                                        try {
                                            ais.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                            try {
                                for (int total = 0; total < totalToRead && !this.stopped && (numBytesRead = ais.read(myData, 0, numBytesToRead)) != -1; total += numBytesRead) {
                                    line.write(myData, 0, numBytesRead);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (line.isRunning()) {
                                line.drain();
                            }
                            line.stop();
                            if (line != null) {
                                line.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
                return line;
            }
            URL url = new File(fileName).toURI().toURL();
            AudioClip clip = Applet.newAudioClip(url);
            clip.play();
        }
        catch (Exception e) {
            if (new File(fileName).isFile()) {
                try {
                    URL url = new File(fileName).toURI().toURL();
                    AudioClip clip = Applet.newAudioClip(url);
                    clip.play();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            String msg = mLocalizer.msg("error.1", "Error loading reminder sound file!\n({0})", fileName);
            JOptionPane.showMessageDialog(UiUtilities.getBestDialogParent(MainFrame.getInstance()), msg, Localizer.getLocalization("i18n_error"), 0);
        }
        return null;
    }

    protected ActionMenu getContextMenuActions(Program program) {
        return this.getContextMenuActions(null, program);
    }

    public static String getReminderPluginId() {
        return DATAFILE_PREFIX;
    }

    protected ProgramReceiveTarget[] getClientPluginsTargets() {
        ArrayList<ProgramReceiveTarget> list = new ArrayList<ProgramReceiveTarget>();
        for (ProgramReceiveTarget target : this.mClientPluginTargets) {
            ProgramReceiveIf plugin = target.getReceifeIfForIdOfTarget();
            if (plugin == null || !plugin.canReceiveProgramsWithTarget()) continue;
            list.add(target);
        }
        return list.toArray(new ProgramReceiveTarget[list.size()]);
    }

    protected void setClientPluginsTargets(ProgramReceiveTarget[] targets) {
        this.mClientPluginTargets = targets != null ? targets : new ProgramReceiveTarget[0];
    }

    protected int getMarkPriority() {
        if (this.mMarkPriority == -2 && this.mSettings != null) {
            this.mMarkPriority = Integer.parseInt(this.mSettings.getProperty("markPriority", String.valueOf(0)));
            return this.mMarkPriority;
        }
        return this.mMarkPriority;
    }

    protected void setMarkPriority(int priority) {
        ReminderListItem[] items;
        this.mMarkPriority = priority;
        for (ReminderListItem item : items = this.mReminderList.getReminderItems()) {
            item.getProgram().validateMarking();
        }
        this.mSettings.setProperty("markPriority", String.valueOf(priority));
        this.saveReminders();
    }

    protected static int getTimeToProgramStart(Program program) {
        int progMinutesAfterMidnight = program.getHours() * 60 + program.getMinutes();
        int remainingMinutes = progMinutesAfterMidnight - IOUtilities.getMinutesAfterMidnight() + 1440 * program.getDate().getNumberOfDaysSince(Date.getCurrentDate());
        if (remainingMinutes < 0) {
            remainingMinutes += 1440;
        }
        return remainingMinutes;
    }

    protected void handleTvDataUpdateFinished() {
        this.mReminderList.removeExpiredItems();
        if (this.mReminderListPanel != null) {
            this.mReminderListPanel.updateTableEntries();
        }
        this.updateRootNode(false);
    }

    private void showManageRemindersDialog() {
        Window w = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        ReminderListDialog dlg = new ReminderListDialog(w, this.mReminderList);
        int x = Integer.parseInt(this.mSettings.getProperty("dlgXPos", "-1"));
        int y = Integer.parseInt(this.mSettings.getProperty("dlgYPos", "-1"));
        if (x == -1 || y == -1) {
            UiUtilities.centerAndShow(dlg);
        } else {
            dlg.setLocation(x, y);
            dlg.setVisible(true);
        }
        this.mSettings.setProperty("dlgXPos", String.valueOf(dlg.getX()));
        this.mSettings.setProperty("dlgYPos", String.valueOf(dlg.getY()));
        this.mSettings.setProperty("dlgWidth", String.valueOf(dlg.getWidth()));
        this.mSettings.setProperty("dlgHeight", String.valueOf(dlg.getHeight()));
    }

    public static void resetLocalizer() {
        mLocalizer = Localizer.getLocalizerFor(ReminderPlugin.class);
    }

    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return this.mSettings.getProperty("provideTab", "true").equals("true") ? this.mWrapper : null;
    }

    AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        if (this.mInfoCreationThread != null && this.mInfoCreationThread.isAlive()) {
            try {
                this.mInfoCreationThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.mInfoPanel;
    }

    public boolean showDateSeparators() {
        return this.mSettings.getProperty("showDateSeparators", "true").equals("true");
    }

    public void setShowDateSeparators(boolean show) {
        this.mSettings.setProperty("showDateSeparators", String.valueOf(show));
        if (this.mReminderListPanel != null) {
            this.mReminderListPanel.installTableModel(false);
        }
    }

    public static int getStartIndexForBeforeReminders(Program program) {
        int remainingMinutes = ReminderPlugin.getTimeToProgramStart(program);
        if (program.isExpired()) {
            remainingMinutes = -31;
        } else if (program.isOnAir()) {
            remainingMinutes = program.getStartTime() > IOUtilities.getMinutesAfterMidnight() ? program.getStartTime() - 1440 - IOUtilities.getMinutesAfterMidnight() : program.getStartTime() - IOUtilities.getMinutesAfterMidnight();
        }
        int index = 0;
        for (RemindValue value : ReminderFrame.REMIND_AFTER_VALUE_ARR) {
            if (value.getMinutes() >= remainingMinutes || Math.abs(value.getMinutes()) >= program.getLength()) continue;
            ++index;
        }
        return index;
    }

    public static RemindValue[] calculatePossibleReminders(Program program) {
        int remainingMinutes = ReminderPlugin.getTimeToProgramStart(program);
        if (program.isExpired()) {
            remainingMinutes = -31;
        } else if (program.isOnAir()) {
            remainingMinutes = program.getStartTime() > IOUtilities.getMinutesAfterMidnight() ? program.getStartTime() - 1440 - IOUtilities.getMinutesAfterMidnight() : program.getStartTime() - IOUtilities.getMinutesAfterMidnight();
        }
        ArrayList<RemindValue> valueList = new ArrayList<RemindValue>();
        for (RemindValue value : ReminderFrame.REMIND_AFTER_VALUE_ARR) {
            if (value.getMinutes() >= remainingMinutes || Math.abs(value.getMinutes()) >= program.getLength()) continue;
            valueList.add(value);
        }
        for (RemindValue value : ReminderFrame.REMIND_BEFORE_VALUE_ARR) {
            if (value.getMinutes() >= remainingMinutes) continue;
            valueList.add(value);
        }
        return valueList.toArray(new RemindValue[valueList.size()]);
    }

    static {
        DATAFILE_PREFIX = "reminderplugin.ReminderPlugin";
        DATAFILE_NAME = "reminder.dat";
        mRootNode = new PluginTreeNode(mLocalizer.msg("pluginName", "Reminders"));
    }

    private class ReminderCenterPanel
    extends PluginCenterPanel {
        private ReminderCenterPanel() {
        }

        @Override
        public String getName() {
            return ReminderPlugin.getName();
        }

        @Override
        public JPanel getPanel() {
            return ReminderPlugin.this.mCenterPanel;
        }
    }
}

