/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class TraySoonSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = TrayBaseSettingsTab.mLocalizer;
    private JCheckBox mIsEnabled;
    private JCheckBox mShowTime;
    private JCheckBox mShowToolTip;
    private JLabel mIconSeparator;
    private JLabel mSeparator1;
    private JLabel mSeparator2;
    private static boolean mTrayIsEnabled = Settings.propTrayIsEnabled.getBoolean();
    private JEditorPane mHelpLabel;
    private JRadioButton mShowIconAndName;
    private JRadioButton mShowName;
    private JRadioButton mShowIcon;
    private JCheckBox mShowSortNumber;
    private static TraySoonSettingsTab mInstance;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        PanelBuilder builder = new PanelBuilder(new FormLayout("5dlu,pref:grow,5dlu", "pref,5dlu,pref,10dlu,pref,5dlu,pref,pref,pref,5dlu,pref,10dlu,pref,5dlu,pref,pref,fill:default:grow,pref"));
        builder.border(Borders.DIALOG);
        this.mIsEnabled = new JCheckBox(mLocalizer.msg("soonEnabled", "Show Soon running programs"), Settings.propTraySoonProgramsEnabled.getBoolean());
        this.mShowIconAndName = new JRadioButton(mLocalizer.msg("showIconName", "Show channel icon and channel name"), Settings.propTraySoonProgramsContainsName.getBoolean() && Settings.propTraySoonProgramsContainsIcon.getBoolean());
        this.mShowName = new JRadioButton(mLocalizer.msg("showName", "Show channel name"), Settings.propTraySoonProgramsContainsName.getBoolean() && !Settings.propTraySoonProgramsContainsIcon.getBoolean());
        this.mShowIcon = new JRadioButton(mLocalizer.msg("showIcon", "Show channel icon"), !Settings.propTraySoonProgramsContainsName.getBoolean() && Settings.propTraySoonProgramsContainsIcon.getBoolean());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mShowIconAndName);
        bg.add(this.mShowIcon);
        bg.add(this.mShowName);
        this.mShowSortNumber = new JCheckBox(mLocalizer.msg("showChannelNumber", "Show sort number"), Settings.propTraySoonProgramsShowingSortNumber.getBoolean());
        this.mShowTime = new JCheckBox(mLocalizer.msg("showTime", "Show start time"), Settings.propTraySoonProgramsContainsTime.getBoolean());
        this.mShowToolTip = new JCheckBox(mLocalizer.msg("showToolTip", "Show additional information of the program in a tool tip"), Settings.propTraySoonProgramsContainsToolTip.getBoolean());
        this.mShowToolTip.setToolTipText(mLocalizer.msg("toolTipTip", "Tool tips are small helper to something, like this one."));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#tray");
                }
            }
        });
        JPanel c = (JPanel)builder.addSeparator(mLocalizer.msg("soon", "Soon running programs"), CC.xyw(1, 1, 3));
        builder.add((Component)this.mIsEnabled, CC.xy(2, 3));
        JPanel c1 = (JPanel)builder.addSeparator(mLocalizer.msg("iconNameSeparator", "Channel icons/channel name"), CC.xyw(1, 5, 3));
        builder.add((Component)this.mShowIconAndName, CC.xy(2, 7));
        builder.add((Component)this.mShowIcon, CC.xy(2, 8));
        builder.add((Component)this.mShowName, CC.xy(2, 9));
        builder.add((Component)this.mShowSortNumber, CC.xy(2, 11));
        JPanel c2 = (JPanel)builder.addSeparator(mLocalizer.msg("settings", "Settings"), CC.xyw(1, 13, 3));
        builder.add((Component)this.mShowTime, CC.xy(2, 15));
        builder.add((Component)this.mShowToolTip, CC.xy(2, 16));
        builder.add((Component)this.mHelpLabel, CC.xyw(1, 18, 3));
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.mIconSeparator = (JLabel)c1.getComponent(0);
        this.mSeparator2 = (JLabel)c2.getComponent(0);
        this.setEnabled(true);
        this.mIsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraySoonSettingsTab.this.setEnabled(false);
            }
        });
        return builder.getPanel();
    }

    private void setEnabled(boolean trayStateChange) {
        this.mHelpLabel.setVisible(!mTrayIsEnabled);
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
            this.mIsEnabled.setEnabled(mTrayIsEnabled);
        }
        TrayProgramsChannelsSettingsTab.setSoonIsEnabled(this.mIsEnabled.isSelected());
        this.mIconSeparator.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSeparator2.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIcon.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIconAndName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowSortNumber.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowTime.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowToolTip.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
    }

    @Override
    public void saveSettings() {
        if (this.mIsEnabled != null) {
            Settings.propTraySoonProgramsEnabled.setBoolean(this.mIsEnabled.isSelected());
        }
        if (this.mShowIconAndName != null && this.mShowName != null && this.mShowIcon != null) {
            Settings.propTraySoonProgramsContainsName.setBoolean(this.mShowIconAndName.isSelected() || this.mShowName.isSelected());
            Settings.propTraySoonProgramsContainsIcon.setBoolean(this.mShowIconAndName.isSelected() || this.mShowIcon.isSelected());
        }
        if (this.mShowTime != null) {
            Settings.propTraySoonProgramsContainsTime.setBoolean(this.mShowTime.isSelected());
        }
        if (this.mShowToolTip != null) {
            Settings.propTraySoonProgramsContainsToolTip.setBoolean(this.mShowToolTip.isSelected());
        }
        if (this.mShowSortNumber != null) {
            Settings.propTraySoonProgramsShowingSortNumber.setBoolean(this.mShowSortNumber.isSelected());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("soon", "Soon running programs");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }
}

