/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.tray;

import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicMenuItemUI;
import tvbrowser.core.Settings;
import tvbrowser.ui.tray.ProgramMenuItem;
import util.io.IOUtilities;
import util.program.ProgramUtilities;
import util.ui.Localizer;
import util.ui.TextAreaIcon;
import util.ui.UiUtilities;

public class ProgramMenuItemUI
extends BasicMenuItemUI {
    private Program mProgram;
    private TextAreaIcon mChannelName;
    private Icon mIcon;
    private boolean mShowStartTime;
    private boolean mShowDate;
    private boolean mShowIcon;
    private boolean mShowName;
    private int mTime;

    public ProgramMenuItemUI(Program program, TextAreaIcon channelName, Icon icon, boolean showStartTime, boolean showDate, boolean showIcon, boolean showName, int time) {
        this.mProgram = program;
        this.mChannelName = channelName;
        this.mShowStartTime = showStartTime;
        this.mShowDate = showDate;
        this.mShowIcon = showIcon;
        this.mShowName = showName;
        this.mIcon = icon;
        this.mTime = time;
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        boolean isMarked;
        boolean isOnAir = ProgramUtilities.isOnAir(this.mProgram);
        g.clearRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        boolean bl = isMarked = this.mProgram.getMarkPriority() > -1;
        if (menuItem.isArmed()) {
            g.setColor(bgColor);
        } else if (!isOnAir && !isMarked && (this.mTime != -1 && Settings.propTrayOnTimeProgramsLightBackground.getColor().getAlpha() == 0 && Settings.propTrayOnTimeProgramsDarkBackground.getColor().getAlpha() == 0 || this.mTime == -1)) {
            g.setColor(menuItem.getBackground());
        } else {
            g.setColor(((ProgramMenuItem)menuItem).getDefaultBackground());
        }
        g.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        Insets i = menuItem.getMargin();
        int x = this.mIcon == null ? 0 : this.mIcon.getIconWidth() + i.left;
        int width = menuItem.getWidth() - x;
        int height = menuItem.getHeight();
        int top = i.top;
        int bottom = height - i.bottom;
        if (!menuItem.isArmed() && (isMarked || isOnAir || this.mTime != -1) && !UiUtilities.colorsInEqualRange(menuItem.getForeground(), Color.white, 20)) {
            g.setColor(Color.white);
            g.fillRect(x, top, menuItem.getWidth(), bottom);
        }
        Color markedColor = Plugin.getPluginManager().getTvBrowserSettings().getColorForMarkingPriority(this.mProgram.getMarkPriority());
        if (isMarked) {
            if (markedColor != null) {
                g.setColor(markedColor);
            }
            g.fillRect(x, top, menuItem.getWidth(), bottom);
        }
        if (isOnAir || this.mTime != -1) {
            int minutesAfterMidnight = this.mTime != -1 ? this.mTime : IOUtilities.getMinutesAfterMidnight();
            int progLength = this.mProgram.getLength();
            int startTime = this.mProgram.getHours() * 60 + this.mProgram.getMinutes();
            int elapsedMinutes = minutesAfterMidnight < startTime ? 1440 + minutesAfterMidnight - startTime : minutesAfterMidnight - startTime;
            int progressX = 0;
            if (progLength > 0) {
                progressX = elapsedMinutes * (width - i.left - i.right) / progLength;
            }
            if (!isMarked) {
                g.setColor(this.mTime == -1 ? Settings.propProgramTableColorOnAirLight.getColor() : Settings.propTrayOnTimeProgramsLightBackground.getColor());
                g.fillRect(x + progressX - i.right - i.left, top, width - progressX + i.right + i.left, bottom);
            }
            g.setColor(this.mTime == -1 ? Settings.propProgramTableColorOnAirDark.getColor() : (isMarked ? new Color(markedColor.darker().getRed(), markedColor.darker().getGreen(), markedColor.darker().getBlue(), markedColor.darker().getAlpha() / 3) : Settings.propTrayOnTimeProgramsDarkBackground.getColor()));
            g.fillRect(x, top, progressX - i.right - i.left, bottom);
        } else if (this.mProgram.isExpired()) {
            ((ProgramMenuItem)menuItem).stopTimer();
        }
        if (this.mIcon != null) {
            this.mIcon.paintIcon(menuItem, g, menuItem.getMargin().left, menuItem.getMargin().top);
        }
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (g instanceof Graphics2D && Settings.propTrayIsAntialiasing.getBoolean()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (menuItem.isArmed()) {
            g.setColor(this.selectionForeground);
        } else {
            g.setColor(menuItem.getForeground());
        }
        int x = this.mShowIcon ? this.mIcon.getIconWidth() + menuItem.getIconTextGap() : textRect.x;
        int y = (menuItem.getHeight() - this.mChannelName.getIconHeight()) / 2 - 1;
        if (this.mShowName) {
            this.mChannelName.paintIcon(null, g, x, y);
            x += Settings.propTrayChannelWidth.getInt() + menuItem.getIconTextGap();
        }
        int temp = y + menuItem.getFont().getSize() * (this.mChannelName.getLineCount() / 2 + 1);
        int n = y = this.mShowName && (this.mChannelName.getLineCount() & 1) == 1 ? temp : (menuItem.getHeight() - menuItem.getFont().getSize()) / 2 - 1 + menuItem.getFont().getSize();
        if (this.mShowDate) {
            g.setFont(menuItem.getFont().deriveFont(1));
            Date currentDate = Date.getCurrentDate();
            if (currentDate.equals(this.mProgram.getDate().addDays(1))) {
                g.drawString(Localizer.getLocalization("i18n_yesterday"), x, y);
            } else if (currentDate.equals(this.mProgram.getDate())) {
                g.drawString(Localizer.getLocalization("i18n_today"), x, y);
            } else if (currentDate.addDays(1).equals(this.mProgram.getDate())) {
                g.drawString(Localizer.getLocalization("i18n_tomorrow"), x, y);
            } else {
                g.drawString(this.mProgram.getDateString(), x, y);
            }
            x += ProgramMenuItem.DATE_WIDTH;
        }
        if (this.mShowStartTime) {
            g.setFont(menuItem.getFont().deriveFont(1));
            g.drawString(this.mProgram.getTimeString(), x, y);
            x += ProgramMenuItem.TIME_WIDTH;
        }
        g.setFont(menuItem.getFont());
        g.drawString(this.mProgram.getTitle().length() > 70 ? this.mProgram.getTitle().substring(0, 67) + "..." : this.mProgram.getTitle(), x, y);
    }
}

