/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JLabel;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.SoftwareUpdater;
import tvbrowser.ui.update.SoftwareUpdateItem;
import util.io.IOUtilities;
import util.io.Mirror;
import util.ui.Localizer;

public class PluginAutoUpdater {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginAutoUpdater.class);
    public static final String PLUGIN_UPDATES_FILENAME = "plugins.gz";
    public static final String DEFAULT_PLUGINS_DOWNLOAD_URL = "http://www.tvbrowser.org/plugins";
    private static final String[] DEFAULT_PLUGINS_UPDATE_MIRRORS = new String[]{"http://tvbrowser.dyndns.tv", "http://www.gamers-fusion.de/projects/tvbrowser.org/", "http://tvbrowser1.sam-schwedler.de", "http://tvbrowser.nicht-langweilig.de/data"};

    public static boolean downloadMirrorList() {
        return PluginAutoUpdater.downloadMirrorList(PluginAutoUpdater.getPluginUpdatesMirror().getUrl());
    }

    private static boolean downloadMirrorList(String baseUrl) {
        String name = PLUGIN_UPDATES_FILENAME.substring(0, PLUGIN_UPDATES_FILENAME.indexOf(46)) + "_" + "mirrorlist.gz";
        File target = new File(Settings.getUserSettingsDirName(), name);
        try {
            IOUtilities.download(new URL(baseUrl + (baseUrl.endsWith("/") ? "" : "/") + name), target);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return target.isFile();
    }

    public static SoftwareUpdateItem[] getUpdateItemsForVersionChange() throws IOException {
        String baseUrl = PluginAutoUpdater.getPluginUpdatesMirror().getUrl();
        PluginAutoUpdater.downloadMirrorList(baseUrl);
        URL url = new URL(baseUrl + "/" + PLUGIN_UPDATES_FILENAME);
        SoftwareUpdater softwareUpdater = new SoftwareUpdater(url, PluginLoader.getInstance().getInfoOfAvailablePlugins());
        return softwareUpdater.getAvailableSoftwareUpdateItems();
    }

    public static SoftwareUpdateItem[] getDataServicesForFirstStartup() throws IOException {
        Mirror mirr = PluginAutoUpdater.getPluginUpdatesMirror();
        if (mirr != null) {
            String baseUrl = mirr.getUrl();
            PluginAutoUpdater.downloadMirrorList(baseUrl);
            URL url = new URL(baseUrl + "/" + PLUGIN_UPDATES_FILENAME);
            SoftwareUpdater softwareUpdater = new SoftwareUpdater(url, 2, null);
            return softwareUpdater.getAvailableSoftwareUpdateItems();
        }
        return new SoftwareUpdateItem[0];
    }

    public static void searchForPluginUpdates(final JLabel infoLabel) {
        new Thread("Plugins update thread"){

            @Override
            public void run() {
                infoLabel.setText(mLocalizer.msg("searchForServer", "Search for plugin update server..."));
                String url = PluginAutoUpdater.getPluginUpdatesMirror().getUrl();
                PluginAutoUpdater.downloadMirrorList(url);
                MainFrame.getInstance().updatePlugins(url, 1, infoLabel, !Settings.propAutoUpdatePlugins.getBoolean());
            }
        }.start();
    }

    public static Mirror getPluginUpdatesMirror() {
        File file = new File(new File(Settings.getUserSettingsDirName()), PLUGIN_UPDATES_FILENAME.substring(0, PLUGIN_UPDATES_FILENAME.indexOf(46)) + "_" + "mirrorlist.gz");
        try {
            return Mirror.chooseUpToDateMirror(Mirror.readMirrorListFromFile(file), null, PLUGIN_UPDATES_FILENAME, "plugins", PluginAutoUpdater.class, mLocalizer.msg("error.additional", " Please inform the TV-Browser team."));
        }
        catch (Exception exc) {
            try {
                if (DEFAULT_PLUGINS_UPDATE_MIRRORS.length > 0) {
                    Mirror[] mirr = new Mirror[DEFAULT_PLUGINS_UPDATE_MIRRORS.length];
                    for (int i = 0; i < DEFAULT_PLUGINS_UPDATE_MIRRORS.length; ++i) {
                        mirr[i] = new Mirror(DEFAULT_PLUGINS_UPDATE_MIRRORS[i]);
                    }
                    return Mirror.chooseUpToDateMirror(mirr, null, PLUGIN_UPDATES_FILENAME, "plugins", PluginAutoUpdater.class, mLocalizer.msg("error.additional", " Please inform the TV-Browser team."));
                }
                throw exc;
            }
            catch (Exception exc2) {
                return new Mirror(DEFAULT_PLUGINS_DOWNLOAD_URL);
            }
        }
    }
}

