/*
 * Decompiled with CFR 0.152.
 */
package util.i18n;

import java.text.Normalizer;

public class WritingConversion {
    public static String removeDiacriticalMarks(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String replaceLatinDerivedLetters(String string) {
        String tmpval = WritingConversion.removeDiacriticalMarks(string);
        String retval = "";
        block36: for (char c : tmpval.toCharArray()) {
            switch (c) {
                case '\u00df': {
                    retval = retval + "ss";
                    continue block36;
                }
                case '\u00d8': {
                    retval = retval + "O";
                    continue block36;
                }
                case '\u00f8': {
                    retval = retval + "o";
                    continue block36;
                }
                case '\u00c6': {
                    retval = retval + "Ae";
                    continue block36;
                }
                case '\u00e6': {
                    retval = retval + "ae";
                    continue block36;
                }
                case '\u00d0': {
                    retval = retval + "D";
                    continue block36;
                }
                case '\u00f0': {
                    retval = retval + "d";
                    continue block36;
                }
                case '\u00de': {
                    retval = retval + "Th";
                    continue block36;
                }
                case '\u00fe': {
                    retval = retval + "th";
                    continue block36;
                }
                case '\u0152': {
                    retval = retval + "Oe";
                    continue block36;
                }
                case '\u0153': {
                    retval = retval + "oe";
                    continue block36;
                }
                case '\u0110': {
                    retval = retval + "D";
                    continue block36;
                }
                case '\u0111': {
                    retval = retval + "d";
                    continue block36;
                }
                case '\u0141': {
                    retval = retval + "L";
                    continue block36;
                }
                case '\u0142': {
                    retval = retval + "l";
                    continue block36;
                }
                case '\u0131': {
                    retval = retval + "i";
                    continue block36;
                }
                case '\u0130': {
                    retval = retval + "I";
                    continue block36;
                }
                case '\u0127': {
                    retval = retval + "h";
                    continue block36;
                }
                case '\u0126': {
                    retval = retval + "H";
                    continue block36;
                }
                case '\u014a': {
                    retval = retval + "N";
                    continue block36;
                }
                case '\u014b': {
                    retval = retval + "n";
                    continue block36;
                }
                case '\u0166': {
                    retval = retval + "T";
                    continue block36;
                }
                case '\u0167': {
                    retval = retval + "t";
                    continue block36;
                }
                case '\u0138': {
                    retval = retval + "k";
                    continue block36;
                }
                case '\u01b7': {
                    retval = retval + "Z";
                    continue block36;
                }
                case '\u0292': {
                    retval = retval + "z";
                    continue block36;
                }
                case '\u01ee': {
                    retval = retval + "Z";
                    continue block36;
                }
                case '\u01ef': {
                    retval = retval + "z";
                    continue block36;
                }
                case '\u018f': {
                    retval = retval + "E";
                    continue block36;
                }
                case '\u0259': {
                    retval = retval + "e";
                    continue block36;
                }
                case '\u01e4': {
                    retval = retval + "G";
                    continue block36;
                }
                case '\u01e5': {
                    retval = retval + "g";
                    continue block36;
                }
                case '\u0132': {
                    retval = retval + "IJ";
                    continue block36;
                }
                case '\u0133': {
                    retval = retval + "ij";
                    continue block36;
                }
                default: {
                    retval = retval + c;
                }
            }
        }
        return retval;
    }

    public static String replacePunctuation(String string, String replaceString) {
        return string.replaceAll("(\\p{Punct}|\u00bf|\u00a1|\u2012|\u2013|\u2014|\u2015|\u2018|\u2019|\u201a|\u201b|\u201c|\u201d|\u201e|\u201f|\u00ab|\u00bb)+", replaceString);
    }

    public static String removeRedundantWhitespaces(String string) {
        return string.replaceAll("\\s+", " ").trim();
    }

    public static String reduceToASCIILetters(String string, boolean replaceUnsupportedChars) {
        String retval = string;
        retval = WritingConversion.replacePunctuation(retval, " ");
        retval = WritingConversion.removeRedundantWhitespaces(retval);
        retval = WritingConversion.replaceLatinDerivedLetters(retval);
        if (replaceUnsupportedChars) {
            retval = retval.replaceAll("[^a-zA-Z0-9 ]", "_");
        }
        return retval;
    }
}

