/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SoftReferenceCache<T, K> {
    private Map<T, SoftReference<K>> mCacheHashMap = Collections.synchronizedMap(new HashMap());
    private Map<SoftReference<K>, T> mRefHashMap = Collections.synchronizedMap(new HashMap());
    private ReferenceQueue mRefQueue = new ReferenceQueue();

    public K get(T key) {
        this.cleanUp();
        SoftReference<K> ref = this.mCacheHashMap.get(key);
        K value = null;
        if (ref != null) {
            value = ref.get();
        }
        return value;
    }

    public void put(T key, K object) {
        this.cleanUp();
        SoftReference<K> ref = new SoftReference<K>(object, this.mRefQueue);
        this.mCacheHashMap.put(key, ref);
        this.mRefHashMap.put(ref, key);
    }

    public void remove(T key) {
        this.cleanUp();
        SoftReference<K> ref = this.mCacheHashMap.remove(key);
        if (ref != null) {
            this.mRefHashMap.remove(ref);
        }
    }

    public void clear() {
        this.mCacheHashMap.clear();
        this.mRefHashMap.clear();
    }

    public void cleanUp() {
        Reference ref = this.mRefQueue.poll();
        while (ref != null) {
            ref = this.mRefQueue.poll();
            this.mRefHashMap.remove(ref);
            if (ref == null) continue;
            T key = this.mRefHashMap.get(ref);
            this.mCacheHashMap.remove(key);
        }
    }

    public boolean containsKey(T key) {
        return this.mCacheHashMap.containsKey(key);
    }
}

