/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import util.paramhandler.ParamLibrary;
import util.paramhandler.ParamParser;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ParamCheckDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ParamCheckDialog.class);
    private ParamLibrary mParamLib;
    private String mCheckString;

    public ParamCheckDialog(Window parent, String check) {
        super(parent);
        this.setModal(true);
        this.mCheckString = check;
        this.mParamLib = new ParamLibrary();
        this.createGui();
        this.setLocationRelativeTo(parent);
    }

    @Deprecated
    public ParamCheckDialog(JDialog dialog, String check) {
        this((Window)dialog, check);
    }

    public ParamCheckDialog(Window parent, ParamLibrary lib, String check) {
        super(parent);
        this.setModal(true);
        this.mParamLib = lib;
        this.mCheckString = check;
        this.createGui();
        this.setLocationRelativeTo(parent);
    }

    @Deprecated
    public ParamCheckDialog(JDialog dialog, ParamLibrary lib, String check) {
        this((Window)dialog, lib, check);
    }

    @Deprecated
    public ParamCheckDialog(JFrame frame, String check) {
        this((Window)frame, check);
    }

    @Deprecated
    public ParamCheckDialog(JFrame frame, ParamLibrary lib, String check) {
        this((Window)frame, lib, check);
    }

    private void createGui() {
        this.setTitle(mLocalizer.msg("Result", "Result"));
        JPanel panel = (JPanel)this.getContentPane();
        UiUtilities.registerForClosing(this);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:default:grow, 3dlu, default", "default, 3dlu, fill:default:grow, 3dlu, default");
        panel.setLayout(layout);
        panel.setBorder(Borders.DLU4);
        panel.add((Component)new JLabel(mLocalizer.msg("Result", "Result") + ":"), cc.xyw(1, 1, 3));
        JTextArea area = new JTextArea();
        area.setWrapStyleWord(true);
        area.setEditable(false);
        area.setText(this.analyseString());
        final JScrollPane spane = new JScrollPane(area);
        panel.add((Component)spane, cc.xyw(1, 3, 3));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                spane.getVerticalScrollBar().setValue(0);
            }
        });
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParamCheckDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(ok);
        panel.add((Component)ok, cc.xy(3, 5));
        this.setSize(500, 400);
    }

    private String analyseString() {
        ParamParser parse = new ParamParser(this.mParamLib);
        String ret = parse.analyse(this.mCheckString, Plugin.getPluginManager().getExampleProgram());
        if (ret == null) {
            return "Error:\n" + parse.getErrorString();
        }
        return ret;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

