/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.ui.settings.SettingsDialog;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class DefaultProgramImportanceSelectionPanel
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DefaultProgramImportanceSelectionPanel.class);
    private JComboBox mProgramImportanceSelection;
    private JEditorPane mHelpLabel;

    private DefaultProgramImportanceSelectionPanel(byte importance, boolean showTitle, boolean withDefaultDialogBorder) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(showTitle ? new FormLayout("5dlu,pref,5dlu,pref,0dlu:grow", "pref,5dlu,pref,fill:0dlu:grow,10dlu,pref") : new FormLayout("5dlu,pref,5dlu,pref,0dlu:grow", "pref,fill:0dlu:grow,10dlu,pref"), this);
        if (withDefaultDialogBorder) {
            pb.border(Borders.DIALOG);
        }
        this.mProgramImportanceSelection = new JComboBox<String>(DefaultProgramImportanceSelectionPanel.getProgramImportanceNames(true));
        this.mProgramImportanceSelection.setSelectedIndex(this.getIndexForImportance(importance));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "The selected importance is used to determinate the transparency of a program. It's calculated over all plugins as mean value. Lower importance leads to higher transparency. This works only if the plugins are allowed to set the transparency at <a href=\"#link\">program panel settings</a>."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#programpanellook");
                }
            }
        });
        int y = 1;
        if (showTitle) {
            pb.addSeparator(DefaultProgramImportanceSelectionPanel.getTitle(), cc.xyw(1, y++, 5));
            ++y;
        }
        pb.addLabel(mLocalizer.msg("color", "Program importance:"), cc.xy(2, y));
        pb.add((Component)this.mProgramImportanceSelection, cc.xy(4, y++));
        ++y;
        pb.add((Component)this.mHelpLabel, cc.xyw(2, ++y, 4));
    }

    public static DefaultProgramImportanceSelectionPanel createPanel(byte importance, boolean showTitle, boolean withDefaultDialogBorder) {
        return new DefaultProgramImportanceSelectionPanel(importance, showTitle, withDefaultDialogBorder);
    }

    public byte getSelectedImportance() {
        switch (this.mProgramImportanceSelection.getSelectedIndex()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 10;
            }
        }
        return -1;
    }

    private int getIndexForImportance(byte importance) {
        switch (importance) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public static String getTitle() {
        return mLocalizer.msg("title", "Program transparency");
    }

    public static String[] getProgramImportanceNames(boolean withDefaultImportance) {
        if (withDefaultImportance) {
            return new String[]{mLocalizer.msg("color.default", "Default importance"), mLocalizer.msg("color.min", "Mininum importance"), mLocalizer.msg("color.lowerMedium", "Lower medium importance"), mLocalizer.msg("color.medium", "Medium importance"), mLocalizer.msg("color.higherMedium", "Higher medium importance"), mLocalizer.msg("color.max", "Maximum importance")};
        }
        return new String[]{mLocalizer.msg("color.min", "Mininum importance"), mLocalizer.msg("color.lowerMedium", "Lower medium importance"), mLocalizer.msg("color.medium", "Medium importance"), mLocalizer.msg("color.higherMedium", "Higher medium importance"), mLocalizer.msg("color.max", "Maximum importance")};
    }
}

