/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import util.ui.Localizer;

public class FileCheckBox
extends JComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FileCheckBox.class);
    protected String mTitle;
    protected JCheckBox mCheckbox;
    protected JTextField mTextfield;
    protected JButton mChoosebtn;
    protected JFileChooser mFileChooser;

    public FileCheckBox(String title, File file, int tab, boolean addButton) {
        this.mTitle = title;
        this.setLayout(new BorderLayout(5, 0));
        this.mCheckbox = new JCheckBox(title);
        this.mTextfield = file != null ? new JTextField(file.getAbsolutePath()) : new JTextField("");
        if (tab > 0) {
            Dimension dim = this.mTextfield.getPreferredSize();
            this.mCheckbox.setPreferredSize(new Dimension(tab, (int)dim.getHeight()));
        }
        this.mChoosebtn = new JButton(mLocalizer.ellipsisMsg("change", "Change"));
        this.add((Component)this.mCheckbox, "West");
        this.add((Component)this.mTextfield, "Center");
        if (addButton) {
            this.add((Component)this.mChoosebtn, "East");
        }
        this.mCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileCheckBox.this.setSelected(FileCheckBox.this.mCheckbox.isSelected());
            }
        });
        this.mChoosebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File f;
                int retVal;
                if (FileCheckBox.this.mFileChooser == null) {
                    FileCheckBox.this.mFileChooser = new JFileChooser();
                }
                if ((retVal = FileCheckBox.this.mFileChooser.showOpenDialog(FileCheckBox.this.getParent())) == 0 && (f = FileCheckBox.this.mFileChooser.getSelectedFile()) != null) {
                    FileCheckBox.this.mTextfield.setText(f.getAbsolutePath());
                    if (FileCheckBox.this.mTextfield.getKeyListeners().length == 1) {
                        FileCheckBox.this.mTextfield.getKeyListeners()[0].keyReleased(null);
                    }
                }
            }
        });
    }

    public void setFileChooser(JFileChooser chooser) {
        this.mFileChooser = chooser;
        String temp = this.mTextfield.getText();
        if (temp.indexOf(File.separator) != -1) {
            this.mFileChooser.setCurrentDirectory(new File(temp.substring(0, temp.lastIndexOf(File.separator) + 1)));
        }
    }

    public void setSelected(boolean value) {
        this.mCheckbox.setSelected(value);
        this.mTextfield.setEnabled(value);
        this.mChoosebtn.setEnabled(value);
    }

    public boolean isSelected() {
        return this.mCheckbox.isSelected();
    }

    public void setFile(File f) {
        if (f != null) {
            this.mTextfield.setText(f.getAbsolutePath());
        } else {
            this.mTextfield.setText("");
        }
    }

    public File getFile() {
        return new File(this.mTextfield.getText());
    }

    @Override
    public void setEnabled(boolean value) {
        this.mCheckbox.setEnabled(value);
        this.mTextfield.setEnabled(value);
        this.mChoosebtn.setEnabled(value);
    }

    @Override
    public boolean isEnabled() {
        return this.mTextfield.isEnabled();
    }

    public JTextField getTextField() {
        return this.mTextfield;
    }

    public JCheckBox getCheckBox() {
        return this.mCheckbox;
    }

    public JButton getButton() {
        return this.mChoosebtn;
    }

    public JButton removeButton() {
        this.remove(this.mChoosebtn);
        return this.mChoosebtn;
    }
}

