/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import util.io.IOUtilities;
import util.ui.LocalizerClassloader;

public class Localizer {
    private static Localizer mLocalizer = null;
    public static final String I18N_OK = "i18n_ok";
    public static final String I18N_CANCEL = "i18n_cancel";
    public static final String I18N_CLOSE = "i18n_close";
    public static final String I18N_DELETE = "i18n_delete";
    public static final String I18N_EDIT = "i18n_edit";
    public static final String I18N_PROGRAM = "i18n_program";
    public static final String I18N_PROGRAMS = "i18n_programs";
    public static final String I18N_CHANNEL = "i18n_channel";
    public static final String I18N_CHANNELS = "i18n_channels";
    public static final String I18N_HELP = "i18n_help";
    public static final String I18N_FILE = "i18n_file";
    public static final String I18N_ADD = "i18n_add";
    public static final String I18N_SETTINGS = "i18n_settings";
    public static final String I18N_UP = "i18n_up";
    public static final String I18N_DOWN = "i18n_down";
    public static final String I18N_LEFT = "i18n_left";
    public static final String I18N_RIGHT = "i18n_right";
    public static final String I18N_BACK = "i18n_back";
    public static final String I18N_NEXT = "i18n_next";
    public static final String I18N_PICTURES = "i18n_pictures";
    public static final String I18N_OPTIONS = "i18n_options";
    public static final String I18N_SELECT = "i18n_select";
    public static final String I18N_ERROR = "i18n_error";
    public static final String I18N_DEFAULT = "i18n_default";
    public static final String I18N_STANDARD = "i18n_standard";
    public static final String I18N_YESTERDAY = "i18n_yesterday";
    public static final String I18N_TODAY = "i18n_today";
    public static final String I18N_TOMORROW = "i18n_tomorrow";
    public static final String I18N_INFO = "i18n_info";
    public static final String I18N_WARNING = "i18n_warning";
    private static final Logger mLog = Logger.getLogger(Localizer.class.getName());
    private static HashMap<String, String> standardLocalizations;
    private static final Object[] ONE_ARG_ARR;
    private static final Object[] TWO_ARGS_ARR;
    private static final Object[] THREE_ARGS_ARR;
    private static final HashMap<Class, Localizer> mLocalizerCache;
    private String mBaseName;
    private HashMap<String, String> mResource;
    private String mKeyPrefix;
    private static final String ELLIPSIS = "...";
    private ClassLoader mParentClassLoader;

    protected Localizer(Class clazz) {
        this.initializeForClass(clazz);
    }

    protected void initializeForClass(Class clazz) {
        String className = clazz.getName();
        int lastDot = className.lastIndexOf(46);
        String packageName = lastDot == -1 ? "" : className.substring(0, lastDot);
        this.mKeyPrefix = className.substring(packageName.length() + 1) + ".";
        lastDot = packageName.lastIndexOf(46);
        this.mBaseName = lastDot == -1 ? packageName + "." + packageName : packageName + packageName.substring(lastDot);
        this.mParentClassLoader = clazz.getClassLoader();
    }

    private HashMap<String, String> loadResourceBundle() {
        if (this.mResource != null) {
            return this.mResource;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.mBaseName, Locale.getDefault(), new LocalizerClassloader(this.mParentClassLoader));
            if (bundle != null) {
                this.mResource = new HashMap();
                Enumeration<String> enumKeys = bundle.getKeys();
                while (enumKeys.hasMoreElements()) {
                    String key = enumKeys.nextElement();
                    if (!key.startsWith(this.mKeyPrefix)) continue;
                    this.mResource.put(key, bundle.getString(key));
                }
            }
        }
        catch (MissingResourceException exc) {
            mLog.warning("ResourceBundle not found: '" + this.mBaseName + "'");
        }
        return this.mResource;
    }

    protected static Localizer getCachedLocalizerFor(Class clazz) {
        return mLocalizerCache.get(clazz);
    }

    public static Localizer getLocalizerFor(Class clazz) {
        Localizer localizer = Localizer.getCachedLocalizerFor(clazz);
        if (localizer == null) {
            localizer = new Localizer(clazz);
            Localizer.addLocalizerToCache(clazz, localizer);
        }
        return localizer;
    }

    protected static void addLocalizerToCache(Class clazz, Localizer localizer) {
        mLocalizerCache.put(clazz, localizer);
    }

    public static void emptyLocalizerCache() {
        mLocalizerCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String msg(String key, String defaultMsg, Object arg1) {
        Object[] objectArray = ONE_ARG_ARR;
        synchronized (ONE_ARG_ARR) {
            Localizer.ONE_ARG_ARR[0] = arg1;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.msg(key, defaultMsg, ONE_ARG_ARR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String msg(String key, String defaultMsg, Object arg1, Object arg2) {
        Object[] objectArray = TWO_ARGS_ARR;
        synchronized (TWO_ARGS_ARR) {
            Localizer.TWO_ARGS_ARR[0] = arg1;
            Localizer.TWO_ARGS_ARR[1] = arg2;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.msg(key, defaultMsg, TWO_ARGS_ARR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String msg(String key, String defaultMsg, Object arg1, Object arg2, Object arg3) {
        Object[] objectArray = THREE_ARGS_ARR;
        synchronized (THREE_ARGS_ARR) {
            Localizer.THREE_ARGS_ARR[0] = arg1;
            Localizer.THREE_ARGS_ARR[1] = arg2;
            Localizer.THREE_ARGS_ARR[2] = arg3;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return this.msg(key, defaultMsg, THREE_ARGS_ARR);
        }
    }

    public String msg(String key, String defaultMsg, Object[] args) {
        String msg = this.msg(key, defaultMsg);
        this.checkMessage(key, msg);
        msg = IOUtilities.replace(msg, "'", "''");
        return MessageFormat.format(msg, args);
    }

    public String msg(String key, String defaultMsg) {
        return this.msg(key, defaultMsg, true);
    }

    public String msg(String key, String defaultMsg, boolean warn) {
        key = this.mKeyPrefix + key;
        String msg = null;
        if (this.loadResourceBundle() != null) {
            try {
                msg = this.mResource.get(key);
                if (warn) {
                    this.checkMessage(key, msg);
                }
            }
            catch (MissingResourceException exc) {
                // empty catch block
            }
        }
        if (msg == null) {
            if (this.mResource != null && warn) {
                final String fkey = key;
                Thread logThread = new Thread("Log missing resource"){

                    @Override
                    public void run() {
                        mLog.warning("Key '" + fkey + "' not found in resource bundle '" + Localizer.this.mBaseName + "'");
                    }
                };
                logThread.start();
            }
            return "[" + key + "#" + defaultMsg + "]";
        }
        return msg;
    }

    public Locale[] getAllAvailableLocales() {
        ArrayList<Locale> langArray = new ArrayList<Locale>();
        langArray.add(Locale.ENGLISH);
        try {
            File jar = new File("tvbrowser.jar");
            if (!jar.exists()) {
                URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                jar = new File(url.getFile());
            }
            JarFile file = new JarFile(jar);
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("tvbrowser/tvbrowser_") || name.lastIndexOf(".properties") <= 0) continue;
                name = name.substring(20, name.lastIndexOf(".properties"));
                langArray.add(Localizer.getLocaleForString(name));
            }
            this.addLocaleFiles(new File(Settings.getUserSettingsDirName() + "/lang/tvbrowser"), langArray);
            this.addLocaleFiles(new File("lang/tvbrowser"), langArray);
            this.addLocaleFiles(new File(Settings.getUserSettingsDirName() + "/languages"), langArray);
            this.addLocaleFiles(new File("/languages"), langArray);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Locale[] locales = langArray.toArray(new Locale[langArray.size()]);
        Arrays.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return locales;
    }

    private void addLocaleFiles(File dir2, ArrayList<Locale> langArray) {
        String[] files;
        if (dir2.exists() && dir2.isDirectory() && (files = dir2.list()) != null) {
            for (String string : files) {
                Locale loc;
                if (string.startsWith("tvbrowser_") && string.endsWith(".properties")) {
                    loc = Localizer.getLocaleForString(string.substring(10, string.lastIndexOf(".properties")));
                    if (langArray.contains(loc)) continue;
                    langArray.add(loc);
                    continue;
                }
                if (!string.startsWith("tvbrowser") || !string.toLowerCase().endsWith(".zip") || langArray.contains(loc = Localizer.getLocaleForString(string.substring(string.indexOf("_") + 1, string.lastIndexOf(".zip"))))) continue;
                langArray.add(loc);
            }
        }
    }

    public static Locale getLocaleForString(String string) {
        String[] split = string.split("_");
        if (split.length >= 3) {
            return new Locale(split[0], split[1], split[2]);
        }
        if (split.length == 2) {
            return new Locale(split[0], split[1]);
        }
        return new Locale(split[0]);
    }

    public static String getLocalization(String key) {
        String value;
        if (mLocalizer == null) {
            mLocalizer = Localizer.getLocalizerFor(Localizer.class);
        }
        if ((value = mLocalizer.msg(key, null)) == null) {
            if (key.equals(I18N_OK)) {
                value = "OK";
            } else if (key.equals(I18N_CANCEL)) {
                value = "Cancel";
            } else if (key.equals(I18N_CLOSE)) {
                value = "Close";
            } else if (key.equals(I18N_DELETE)) {
                value = "Delete";
            } else if (key.equals(I18N_EDIT)) {
                value = "Edit";
            } else if (key.equals(I18N_PROGRAM)) {
                value = "Program";
            } else if (key.equals(I18N_PROGRAMS)) {
                value = "Programs";
            } else if (key.equals(I18N_CHANNEL)) {
                value = "Channel";
            } else if (key.equals(I18N_CHANNELS)) {
                value = "Channels";
            } else if (key.equals(I18N_HELP)) {
                value = "Help";
            } else if (key.equals(I18N_FILE)) {
                value = "File";
            } else if (key.equals(I18N_ADD)) {
                value = "Add";
            } else if (key.equals(I18N_SETTINGS)) {
                value = "Settings";
            } else if (key.equals(I18N_UP)) {
                value = "Up";
            } else if (key.equals(I18N_DOWN)) {
                value = "Down";
            } else if (key.equals(I18N_LEFT)) {
                value = "Left";
            } else if (key.equals(I18N_RIGHT)) {
                value = "Right";
            } else if (key.equals(I18N_BACK)) {
                value = "Back";
            } else if (key.equals(I18N_NEXT)) {
                value = "Next";
            } else if (key.equals(I18N_PICTURES)) {
                value = "Pictures";
            } else if (key.equals(I18N_OPTIONS)) {
                value = "Options";
            } else if (key.equals(I18N_SELECT)) {
                value = "Select";
            } else if (key.equals(I18N_ERROR)) {
                value = "Error";
            } else if (key.equals(I18N_DEFAULT)) {
                value = "Default";
            }
        }
        return value;
    }

    public static String getEllipsisLocalization(String key) {
        return Localizer.ellipsisSuffix(Localizer.getLocalization(key));
    }

    private void checkMessage(String key, String localizedMessage) {
        if (TVBrowser.isStable()) {
            return;
        }
        if (this.mKeyPrefix.equals("Localizer.")) {
            return;
        }
        if (standardLocalizations == null) {
            HashMap<String, String> std = new HashMap<String, String>(20);
            HashMap<String, String> standardResource = Localizer.getLocalizerFor(Localizer.class).loadResourceBundle();
            for (Map.Entry<String, String> entry : standardResource.entrySet()) {
                String standardKey = entry.getKey();
                if (!standardKey.startsWith("Localizer.")) continue;
                std.put(entry.getValue(), standardKey);
            }
            standardLocalizations = std;
        }
        if (standardLocalizations.containsKey(localizedMessage)) {
            String standardKey = standardLocalizations.get(localizedMessage);
            mLog.warning("Localization of message '" + key + "' should be replaced by Localizer.getLocalization(" + standardKey.substring(0, 10) + standardKey.substring(10).toUpperCase() + ")");
        }
    }

    public String ellipsisMsg(String key, String defaultMessage) {
        return Localizer.ellipsisSuffix(this.msg(key, defaultMessage));
    }

    private static String ellipsisSuffix(String msg) {
        if (msg.endsWith(ELLIPSIS)) {
            msg = msg.substring(0, msg.length() - ELLIPSIS.length()).trim();
        }
        return msg + ELLIPSIS;
    }

    public String ellipsisMsg(String key, String defaultMsg, Object arg1) {
        return Localizer.ellipsisSuffix(this.msg(key, defaultMsg, arg1));
    }

    public boolean hasMessage(String key) {
        this.loadResourceBundle();
        if (this.mResource == null) {
            return false;
        }
        return this.mResource.containsKey(key);
    }

    public String ellipsis(String someString) {
        if (someString == null) {
            return null;
        }
        return Localizer.ellipsisSuffix(someString);
    }

    static {
        ONE_ARG_ARR = new Object[1];
        TWO_ARGS_ARR = new Object[2];
        THREE_ARGS_ARR = new Object[3];
        mLocalizerCache = new HashMap();
    }
}

