/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Program;
import devplugin.ProgramFieldType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import util.io.IOUtilities;

public class MultipleFieldReader
extends Reader {
    private static final String DEFAULT_FIELD_SEPARATOR = " - ";
    private Program mProgram;
    private String[] mFieldSeparators;
    private ProgramFieldType[] mInfoFieldArr;
    private int mCurrentField;
    private int mReadFieldCount;
    private StringReader mCurrentFieldReader;

    public MultipleFieldReader(Program program, ProgramFieldType[] infoFieldArr) {
        this(program, infoFieldArr, DEFAULT_FIELD_SEPARATOR);
    }

    public MultipleFieldReader(Program program, ProgramFieldType[] infoFieldArr, String fieldSeparator) {
        String[] fieldSeparatorArr = new String[infoFieldArr.length];
        this.mProgram = program;
        this.mInfoFieldArr = infoFieldArr;
        this.mFieldSeparators = fieldSeparatorArr;
        Arrays.fill(this.mFieldSeparators, fieldSeparator);
        this.mCurrentField = -1;
        this.mReadFieldCount = 0;
    }

    public MultipleFieldReader(Program program, ProgramFieldType[] infoFieldArr, String[] fieldSeparatorArr) {
        this.mProgram = program;
        this.mInfoFieldArr = infoFieldArr;
        this.mFieldSeparators = fieldSeparatorArr;
        this.mCurrentField = -1;
        this.mReadFieldCount = 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int readCount;
        while (true) {
            this.checkFieldReader();
            if (this.mCurrentFieldReader == null) {
                return -1;
            }
            readCount = this.mCurrentFieldReader.read(cbuf, off, len);
            if (readCount != -1) break;
            this.mCurrentFieldReader = null;
        }
        return readCount;
    }

    @Override
    public int read() throws IOException {
        int readChar;
        while (true) {
            this.checkFieldReader();
            if (this.mCurrentFieldReader == null) {
                return -1;
            }
            readChar = this.mCurrentFieldReader.read();
            if (readChar != -1) break;
            this.mCurrentFieldReader = null;
        }
        return readChar;
    }

    private void checkFieldReader() {
        if (this.mCurrentFieldReader == null) {
            ++this.mCurrentField;
            if (this.mCurrentField < this.mInfoFieldArr.length) {
                ProgramFieldType fieldType = this.mInfoFieldArr[this.mCurrentField];
                String fieldValue = null;
                if (fieldType.getFormat() == 3) {
                    String description;
                    fieldValue = this.mProgram.getTextField(fieldType);
                    if (fieldType == ProgramFieldType.SHORT_DESCRIPTION_TYPE && this.containsDescription(this.mInfoFieldArr) && this.isShortVersion(fieldValue, description = this.mProgram.getDescription())) {
                        fieldValue = null;
                    }
                } else if (fieldType.getFormat() == 5) {
                    fieldValue = this.mProgram.getTimeFieldAsString(fieldType);
                } else if (fieldType.getFormat() == 4) {
                    fieldValue = fieldType.equals(ProgramFieldType.EPISODE_NUMBER_TYPE) && this.mProgram.hasFieldValue(ProgramFieldType.EPISODE_NUMBER_TYPE) ? IOUtilities.decodeSingleFieldValueToMultipleEpisodeString(this.mProgram.getIntField(fieldType)) : this.mProgram.getIntFieldAsString(fieldType);
                }
                if (fieldValue == null) {
                    this.checkFieldReader();
                } else {
                    if (this.mReadFieldCount > 0 && this.mFieldSeparators.length >= this.mCurrentField) {
                        fieldValue = this.mFieldSeparators[this.mCurrentField - 1].replace(";#;", "") + fieldValue;
                    }
                    this.mCurrentFieldReader = new StringReader(fieldValue);
                    ++this.mReadFieldCount;
                }
            } else {
                this.mCurrentFieldReader = null;
            }
        }
    }

    private boolean containsDescription(ProgramFieldType[] infoFieldArr) {
        for (ProgramFieldType element : infoFieldArr) {
            if (element != ProgramFieldType.DESCRIPTION_TYPE) continue;
            return true;
        }
        return false;
    }

    private boolean isShortVersion(String shortDesc, String description) {
        if (shortDesc == null || description == null) {
            return false;
        }
        StringBuilder shortInfo = new StringBuilder(shortDesc.trim());
        while (shortInfo.toString().endsWith(".")) {
            shortInfo.deleteCharAt(shortInfo.length() - 1);
        }
        return description.trim().startsWith(shortInfo.toString());
    }

    @Override
    public void close() {
    }
}

