/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import util.ui.DragAndDropMouseListener;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.TabLayout;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemRenderer;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class OrderChooser
extends JPanel
implements ListDropAction {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(OrderChooser.class);
    private JList mList;
    private DefaultListModel mListModel;
    private SelectableItemRenderer mItemRenderer;
    private JButton mUpBt;
    private JButton mDownBt;
    private JButton mSelectAllBt;
    private JButton mDeSelectAllBt;
    private boolean mIsEnabled = true;
    private JScrollPane mScrollPane;
    private JPanel mButtonPanel;

    public OrderChooser(Object[] currOrder, Object[] allItems) {
        this(currOrder, allItems, false);
    }

    public OrderChooser(Object[] currOrder, Object[] allItems, boolean showSelectionButtons) {
        this(currOrder, allItems, showSelectionButtons, null, null);
    }

    public OrderChooser(Object[] currOrder, Object[] allItems, Class renderClass, SelectableItemRendererCenterComponentIf renderComponent) {
        this(currOrder, allItems, false, renderClass, renderComponent);
    }

    public OrderChooser(Object[] currOrder, Object[] allItems, boolean showSelectionButtons, Class renderClass, SelectableItemRendererCenterComponentIf renderComponent) {
        super(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout(0, 3));
        this.mListModel = new DefaultListModel();
        this.setEntries(currOrder, allItems);
        this.mList = new JList(this.mListModel);
        this.mItemRenderer = new SelectableItemRenderer();
        this.mList.setCellRenderer(this.mItemRenderer);
        if (renderClass != null && renderComponent != null) {
            this.mItemRenderer.setCenterRendererComponent(renderClass, renderComponent);
        }
        ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mList, this.mList, this);
        new DragAndDropMouseListener(this.mList, this.mList, this, dnDHandler);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int index;
                if (evt.getX() < OrderChooser.this.mItemRenderer.getSelectionWidth() && OrderChooser.this.mIsEnabled && (index = OrderChooser.this.mList.locationToIndex(evt.getPoint())) != -1) {
                    SelectableItem item;
                    item.setSelected(!(item = (SelectableItem)OrderChooser.this.mListModel.elementAt(index)).isSelected());
                    OrderChooser.this.mList.repaint();
                }
            }
        });
        this.mList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    Object[] objs;
                    for (Object obj : objs = OrderChooser.this.mList.getSelectedValues()) {
                        SelectableItem item;
                        if (!(obj instanceof SelectableItem)) continue;
                        item.setSelected(!(item = (SelectableItem)obj).isSelected());
                    }
                    OrderChooser.this.mList.repaint();
                }
            }
        });
        this.mScrollPane = new JScrollPane(this.mList);
        main.add((Component)this.mScrollPane, "Center");
        this.add((Component)main, "Center");
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(BorderFactory.createEmptyBorder(0, Sizes.dialogUnitXAsPixel(3, p1), 0, 0));
        this.mButtonPanel = new JPanel(new TabLayout(1));
        this.add((Component)p1, "East");
        p1.add((Component)this.mButtonPanel, "North");
        this.mUpBt = new JButton(TVBrowserIcons.up(22));
        this.mUpBt.setToolTipText(mLocalizer.msg("tooltip.up", "Move selected rows up"));
        this.mUpBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UiUtilities.moveSelectedItems(OrderChooser.this.mList, -1);
            }
        });
        this.mButtonPanel.add(this.mUpBt);
        this.mDownBt = new JButton(TVBrowserIcons.down(22));
        this.mDownBt.setToolTipText(mLocalizer.msg("tooltip.down", "Move selected rows down"));
        this.mDownBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UiUtilities.moveSelectedItems(OrderChooser.this.mList, 1);
            }
        });
        this.mButtonPanel.add(this.mDownBt);
        JPanel p3 = new JPanel(new BorderLayout());
        this.mSelectAllBt = new JButton(mLocalizer.msg("addAll", "Select all items"));
        this.mSelectAllBt.setToolTipText(mLocalizer.msg("tooltip.all", "Select all items in the list."));
        this.mSelectAllBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderChooser.this.selectAll();
            }
        });
        p3.add((Component)this.mSelectAllBt, "West");
        this.mDeSelectAllBt = new JButton(mLocalizer.msg("delAll", "Deselect all items"));
        this.mDeSelectAllBt.setToolTipText(mLocalizer.msg("tooltip.none", "Deselect all items in the list."));
        this.mDeSelectAllBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderChooser.this.clearSelection();
            }
        });
        p3.add((Component)this.mDeSelectAllBt, "East");
        if (showSelectionButtons) {
            main.add((Component)p3, "South");
        }
    }

    private void setEntries(Object[] currOrder, Object[] allItems) {
        this.mListModel.removeAllElements();
        for (Object element : currOrder) {
            if (!this.contains(allItems, element)) continue;
            SelectableItem item = new SelectableItem(element, true);
            this.mListModel.addElement(item);
        }
        for (int i = 0; i < allItems.length; ++i) {
            if (this.contains(currOrder, allItems[i])) continue;
            SelectableItem item = new SelectableItem(allItems[i], false);
            this.mListModel.addElement(item);
        }
    }

    public JButton getUpButton() {
        return this.mUpBt;
    }

    public JButton getDownButton() {
        return this.mDownBt;
    }

    private boolean contains(Object[] array, Object obj) {
        for (Object element : array) {
            if (!element.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public Object[] getOrder() {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (int i = 0; i < this.mListModel.size(); ++i) {
            SelectableItem item = (SelectableItem)this.mListModel.elementAt(i);
            if (!item.isSelected()) continue;
            objList.add(item.getItem());
        }
        Object[] asArr = new Object[objList.size()];
        objList.toArray(asArr);
        return asArr;
    }

    public void invertSelection() {
        if (this.mIsEnabled) {
            for (int i = 0; i < this.mListModel.size(); ++i) {
                SelectableItem item;
                item.setSelected(!(item = (SelectableItem)this.mListModel.elementAt(i)).isSelected());
            }
            this.mList.repaint();
        }
    }

    public void selectAll() {
        if (this.mIsEnabled) {
            for (int i = 0; i < this.mListModel.size(); ++i) {
                SelectableItem item = (SelectableItem)this.mListModel.elementAt(i);
                item.setSelected(true);
            }
            this.mList.repaint();
        }
    }

    public void setOrder(Object[] currOrder, Object[] allItems) {
        this.setEntries(currOrder, allItems);
        this.mList.repaint();
    }

    public void clearSelection() {
        if (this.mIsEnabled) {
            for (int i = 0; i < this.mListModel.size(); ++i) {
                SelectableItem item = (SelectableItem)this.mListModel.elementAt(i);
                item.setSelected(false);
            }
            this.mList.repaint();
        }
    }

    @Override
    public void drop(JList source, JList target, int rows, boolean move) {
        UiUtilities.moveSelectedItems(target, rows, true);
    }

    @Override
    public void setEnabled(boolean value) {
        this.mIsEnabled = value;
        this.mItemRenderer.setEnabled(value);
        this.mList.setEnabled(value);
        this.mUpBt.setEnabled(value);
        this.mDownBt.setEnabled(value);
        this.mSelectAllBt.setEnabled(value);
        this.mDeSelectAllBt.setEnabled(value);
        this.mScrollPane.getVerticalScrollBar().setEnabled(value);
        this.mScrollPane.setWheelScrollingEnabled(value);
    }

    public void setSelectionMode(int value) {
        this.mList.setSelectionMode(value);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.mList.addListSelectionListener(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mList.addMouseListener(listener);
    }

    public void refreshList() {
        this.mList.repaint();
    }

    public void addElement(Object value) {
        SelectableItem item = new SelectableItem(value, true);
        this.mListModel.addElement(item);
        this.mList.repaint();
    }

    public void removeElementAt(int index) {
        this.mListModel.removeElementAt(index);
        this.mList.repaint();
    }

    public int getSelectedIndex() {
        return this.mList.getSelectedIndex();
    }

    public Object getSelectedValue() {
        if (this.mList.getSelectedValue() != null) {
            SelectableItem item = (SelectableItem)this.mList.getSelectedValue();
            return item.getItem();
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        this.mList.setSelectedIndex(index);
    }

    public int getItemCount() {
        return this.mList.getModel().getSize();
    }

    public void addButton(JButton button) {
        this.mButtonPanel.add(button);
    }

    public void addElement(Object value, int index, boolean selected) {
        SelectableItem item = new SelectableItem(value, selected);
        if (index < this.mListModel.getSize()) {
            this.mListModel.add(index, item);
        } else {
            this.mListModel.addElement(item);
        }
        this.mList.repaint();
    }
}

