/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Date;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.HashSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.ProgramPanel;

public class ProgramListCellRenderer
extends DefaultListCellRenderer {
    private static Color FIRST_ROW_COLOR = new Color(220, 220, 220, 150);
    private static Color FIRST_ROW_COLOR_EXPIRED = new Color(220, 220, 220, 55);
    private static Color SECOND_ROW_COLOR = new Color(220, 220, 220, 150);
    private static Color SECOND_ROW_COLOR_EXPIRED = new Color(220, 220, 220, 55);
    private JPanel mMainPanel;
    private JLabel mHeaderLb;
    private ProgramPanel mProgramPanel;
    private HashSet<Program> mProgramSet = new HashSet();

    public ProgramListCellRenderer() {
        this(new ProgramPanelSettings(0, -1, -1, false, true, 10));
    }

    public ProgramListCellRenderer(ProgramPanelSettings settings) {
        SECOND_ROW_COLOR = UIManager.getColor("List.foreground");
        SECOND_ROW_COLOR = new Color(SECOND_ROW_COLOR.getRed(), SECOND_ROW_COLOR.getGreen(), SECOND_ROW_COLOR.getBlue(), 30);
        SECOND_ROW_COLOR_EXPIRED = UIManager.getColor("List.foreground");
        SECOND_ROW_COLOR_EXPIRED = new Color(SECOND_ROW_COLOR_EXPIRED.getRed(), SECOND_ROW_COLOR_EXPIRED.getGreen(), SECOND_ROW_COLOR_EXPIRED.getBlue(), 15);
        FIRST_ROW_COLOR = UIManager.getColor("List.background");
        FIRST_ROW_COLOR = new Color(FIRST_ROW_COLOR.getRed(), FIRST_ROW_COLOR.getGreen(), FIRST_ROW_COLOR.getBlue(), 30);
        FIRST_ROW_COLOR_EXPIRED = UIManager.getColor("List.background");
        FIRST_ROW_COLOR_EXPIRED = new Color(FIRST_ROW_COLOR_EXPIRED.getRed(), FIRST_ROW_COLOR_EXPIRED.getGreen(), FIRST_ROW_COLOR_EXPIRED.getBlue(), 15);
        this.initializeSettings(settings);
    }

    private void initializeSettings(ProgramPanelSettings settings) {
        this.mMainPanel = new JPanel(new BorderLayout());
        this.mMainPanel.setOpaque(true);
        this.mHeaderLb = new JLabel();
        this.mMainPanel.add((Component)this.mHeaderLb, "North");
        this.mProgramPanel = new ProgramPanel(settings);
        this.mMainPanel.add((Component)this.mProgramPanel, "Center");
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Object nextValue;
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null && value instanceof Program) {
            Program program = (Program)value;
            Insets borderInsets = label.getBorder().getBorderInsets(label);
            this.mProgramPanel.setWidth(list.getWidth() - borderInsets.left - borderInsets.right);
            this.mProgramPanel.setProgram(program);
            this.mProgramPanel.setPaintExpiredProgramsPale(!isSelected);
            this.mProgramPanel.setTextColor(label.getForeground());
            this.mProgramPanel.setBackground(label.getBackground());
            if (!this.mProgramSet.contains(program)) {
                this.mProgramSet.add(program);
                program.addChangeListener(new ProgramListChangeListener(list));
            }
            StringBuilder labelString = new StringBuilder();
            int days = program.getDate().getNumberOfDaysSince(Date.getCurrentDate());
            switch (days) {
                case -1: {
                    labelString.append(Localizer.getLocalization("i18n_yesterday"));
                    labelString.append(", ").append(program.getDateString());
                    break;
                }
                case 0: {
                    labelString.append(Localizer.getLocalization("i18n_today"));
                    labelString.append(", ").append(program.getDateString());
                    break;
                }
                case 1: {
                    labelString.append(Localizer.getLocalization("i18n_tomorrow"));
                    labelString.append(", ").append(program.getDateString());
                    break;
                }
                default: {
                    labelString.append(program.getDate().toString());
                }
            }
            labelString.append(" - ").append(program.getChannel().getName());
            this.mHeaderLb.setText(labelString.toString());
            if (program.isExpired() && !isSelected) {
                this.mHeaderLb.setForeground(Color.gray);
            } else {
                this.mHeaderLb.setForeground(label.getForeground());
            }
            this.mMainPanel.setBackground(label.getBackground());
            if (isSelected) {
                this.mMainPanel.setForeground(label.getForeground());
            }
            this.mMainPanel.setEnabled(label.isEnabled());
            this.mMainPanel.setBorder(label.getBorder());
            if (!isSelected && program.getMarkPriority() < 0) {
                if ((index & 1) == 1) {
                    this.mMainPanel.setBackground(program.isExpired() ? SECOND_ROW_COLOR_EXPIRED : SECOND_ROW_COLOR);
                } else {
                    this.mMainPanel.setBackground(program.isExpired() ? FIRST_ROW_COLOR_EXPIRED : FIRST_ROW_COLOR);
                }
            }
            return this.mMainPanel;
        }
        if (value instanceof String && list.getModel().getSize() > index + 1 && (nextValue = list.getModel().getElementAt(index + 1)) instanceof Program) {
            JPanel separator = new JPanel(new FormLayout("0dlu:grow,default,0dlu:grow", "5dlu,default,5dlu"));
            separator.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, UIManager.getColor("Label.foreground")));
            if (list.getModel().getSize() > index + 1) {
                JLabel date = new JLabel(((Program)nextValue).getDateString());
                date.setFont(date.getFont().deriveFont(date.getFont().getSize2D() + 4.0f).deriveFont(1));
                separator.add((Component)date, new CellConstraints().xy(2, 2));
                return separator;
            }
        }
        return label;
    }

    private static final class ProgramListChangeListener
    implements ChangeListener {
        private final JList mList;

        private ProgramListChangeListener(JList list) {
            this.mList = list;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source;
            if (this.mList != null && (source = e.getSource()) instanceof Program) {
                Program program = (Program)source;
                AbstractListModel model = (AbstractListModel)this.mList.getModel();
                ListDataListener[] listeners = model.getListDataListeners();
                int itemIndex = -1;
                for (int i = 0; i < model.getSize(); ++i) {
                    if (model.getElementAt(i) != program) continue;
                    itemIndex = i;
                    break;
                }
                if (itemIndex >= 0) {
                    for (ListDataListener listener : listeners) {
                        listener.contentsChanged(new ListDataEvent(program, 0, itemIndex, itemIndex));
                    }
                }
            }
        }
    }
}

