/*
 * Decompiled with CFR 0.152.
 */
package util.ui.html;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.util.Translate;
import util.io.IOUtilities;

public class HTMLTextHelper {
    public static String convertTextToHtml(String text) {
        return HTMLTextHelper.convertTextToHtml(text, true);
    }

    public static String convertTextToHtml(String text, boolean createLinks) {
        text = text.replaceAll("(?i)<script.*?(>.*?</script>|/>)", "");
        text = IOUtilities.replace(text.trim(), "<", "&lt;");
        text = IOUtilities.replace(text.trim(), ">", "&gt;");
        text = IOUtilities.replace(text.trim(), "\n", "<br>");
        if (createLinks) {
            Matcher matcher = Pattern.compile("(http[s]?://|www\\.)[^\\s<\"']*").matcher(text);
            StringBuilder result = new StringBuilder();
            int end = 0;
            while (matcher.find()) {
                result.append(text.substring(end, matcher.start()));
                end = matcher.end();
                String linkText = text.substring(matcher.start(), matcher.end());
                if (linkText.endsWith(")") && result.length() > 0 && result.charAt(result.length() - 1) == '(') {
                    linkText = linkText.substring(0, linkText.length() - 1);
                    --end;
                }
                while (linkText.endsWith(".")) {
                    linkText = linkText.substring(0, linkText.length() - 1);
                    --end;
                }
                result.append("<a href=\"");
                if (!linkText.toLowerCase().startsWith("http://") && !linkText.toLowerCase().startsWith("https://")) {
                    result.append("http://");
                }
                result.append(linkText);
                result.append("\">");
                if (linkText.startsWith("http://")) {
                    linkText = linkText.substring("http://".length());
                }
                if (linkText.startsWith("https://")) {
                    linkText = linkText.substring("https://".length());
                }
                if (linkText.endsWith("/")) {
                    linkText = linkText.substring(0, linkText.length() - "/".length());
                }
                result.append(linkText.length() > 40 ? linkText.substring(0, 40) + "..." : linkText);
                result.append("</a>");
            }
            result.append(text.substring(end));
            text = result.toString();
        }
        return text;
    }

    public static String convertHtmlToText(String html) {
        if (html == null) {
            return null;
        }
        String temp = Translate.decode(html);
        temp = temp.replace("<br>", "\n");
        return temp;
    }

    public static String getCssRgbColorEntry(Color c) {
        StringBuilder builder = new StringBuilder("rgb(");
        builder.append(c.getRed());
        builder.append(",");
        builder.append(c.getGreen());
        builder.append(",");
        builder.append(c.getBlue());
        builder.append(")");
        return builder.toString();
    }
}

