/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.database;

import com._17od.upm.database.AccountInformation;
import com._17od.upm.database.ExportException;
import com._17od.upm.database.ImportException;
import com._17od.upm.util.Translator;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;

public class AccountsCSVMarshaller {
    public void marshal(ArrayList accounts, File file) throws ExportException {
        if (file.exists()) {
            throw new ExportException("The file to export to already exists");
        }
        try {
            FileWriter writer = new FileWriter(file);
            CsvWriter csvWriter = new CsvWriter((Writer)writer, ',');
            for (int i = 0; i < accounts.size(); ++i) {
                csvWriter.writeRecord(this.getAccountAsStringArray((AccountInformation)accounts.get(i)));
            }
            csvWriter.close();
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
    }

    public ArrayList unmarshal(File file) throws ImportException {
        ArrayList<AccountInformation> accounts = new ArrayList<AccountInformation>();
        try {
            CsvReader csvReader = new CsvReader((Reader)new FileReader(file));
            while (csvReader.readRecord()) {
                if (csvReader.getColumnCount() != 5) {
                    throw new ImportException(Translator.translate("notCSVFileError", new Object[]{file.getAbsoluteFile(), new Long(csvReader.getCurrentRecord() + 1L)}));
                }
                accounts.add(new AccountInformation(csvReader.get(0), csvReader.get(1), csvReader.get(2), csvReader.get(3), csvReader.get(4)));
            }
        }
        catch (FileNotFoundException e) {
            throw new ImportException(e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        return accounts;
    }

    private String[] getAccountAsStringArray(AccountInformation account) {
        String[] arr = new String[]{account.getAccountName(), new String(account.getUserId()), new String(account.getPassword()), new String(account.getUrl()), new String(account.getNotes())};
        return arr;
    }
}

