/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.gui;

import com._17od.upm.gui.EscapeDialog;
import com._17od.upm.gui.MainWindow;
import com._17od.upm.util.Preferences;
import com._17od.upm.util.Translator;
import com._17od.upm.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.commons.codec.binary.Base64;

public class OptionsDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private JTextField dbToLoadOnStartup;
    private JCheckBox enableProxyCheckbox;
    private JCheckBox hideAccountPasswordCheckbox;
    private JCheckBox inclEscCharstoPassCheckbox;
    private JCheckBox storeWindowPosCheckbox;
    private JCheckBox appAlwaysonTopCheckbox;
    private JLabel accountPasswordLengthLabel;
    private JTextField accountPasswordLength;
    private JTextField httpProxyHost;
    private JTextField httpProxyPort;
    private JTextField httpProxyUsername;
    private JPasswordField httpProxyPassword;
    private JCheckBox hidePasswordCheckbox;
    private JCheckBox databaseAutoLockCheckbox;
    private JTextField databaseAutoLockTime;
    private JCheckBox acceptSelfSignedCertsCheckbox;
    private JLabel proxyLabel;
    private JLabel proxyPortLabel;
    private JLabel proxyUsernameLabel;
    private JLabel proxyPasswordLabel;
    private JComboBox localeComboBox;
    private boolean okClicked = false;
    private JFrame parentFrame;
    private boolean languageChanged;
    private char defaultEchoChar;

    public OptionsDialog(JFrame frame) {
        super(frame, Translator.translate("options"), true);
        Container container = this.getContentPane();
        Border emptyBorder = BorderFactory.createEmptyBorder(2, 5, 5, 5);
        JPanel emptyBorderPanel = new JPanel();
        emptyBorderPanel.setLayout(new BoxLayout(emptyBorderPanel, 1));
        emptyBorderPanel.setBorder(emptyBorder);
        container.add(emptyBorderPanel);
        Border etchedBorder = BorderFactory.createEtchedBorder(1);
        TitledBorder etchedTitleBorder = BorderFactory.createTitledBorder(etchedBorder, ' ' + Translator.translate("general") + ' ');
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(etchedTitleBorder);
        emptyBorderPanel.add(mainPanel);
        GridBagConstraints c = new GridBagConstraints();
        JLabel urlLabel = new JLabel(Translator.translate("dbToLoadOnStartup"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 3, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        mainPanel.add((Component)urlLabel, c);
        this.dbToLoadOnStartup = new JTextField(Preferences.get("DBToLoadOnStartup"), 25);
        this.dbToLoadOnStartup.setHorizontalAlignment(2);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        mainPanel.add((Component)this.dbToLoadOnStartup, c);
        JButton dbToLoadOnStartupButton = new JButton("...");
        dbToLoadOnStartupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.getDBToLoadOnStartup();
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 22;
        c.insets = new Insets(0, 0, 5, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)dbToLoadOnStartupButton, c);
        JLabel localeLabel = new JLabel(Translator.translate("language"));
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 3, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        mainPanel.add((Component)localeLabel, c);
        this.localeComboBox = new JComboBox<Object>(this.getSupportedLocaleNames());
        for (int i = 0; i < this.localeComboBox.getItemCount(); ++i) {
            String currentLanguage = Translator.getCurrentLocale().getLanguage();
            if (currentLanguage.equals("")) {
                currentLanguage = "en";
            }
            if (!currentLanguage.equals(Translator.SUPPORTED_LOCALES[i].getLanguage())) continue;
            this.localeComboBox.setSelectedIndex(i);
            break;
        }
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 8, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        mainPanel.add((Component)this.localeComboBox, c);
        Boolean hideAccountPassword = new Boolean(Preferences.get("account.hidePassword", "true"));
        this.hideAccountPasswordCheckbox = new JCheckBox(Translator.translate("hideAccountPassword"), (boolean)hideAccountPassword);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)this.hideAccountPasswordCheckbox, c);
        Boolean databaseAutoLock = new Boolean(Preferences.get("database.auto_lock", "false"));
        this.databaseAutoLockCheckbox = new JCheckBox(Translator.translate("databaseAutoLock"), (boolean)databaseAutoLock);
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)this.databaseAutoLockCheckbox, c);
        this.databaseAutoLockCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionsDialog.this.databaseAutoLockTime.setEnabled(e.getStateChange() == 1);
            }
        });
        this.databaseAutoLockTime = new JTextField(Preferences.get("database.auto_lock_time"), 5);
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        mainPanel.add((Component)this.databaseAutoLockTime, c);
        this.databaseAutoLockTime.setEnabled(this.databaseAutoLockCheckbox.isSelected());
        this.accountPasswordLengthLabel = new JLabel(Translator.translate("generatedPasswodLength"));
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)this.accountPasswordLengthLabel, c);
        this.accountPasswordLength = new JTextField(Preferences.get("account.passwordLenght", "8"), 5);
        c.gridx = 1;
        c.gridy = 6;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        mainPanel.add((Component)this.accountPasswordLength, c);
        Boolean inclEscCharstoPass = new Boolean(Preferences.get("account.inclescapechars", "true"));
        this.inclEscCharstoPassCheckbox = new JCheckBox(Translator.translate("includePunctuationCharacters"), (boolean)inclEscCharstoPass);
        c.gridx = 0;
        c.gridy = 7;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)this.inclEscCharstoPassCheckbox, c);
        Boolean storeWindowPos = Boolean.valueOf(Preferences.get("window.store_position", "false"));
        this.storeWindowPosCheckbox = new JCheckBox(Translator.translate("storeWindowPosition"), (boolean)storeWindowPos);
        c.gridx = 0;
        c.gridy = 8;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)this.storeWindowPosCheckbox, c);
        Boolean appAlwaysonTop = new Boolean(Preferences.get("mainwindow.alwaysontop", "false"));
        this.appAlwaysonTopCheckbox = new JCheckBox(Translator.translate("applicationAlwaysonTop"), (boolean)appAlwaysonTop);
        c.gridx = 0;
        c.gridy = 9;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)this.appAlwaysonTopCheckbox, c);
        emptyBorderPanel.add(Box.createVerticalGlue());
        TitledBorder httpsEtchedTitleBorder = BorderFactory.createTitledBorder(etchedBorder, " HTTPS ");
        JPanel httpsPanel = new JPanel(new GridBagLayout());
        httpsPanel.setBorder(httpsEtchedTitleBorder);
        emptyBorderPanel.add(httpsPanel);
        Boolean acceptSelfSignedCerts = new Boolean(Preferences.get("https.accept.selfsigned.certs", "false"));
        this.acceptSelfSignedCertsCheckbox = new JCheckBox(Translator.translate("acceptSelfSignedCerts"), (boolean)acceptSelfSignedCerts);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        httpsPanel.add((Component)this.acceptSelfSignedCertsCheckbox, c);
        TitledBorder proxyEtchedTitleBorder = BorderFactory.createTitledBorder(etchedBorder, ' ' + Translator.translate("httpProxy") + ' ');
        JPanel proxyPanel = new JPanel(new GridBagLayout());
        proxyPanel.setBorder(proxyEtchedTitleBorder);
        emptyBorderPanel.add(proxyPanel);
        Boolean proxyEnabled = new Boolean(Preferences.get("http.proxy.enabled"));
        this.enableProxyCheckbox = new JCheckBox(Translator.translate("enableProxy"), (boolean)proxyEnabled);
        this.enableProxyCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OptionsDialog.this.enableProxyComponents(true);
                } else {
                    OptionsDialog.this.enableProxyComponents(false);
                }
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 2, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        proxyPanel.add((Component)this.enableProxyCheckbox, c);
        this.proxyLabel = new JLabel(Translator.translate("httpProxy"));
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 3, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        proxyPanel.add((Component)this.proxyLabel, c);
        this.proxyPortLabel = new JLabel(Translator.translate("port"));
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 3, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        proxyPanel.add((Component)this.proxyPortLabel, c);
        this.httpProxyHost = new JTextField(Preferences.get("http.proxy.host"), 20);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        proxyPanel.add((Component)this.httpProxyHost, c);
        this.httpProxyPort = new JTextField(Preferences.get("http.proxy.port"), 6);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        proxyPanel.add((Component)this.httpProxyPort, c);
        this.proxyUsernameLabel = new JLabel(Translator.translate("httpProxyUsername"));
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 3, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        proxyPanel.add((Component)this.proxyUsernameLabel, c);
        this.httpProxyUsername = new JTextField(Preferences.get("http.proxy.username"), 20);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        proxyPanel.add((Component)this.httpProxyUsername, c);
        this.proxyPasswordLabel = new JLabel(Translator.translate("httpProxyPassword"));
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 3, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        proxyPanel.add((Component)this.proxyPasswordLabel, c);
        String encodedPassword = Preferences.get("http.proxy.password");
        String decodedPassword = null;
        if (encodedPassword != null) {
            decodedPassword = new String(Base64.decodeBase64(encodedPassword.getBytes()));
        }
        this.httpProxyPassword = new JPasswordField(decodedPassword, 20);
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        proxyPanel.add((Component)this.httpProxyPassword, c);
        this.hidePasswordCheckbox = new JCheckBox(Translator.translate("hide"), true);
        this.defaultEchoChar = this.httpProxyPassword.getEchoChar();
        this.hidePasswordCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OptionsDialog.this.httpProxyPassword.setEchoChar(OptionsDialog.this.defaultEchoChar);
                } else {
                    OptionsDialog.this.httpProxyPassword.setEchoChar('\u0000');
                }
            }
        });
        c.gridx = 1;
        c.gridy = 6;
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        proxyPanel.add((Component)this.hidePasswordCheckbox, c);
        emptyBorderPanel.add(Box.createVerticalGlue());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        emptyBorderPanel.add(buttonPanel);
        JButton okButton = new JButton(Translator.translate("ok"));
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.okButtonAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Translator.translate("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.setVisible(false);
                OptionsDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        this.enableProxyComponents(proxyEnabled);
    }

    private void enableProxyComponents(boolean enable) {
        this.httpProxyHost.setEnabled(enable);
        this.httpProxyPort.setEnabled(enable);
        this.httpProxyUsername.setEnabled(enable);
        this.httpProxyPassword.setEnabled(enable);
        this.proxyLabel.setEnabled(enable);
        this.proxyPortLabel.setEnabled(enable);
        this.proxyUsernameLabel.setEnabled(enable);
        this.proxyPasswordLabel.setEnabled(enable);
        this.hidePasswordCheckbox.setEnabled(enable);
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void okButtonAction() {
        try {
            if (this.databaseAutoLockCheckbox.isSelected() && (this.databaseAutoLockTime.getText() == null || this.databaseAutoLockTime.getText().trim().equals("") || !Util.isNumeric(this.databaseAutoLockTime.getText()))) {
                JOptionPane.showMessageDialog(this, Translator.translate("invalidValueForDatabaseAutoLockTime"), Translator.translate("problem"), 0);
                this.databaseAutoLockTime.requestFocusInWindow();
                return;
            }
            if (this.accountPasswordLength.getText() == null || this.accountPasswordLength.getText().trim().equals("") || !Util.isNumeric(this.accountPasswordLength.getText())) {
                JOptionPane.showMessageDialog(this, Translator.translate("invalidValueForAccountPasswordLength"), Translator.translate("problem"), 0);
                this.databaseAutoLockTime.requestFocusInWindow();
                return;
            }
            Preferences.set("DBToLoadOnStartup", this.dbToLoadOnStartup.getText());
            Preferences.set("account.hidePassword", String.valueOf(this.hideAccountPasswordCheckbox.isSelected()));
            Preferences.set("account.inclescapechars", String.valueOf(this.inclEscCharstoPassCheckbox.isSelected()));
            Preferences.set("window.store_position", String.valueOf(this.storeWindowPosCheckbox.isSelected()));
            Preferences.set("mainwindow.alwaysontop", String.valueOf(this.appAlwaysonTopCheckbox.isSelected()));
            Preferences.set("database.auto_lock", String.valueOf(this.databaseAutoLockCheckbox.isSelected()));
            Preferences.set("database.auto_lock_time", this.databaseAutoLockTime.getText());
            Preferences.set("account.passwordLenght", this.accountPasswordLength.getText());
            Preferences.set("https.accept.selfsigned.certs", String.valueOf(this.acceptSelfSignedCertsCheckbox.isSelected()));
            Preferences.set("http.proxy.host", this.httpProxyHost.getText());
            Preferences.set("http.proxy.port", this.httpProxyPort.getText());
            Preferences.set("http.proxy.username", this.httpProxyUsername.getText());
            String encodedPassword = new String(Base64.encodeBase64(new String(this.httpProxyPassword.getPassword()).getBytes()));
            Preferences.set("http.proxy.password", encodedPassword);
            Preferences.set("http.proxy.enabled", String.valueOf(this.enableProxyCheckbox.isSelected()));
            MainWindow.setAppAlwaysonTop(this.appAlwaysonTopCheckbox.isSelected());
            String beforeLocale = Preferences.get("locale");
            Locale selectedLocale = Translator.SUPPORTED_LOCALES[this.localeComboBox.getSelectedIndex()];
            String afterLocale = selectedLocale.getLanguage();
            if (!afterLocale.equals(beforeLocale)) {
                Preferences.set("locale", selectedLocale.getLanguage());
                Translator.loadBundle(selectedLocale);
                this.languageChanged = true;
            }
            Preferences.save();
            this.setVisible(false);
            this.dispose();
            this.okClicked = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parentFrame, e.getStackTrace(), Translator.translate("error"), 0);
        }
    }

    private void getDBToLoadOnStartup() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Translator.translate("dbToOpenOnStartup"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File databaseFile = fc.getSelectedFile();
            this.dbToLoadOnStartup.setText(databaseFile.getAbsoluteFile().toString());
        }
    }

    private Object[] getSupportedLocaleNames() {
        Object[] names = new Object[Translator.SUPPORTED_LOCALES.length];
        for (int i = 0; i < Translator.SUPPORTED_LOCALES.length; ++i) {
            names[i] = Translator.SUPPORTED_LOCALES[i].getDisplayLanguage(Translator.getCurrentLocale()) + " (" + Translator.SUPPORTED_LOCALES[i].getDisplayLanguage(Translator.SUPPORTED_LOCALES[i]) + ')';
        }
        return names;
    }

    public boolean hasLanguageChanged() {
        return this.languageChanged;
    }
}

