/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DynamicTreeNode
extends DefaultMutableTreeNode
implements ShuttleSortCompare {
    HDatabase database;
    boolean loaded = false;
    boolean loading = false;
    Vector allRows = new Vector(10, 0);

    public DynamicTreeNode(Object object, HDatabase hDatabase) {
        super(object);
        this.database = hDatabase;
    }

    public void add(MutableTreeNode mutableTreeNode) throws IllegalArgumentException, IllegalStateException {
        super.add(mutableTreeNode);
        HDataNode hDataNode = (HDataNode)((DynamicTreeNode)mutableTreeNode).getUserObject();
        HDataNode hDataNode2 = (HDataNode)this.getUserObject();
        hDataNode.primaryPointer = hDataNode2.childPointer;
        hDataNode.parentPointer = hDataNode2.myPointer;
    }

    public Enumeration children() {
        if (!this.loaded && !this.loading) {
            this.load();
        }
        return super.children();
    }

    public int compare(int n, int n2) {
        HDataNode hDataNode = (HDataNode)((DynamicTreeNode)this.allRows.elementAt(n)).getUserObject();
        HDataNode hDataNode2 = (HDataNode)((DynamicTreeNode)this.allRows.elementAt(n2)).getUserObject();
        int n3 = 0;
        int n4 = 0;
        switch (hDataNode.type) {
            case 99: {
                n3 = 1;
                break;
            }
            case 118: {
                n3 = 2;
                break;
            }
            case 100: {
                n3 = 3;
                break;
            }
            case 122: {
                n3 = 4;
                break;
            }
            case 102: {
                n3 = 5;
                break;
            }
        }
        switch (hDataNode2.type) {
            case 99: {
                n4 = 1;
                break;
            }
            case 118: {
                n4 = 2;
                break;
            }
            case 100: {
                n4 = 3;
                break;
            }
            case 122: {
                n4 = 4;
                break;
            }
            case 102: {
                n4 = 5;
                break;
            }
        }
        if (n3 > n4) {
            return 1;
        }
        if (n3 < n4) {
            return -1;
        }
        int n5 = hDataNode.toString().compareTo(hDataNode2.toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DynamicTreeNode)) {
            return false;
        }
        return this.getUserObject().equals(((DefaultMutableTreeNode)object).getUserObject());
    }

    protected void finalize() throws Throwable {
        this.database = null;
        super.finalize();
    }

    public TreeNode getChildAt(int n) {
        if (!this.loaded && !this.loading) {
            this.load();
        }
        return super.getChildAt(n);
    }

    public int getChildCount() {
        if (!this.loaded && !this.loading) {
            this.load();
        }
        return super.getChildCount();
    }

    protected void load() {
        this.loading = true;
        HDataNode hDataNode = (HDataNode)this.getUserObject();
        try {
            int n = this.database.childCount(hDataNode);
            this.allRows.removeAllElements();
            int n2 = 0;
            while (n2 < n) {
                HDataNode hDataNode2 = this.database.read(hDataNode, n2);
                if (hDataNode2.type == 100 || hDataNode2.type == 118 || hDataNode2.type == 99 || hDataNode2.type == 122) {
                    this.allRows.addElement(new DynamicTreeNode((Object)hDataNode2, this.database));
                }
                ++n2;
            }
            this.sort();
            this.loaded = true;
        }
        catch (IOException iOException) {}
        this.loading = false;
    }

    protected void sort() {
        int n = this.allRows.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        ShuttleSort.sort((int[])nArray.clone(), nArray, 0, nArray.length, this);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.add((MutableTreeNode)this.allRows.elementAt(nArray[n3]));
            ++n3;
        }
        this.allRows.removeAllElements();
    }

    public void sortChildren() {
        int n = this.getChildCount();
        this.allRows.removeAllElements();
        this.allRows.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            this.allRows.addElement(this.getChildAt(n2));
            ++n2;
        }
        this.removeAllChildren();
        this.sort();
    }
}

