/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class HDataPage {
    int primaryPointer = -1;
    int parentPointer = -1;
    int prevBrother = -1;
    int nextBrother = -1;
    short used = (short)-1;
    short startAt = (short)-1;
    short amount = (short)-1;
    public static final short headerSize = 22;
    int myPointer = -1;
    long timestamp = System.currentTimeMillis();
    boolean needUpdateOnDisk = false;
    Vector nodes = new Vector(10, 0);
    HDataNode rootNode = null;
    byte[] blobData = null;

    public HDataPage(HDataNode hDataNode) {
        this.rootNode = hDataNode;
    }

    public boolean addNode(HDataNode hDataNode) {
        HDataNode hDataNode2 = this.rootNode;
        synchronized (hDataNode2) {
            short s = (short)(hDataNode.size() + this.used);
            if (s <= 1024) {
                this.used = s;
                this.amount = (short)(this.amount + 1);
                hDataNode.index = this.nodes.size();
                hDataNode.primaryPointer = this.primaryPointer;
                hDataNode.myPointer = this.myPointer;
                hDataNode.parentPointer = this.parentPointer;
                this.nodes.addElement(hDataNode);
                this.timestamp = System.currentTimeMillis();
                this.needUpdateOnDisk = true;
                boolean bl = true;
                Object var4_6 = null;
                return bl;
            }
            boolean bl = false;
            Object var4_7 = null;
            return bl;
        }
    }

    public boolean checkFreePage(RandomAccessFile randomAccessFile, int n) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.myPointer = n;
            randomAccessFile.seek(n * 1024);
            this.readHeader(randomAccessFile);
            if (this.primaryPointer == -2) {
                boolean bl = true;
                Object var5_6 = null;
                return bl;
            }
            boolean bl = false;
            Object var5_7 = null;
            return bl;
        }
    }

    protected void finalize() throws Throwable {
        this.nodes = null;
        this.rootNode = null;
        this.blobData = null;
        super.finalize();
    }

    public int getIndexOf(HDataNode hDataNode) {
        this.timestamp = System.currentTimeMillis();
        return this.nodes.indexOf(hDataNode);
    }

    public HDataNode getNode(int n) {
        this.timestamp = System.currentTimeMillis();
        return (HDataNode)this.nodes.elementAt(n);
    }

    public int getNodeSize() {
        this.timestamp = System.currentTimeMillis();
        return this.nodes.size();
    }

    protected boolean readHeader(RandomAccessFile randomAccessFile) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.primaryPointer = randomAccessFile.readInt();
            this.parentPointer = randomAccessFile.readInt();
            this.prevBrother = randomAccessFile.readInt();
            this.nextBrother = randomAccessFile.readInt();
            this.used = randomAccessFile.readShort();
            this.startAt = randomAccessFile.readShort();
            this.amount = randomAccessFile.readShort();
        }
        return true;
    }

    protected boolean readNodes(RandomAccessFile randomAccessFile) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.nodes.ensureCapacity(this.amount);
            int n = 0;
            while (n < this.amount) {
                HDataNode hDataNode2 = new HDataNode();
                hDataNode2.readFrom(randomAccessFile);
                hDataNode2.primaryPointer = this.primaryPointer;
                hDataNode2.myPointer = this.myPointer;
                hDataNode2.index = n;
                hDataNode2.parentPointer = this.parentPointer;
                this.nodes.addElement(hDataNode2);
                ++n;
            }
        }
        return true;
    }

    public boolean readPage(RandomAccessFile randomAccessFile, int n) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.timestamp = System.currentTimeMillis();
            this.myPointer = n;
            randomAccessFile.seek(n * 1024);
            this.readHeader(randomAccessFile);
            if (this.primaryPointer == -2) {
                boolean bl = true;
                Object var5_5 = null;
                return bl;
            }
            if (this.amount == -1) {
                this.blobData = new byte[this.used - 22];
                randomAccessFile.read(this.blobData);
            } else {
                this.readNodes(randomAccessFile);
            }
        }
        return true;
    }

    public boolean removeNode(int n) {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            this.timestamp = System.currentTimeMillis();
            this.needUpdateOnDisk = true;
            HDataNode hDataNode2 = (HDataNode)this.nodes.elementAt(n);
            if (hDataNode2 != null) {
                this.nodes.removeElementAt(n);
                this.used = (short)(this.used - hDataNode2.size());
                this.amount = (short)(this.amount - 1);
            }
        }
        return true;
    }

    public boolean setBlobData(byte[] byArray, int n, int n2) {
        if (n2 > 1002) {
            return false;
        }
        this.needUpdateOnDisk = true;
        this.blobData = new byte[n2];
        this.used = (short)(22 + n2);
        this.startAt = 0;
        this.amount = (short)-1;
        System.arraycopy(byArray, n, this.blobData, 0, n2);
        return true;
    }

    public void setNextBrother(int n) {
        this.needUpdateOnDisk = true;
        this.nextBrother = n;
    }

    public boolean setNode(HDataNode hDataNode, int n) {
        HDataNode hDataNode2 = this.rootNode;
        synchronized (hDataNode2) {
            HDataNode hDataNode3 = (HDataNode)this.nodes.elementAt(n);
            short s = (short)(this.used - hDataNode3.size() + hDataNode.size());
            if (s <= 1024) {
                this.used = s;
                hDataNode.primaryPointer = this.primaryPointer;
                hDataNode.myPointer = this.myPointer;
                hDataNode.index = n;
                hDataNode.parentPointer = this.parentPointer;
                this.nodes.setElementAt(hDataNode, n);
                this.timestamp = System.currentTimeMillis();
                this.needUpdateOnDisk = true;
                boolean bl = true;
                Object var5_8 = null;
                return bl;
            }
            boolean bl = false;
            Object var5_9 = null;
            return bl;
        }
    }

    public void setParentPointer(int n) {
        this.needUpdateOnDisk = true;
        this.parentPointer = n;
    }

    public void setPrevBrother(int n) {
        this.needUpdateOnDisk = true;
        this.prevBrother = n;
    }

    public void setStartAt(short s) {
        this.needUpdateOnDisk = true;
        this.startAt = s;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.primaryPointer)) + " " + String.valueOf(this.parentPointer) + " " + String.valueOf(this.prevBrother) + " " + String.valueOf(this.nextBrother) + " " + String.valueOf(this.used) + " " + String.valueOf(this.startAt) + " " + String.valueOf(this.amount) + " " + String.valueOf(this.myPointer) + " " + String.valueOf(this.timestamp) + " " + String.valueOf(this.needUpdateOnDisk) + " NODES: " + this.nodes;
    }

    protected boolean writeHeader(RandomAccessFile randomAccessFile) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            randomAccessFile.writeInt(this.primaryPointer);
            randomAccessFile.writeInt(this.parentPointer);
            randomAccessFile.writeInt(this.prevBrother);
            randomAccessFile.writeInt(this.nextBrother);
            randomAccessFile.writeShort(this.used);
            randomAccessFile.writeShort(this.startAt);
            randomAccessFile.writeShort(this.amount);
        }
        return true;
    }

    protected boolean writeNodes(RandomAccessFile randomAccessFile) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            int n = 0;
            while (n < this.nodes.size()) {
                HDataNode hDataNode2 = (HDataNode)this.nodes.elementAt(n);
                hDataNode2.writeTo(randomAccessFile);
                ++n;
            }
            if (1024 - this.used > 0) {
                HDatabase.writeBlanks(randomAccessFile, 1024 - this.used);
            }
        }
        return true;
    }

    public boolean writePage(RandomAccessFile randomAccessFile) throws IOException {
        HDataNode hDataNode = this.rootNode;
        synchronized (hDataNode) {
            try {
                randomAccessFile.seek(this.myPointer * 1024);
            }
            catch (IOException iOException) {
                randomAccessFile.seek(randomAccessFile.length());
                HDatabase.writeBlanks(randomAccessFile, (int)((long)this.myPointer * 1024L - randomAccessFile.length()));
            }
            this.writeHeader(randomAccessFile);
            if (this.amount == -1) {
                randomAccessFile.write(this.blobData);
            } else {
                this.writeNodes(randomAccessFile);
            }
            this.needUpdateOnDisk = false;
        }
        return true;
    }
}

