/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HDataTableModel
extends AbstractTableModel {
    protected Vector nodes = new Vector(10, 0);
    String[] columnNames = new String[]{"Icon", "Filename", "Path", "Size", "Date Modified"};
    int type = 0;
    public static final int NO_PATH = 0;
    public static final int PATH = 1;
    TreePath pathToTable = null;
    JTree assocTree;
    HDatabase database;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public HDataTableModel(int n, JTree jTree, HDatabase hDatabase) {
        this.type = n;
        this.assocTree = jTree;
        this.database = hDatabase;
    }

    public void addNode(HDataNode hDataNode) {
        this.nodes.addElement(hDataNode);
        this.fireTableRowsInserted(this.nodes.size() - 1, this.nodes.size() - 1);
    }

    public void addNodes(Vector vector) {
        this.nodes.ensureCapacity(this.nodes.size() + vector.size());
        int n = this.nodes.size() - 1;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            this.nodes.addElement(vector.elementAt(n3));
            ++n3;
        }
        this.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearTable() {
        this.nodes.removeAllElements();
        this.fireTableDataChanged();
    }

    protected void finalize() throws Throwable {
        this.nodes.removeAllElements();
        this.nodes = null;
        this.assocTree = null;
        this.database = null;
        this.pathToTable = null;
        super.finalize();
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    public DynamicTreeNode getAssocTreeNode(int n) {
        HDataNode hDataNode = (HDataNode)this.nodes.elementAt(n);
        return this.getAssocTreeNode(hDataNode);
    }

    public DynamicTreeNode getAssocTreeNode(HDataNode hDataNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.assocTree.getModel();
        if (hDataNode.fileName == "..") {
            return (DynamicTreeNode)this.pathToTable.getPathComponent(this.pathToTable.getPathCount() - 2);
        }
        DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)this.pathToTable.getLastPathComponent();
        int n = defaultTreeModel.getChildCount(dynamicTreeNode);
        int n2 = 0;
        while (n2 < n) {
            DynamicTreeNode dynamicTreeNode2 = (DynamicTreeNode)defaultTreeModel.getChild(dynamicTreeNode, n2);
            HDataNode hDataNode2 = (HDataNode)dynamicTreeNode2.getUserObject();
            if (hDataNode2.equals(hDataNode)) {
                return dynamicTreeNode2;
            }
            ++n2;
        }
        return null;
    }

    public TreePath getAssocTreePath(int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.assocTree.getModel();
        DynamicTreeNode dynamicTreeNode = this.getAssocTreeNode(n);
        if (dynamicTreeNode == null) {
            return null;
        }
        return new TreePath(defaultTreeModel.getPathToRoot(dynamicTreeNode));
    }

    public Class getColumnClass(int n) {
        if (this.type == 0 && n >= 2) {
            ++n;
        }
        switch (n) {
            case 0: {
                return class$javax$swing$ImageIcon != null ? class$javax$swing$ImageIcon : (class$javax$swing$ImageIcon = HDataTableModel.class$("javax.swing.ImageIcon"));
            }
            case 1: {
                return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = HDataTableModel.class$("java.lang.String"));
            }
            case 2: {
                return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = HDataTableModel.class$("java.lang.String"));
            }
            case 3: {
                return class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = HDataTableModel.class$("java.lang.Number"));
            }
            case 4: {
                return class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = HDataTableModel.class$("java.util.Date"));
            }
        }
        return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = HDataTableModel.class$("java.lang.Object"));
    }

    public int getColumnCount() {
        if (this.type == 0) {
            return 4;
        }
        return 5;
    }

    public String getColumnName(int n) {
        if (this.type == 0 && n >= 2) {
            ++n;
        }
        return this.columnNames[n].toString();
    }

    public HDataNode getNode(int n) {
        return (HDataNode)this.nodes.elementAt(n);
    }

    public HDataNode[] getNodes(int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        HDataNode[] hDataNodeArray = nArray[0] == 0 && this.nodes.elementAt(0).toString() == ".." ? new HDataNode[nArray.length - 1] : new HDataNode[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            HDataNode hDataNode = (HDataNode)this.nodes.elementAt(nArray[n2]);
            if (hDataNode.toString() != "..") {
                hDataNodeArray[n++] = hDataNode;
            }
            ++n2;
        }
        return hDataNodeArray;
    }

    public TreePath getPathToTable() {
        return this.pathToTable;
    }

    public int getRowCount() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public Object getValueAt(int n, int n2) {
        if (this.type == 0 && n2 >= 2) {
            ++n2;
        }
        switch (n2) {
            case 0: {
                if (((HDataNode)this.nodes.elementAt((int)n)).type == 102) {
                    return UIManager.getIcon("Tree.leafIcon");
                }
                HDataNode hDataNode = (HDataNode)this.nodes.elementAt(n);
                return FileManagerPanel.getAssocIcon(hDataNode.type);
            }
            case 1: {
                return ((HDataNode)this.nodes.elementAt(n)).toString();
            }
            case 2: {
                return ((HDataNode)this.nodes.elementAt((int)n)).path;
            }
            case 3: {
                return new Long(((HDataNode)this.nodes.elementAt((int)n)).length);
            }
            case 4: {
                return new Date(((HDataNode)this.nodes.elementAt((int)n)).dateModified);
            }
        }
        return null;
    }

    public void loadTable(DynamicTreeNode dynamicTreeNode) throws IOException {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.assocTree.getModel();
        this.pathToTable = new TreePath(defaultTreeModel.getPathToRoot(dynamicTreeNode));
        this.updateListTable(dynamicTreeNode);
    }

    public void removeNode(HDataNode hDataNode) {
        int n = this.nodes.indexOf(hDataNode);
        if (n != -1) {
            this.nodes.removeElementAt(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void setNode(int n, HDataNode hDataNode) {
        this.nodes.setElementAt(hDataNode, n);
        this.fireTableRowsUpdated(n, n);
    }

    public void setValueAt(HDataNode hDataNode, int n) {
        this.nodes.setElementAt(hDataNode, n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void updateListTable(DynamicTreeNode dynamicTreeNode) throws IOException {
        HDataNode hDataNode;
        HDataNode hDataNode2 = (HDataNode)dynamicTreeNode.getUserObject();
        long l = 0L;
        int n = this.database.childCount(hDataNode2);
        this.nodes.removeAllElements();
        this.nodes.ensureCapacity(n + 1);
        if (hDataNode2.myPointer != 0) {
            HDataNode hDataNode3 = (HDataNode)((DynamicTreeNode)dynamicTreeNode.getParent()).getUserObject();
            hDataNode = (HDataNode)hDataNode3.clone();
            hDataNode.length = 0L;
            hDataNode.fileName = "..";
            hDataNode.desc = "..";
            this.nodes.addElement(hDataNode);
        }
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            hDataNode = this.database.read(hDataNode2, n2);
            this.nodes.addElement(hDataNode);
            l += hDataNode.length;
            ++n2;
        }
        this.fireTableDataChanged();
    }
}

