/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.io.*;

public class ID3Tag implements Cloneable
{
   public String title = null, artist = null, album = null, year = null, comment = null;
   public int genre = 255;
   public static final int tagsize = 128;

public ID3Tag()
{
}

public ID3Tag(String mp3Filename) throws IOException
{
   read(mp3Filename);
}

public ID3Tag(RandomAccessFile someFile) throws IOException
{
   read(someFile);
}

public Object clone()
{
   try
   {
      ID3Tag aClone = (ID3Tag) super.clone();

      aClone.title = title;
      aClone.artist = artist;
      aClone.album = album;
      aClone.year = year;
      aClone.comment = comment;
      aClone.genre = genre;

      return aClone;
   }
   catch(CloneNotSupportedException e)
   {
      return null;
   }
}


public boolean read(String mp3Filename) throws IOException
{
   RandomAccessFile mp3file = new RandomAccessFile(mp3Filename,"r");
   try
   {
      if(mp3file.length() < 128)
         return false;

      mp3file.seek(mp3file.length()-tagsize);
      return read(mp3file);
   }
   finally
   {
      mp3file.close();
   }
}

public boolean read(RandomAccessFile someFile) throws IOException
{
   byte[] tag = new byte[3];
   byte[] title = new byte[30];
   byte[] artist = new byte[30];
   byte[] album = new byte[30];
   byte[] year = new byte[4];
   byte[] comment = new byte[30];
   someFile.read(tag);
   if(!new String(tag).equals("TAG"))
      return false;

   if(someFile.read(title) == -1) return false;
   if(someFile.read(artist) == -1) return false;
   if(someFile.read(album) == -1) return false;
   if(someFile.read(year) == -1) return false;
   if(someFile.read(comment) == -1) return false;

   this.title = new String(title).trim();
   this.artist = new String(artist).trim();
   this.album = new String(album).trim();
   this.year = new String(year).trim();
   this.comment = new String(comment).trim();

   genre = someFile.read();
   if(genre == -1) // hit EOF oops
      return false;

   return true;
}

public boolean write(String mp3Filename) throws IOException
{
   RandomAccessFile mp3file = new RandomAccessFile(mp3Filename,"w");
   try
   {
      mp3file.seek(mp3file.length()-1);
      return write(mp3file);
   }
   finally
   {
      mp3file.close();
   }
}

public boolean write(RandomAccessFile someFile) throws IOException
{
   if(title == null)
      return false;

   someFile.write("TAG".getBytes());
   writeFilled(someFile,title,30);
   writeFilled(someFile,artist,30);
   writeFilled(someFile,album,30);
   writeFilled(someFile,year,4);
   writeFilled(someFile,comment,30);
   someFile.write(genre);

   return true;
}

protected void writeFilled(RandomAccessFile someFile, String aString, int length) throws IOException
{
   byte[] bytes = aString.getBytes();
   if(bytes.length > length)
      someFile.write(bytes,0,length);
   else
   {
      someFile.write(bytes);
      byte[] blanks = new byte[length-bytes.length];
      for(int i = 0; i < blanks.length; i++)
         blanks[i] = 20; // spaces
      someFile.write(blanks);
   }
}

   public static final String[] GENRES = new String[]
   {
      "Blues",
      "Classic Rock",
      "Country",
      "Dance",
      "Disco",
      "Funk",
      "Grunge",
      "Hip-Hop",
      "Jazz",
      "Metal",
      "New Age",
      "Oldies",
      "Other",
      "Pop",
      "R&B",
      "Rap",
      "Reggae",
      "Rock",
      "Techno",
      "Industrial",
      "Alternative",
      "Ska",
      "Death Metal",
      "Pranks",
      "Soundtrack",
      "Euro-Techno",
      "Ambient",
      "Trip-Hop",
      "Vocal",
      "Jazz+Funk",
      "Fusion",
      "Trance",
      "Classical",
      "Instrumental",
      "Acid",
      "House",
      "Game",
      "Sound Clip",
      "Gospel",
      "Noise",
      "AlternRock",
      "Bass",
      "Soul",
      "Punk",
      "Space",
      "Meditative",
      "Instrumental Pop",
      "Instrumental Rock",
      "Ethnic",
      "Gothic",
      "Darkwave",
      "Techno-Industrial",
      "Electronic",
      "Pop-Folk",
      "Eurodance",
      "Dream",
      "Southern Rock",
      "Comedy",
      "Cult",
      "Gangsta",
      "Top 40",
      "Christian Rap",
      "Pop/Funk",
      "Jungle",
      "Native American",
      "Cabaret",
      "New Wave",
      "Psychadelic",
      "Rave",
      "Showtunes",
      "Trailer",
      "Lo-Fi",
      "Tribal",
      "Acid Punk",
      "Acid Jazz",
      "Polka",
      "Retro",
      "Musical",
      "Rock & Roll",
      "Hard Rock",
      "Folk",
      "Folk/Rock",
      "National Folk",
      "Swing",
      "Bebob",
      "Latin",
      "Revival",
      "Celtic",
      "Bluegrass",
      "Avantgarde",
      "Gothic Rock",
      "Progressive R",
      "Psychedelic R",
      "Symphonic Roc",
      "Slow Rock",
      "Big Band",
      "Chorus",
      "Easy Listenin",
      "Acoustic",
      "Humour",
      "Speech",
      "Chanson",
      "Opera",
      "Chamber Music",
      "Sonata",
      "Symphony",
      "Booty Bass",
      "Primus",
      "Porn Groove",
      "Satire",
      "Slow Jam",
      "Club",
      "Tango",
      "Samba",
      "Folklore",
      "Ballad",
      "Power Ballad",
      "Rhythmic Soul",
      "Freestyle",
      "Duet",
      "Punk Rock",
      "Drum Solo",
      "Acapella",
      "Euro-House",
      "Dance Hall",
      "Goa",
      "Drum & Bass",
      "Club House",
      "Hardcore",
      "Terror",
      "Indie",
      "BritPop",
      "NegerPunk",
      "Polsk Punk",
      "Beat",
      "Christian Gangsta",
      "Heavy Metal",
      "Black Metal",
      "Crossover",
      "Contemporary C",
      "Christian Rock",
      "Merengue",
      "Salsa",
      "Thrash Metal",
      "Anime",
      "JPop",
      "SynthPop",
      "Unknown"
   };

}
