/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class OptionsDialog extends JDialog implements ActionListener, ListSelectionListener
{
   JTabbedPane tabbedPane = new JTabbedPane();
   JButton ok = new JButton("Ok"), cancel = new JButton("Cancel");

   // Page one stuff
   JPanel dialog1Pane = new JPanel();
   JPanel buttonPane = new JPanel();
   DefaultListModel appListModel;
   JList appList;
   JScrollPane scrollList;
   JTextField exeField = new JTextField(),
              extField = new JTextField(),
              dirAssocField = new JTextField();
   JButton addApp = new JButton("Add"),
           changeApp = new JButton("Change"),
           delApp = new JButton("Delete"),
           browseExe = new JButton("Browse"),
           browse2Exe = new JButton("Browse");
   JFileChooser exeChooser = new JFileChooser();

   // Page two stuff
   JPanel dialog2Pane = new JPanel();
   DefaultListModel mountLeftListModel, mountRightListModel;
   JList mountLeftList, mountRightList;
   JScrollPane mountLeftScrollList, mountRightScrollList;
   JButton mlAdd = new JButton("Add"),
           mlChange = new JButton("Change"),
           mlDelete = new JButton("Delete");
   JButton mrAdd = new JButton("Add"),
           mrChange = new JButton("Change"),
           mrDelete = new JButton("Delete");
   JTextField mlField = new JTextField(), mrField = new JTextField();

   // Page three stuff
   JPanel dialog3Pane = new JPanel();
   JTextField tempDirField = new JTextField();
   JTextField bufferField = new JTextField();
   JCheckBox kludgeButton = new JCheckBox("Use kludge for IBM JDK's Runtime.exec()");

   JFrame mainFrame;
   Properties options;

public OptionsDialog(JFrame frame, Properties options, final int initialPage)
{
   super(frame,"Options", true);
   mainFrame = frame;
   this.options = options;

// === first page

   appListModel = new DefaultListModel();

   int i = 0;
   ExtAssoc anItem = new ExtAssoc(
      options.getProperty("association.extention." + i),
      options.getProperty("association.executable." + i));
   while(anItem.ext != null && anItem.exe != null)
   {
      appListModel.addElement(anItem);
      i++;
      anItem = new ExtAssoc(
         options.getProperty("association.extention." + i),
         options.getProperty("association.executable." + i));
   }

   appList = new JList(appListModel);
   appList.getSelectionModel().addListSelectionListener(this);
   scrollList = new JScrollPane(appList);
   scrollList.setPreferredSize(new Dimension(75,scrollList.getPreferredSize().height));

   if(!appListModel.isEmpty())
      appList.setSelectedIndex(0);

   // add, change and delete buttons
   JPanel button2Pane = new JPanel(new GridLayout(0,1,5,5));
   button2Pane.add(addApp);
   button2Pane.add(changeApp);
   button2Pane.add(delApp);
   button2Pane.setMaximumSize(changeApp.getPreferredSize());
   button2Pane.setAlignmentX(LEFT_ALIGNMENT);
   addApp.addActionListener(this);
   changeApp.addActionListener(this);
   delApp.addActionListener(this);
   addApp.setMnemonic(KeyEvent.VK_A);
   changeApp.setMnemonic(KeyEvent.VK_H);
   delApp.setMnemonic(KeyEvent.VK_D);

   JPanel col2Pane = new JPanel();
   col2Pane.setLayout(new BoxLayout(col2Pane, BoxLayout.Y_AXIS));

   col2Pane.add(button2Pane);
   col2Pane.add(Box.createRigidArea(new Dimension(0,10)));

   // exe and extention fields
   JLabel extLabel = new JLabel("Extension:");
   extLabel.setAlignmentX(LEFT_ALIGNMENT);
   col2Pane.add(extLabel);
   col2Pane.add(Box.createRigidArea(new Dimension(0,5)));
   extField.setAlignmentX(LEFT_ALIGNMENT);
   col2Pane.add(extField);
   col2Pane.add(Box.createRigidArea(new Dimension(0,10)));
   JLabel exeLabel = new JLabel("Executable:");
   exeLabel.setAlignmentX(LEFT_ALIGNMENT);
   col2Pane.add(exeLabel);
   col2Pane.add(Box.createRigidArea(new Dimension(0,5)));
   exeField.setAlignmentX(LEFT_ALIGNMENT);
   col2Pane.add(exeField);
   col2Pane.add(Box.createRigidArea(new Dimension(0,5)));
   browseExe.setAlignmentX(LEFT_ALIGNMENT);
   browseExe.setMnemonic(KeyEvent.VK_B);
   browseExe.addActionListener(this);
   col2Pane.add(browseExe);

   // putting listbox and the things above side by side
   JPanel exeAssocPane = new JPanel();
   exeAssocPane.setLayout(new BoxLayout(exeAssocPane, BoxLayout.X_AXIS));
   exeAssocPane.add(scrollList);
   exeAssocPane.add(Box.createRigidArea(new Dimension(5,0)));
   exeAssocPane.add(col2Pane);

   // directory association
   JLabel dirAssocLabel = new JLabel("Directory and Disk association:");
   dirAssocLabel.setAlignmentX(LEFT_ALIGNMENT);
   dirAssocField.setAlignmentX(LEFT_ALIGNMENT);
   JPanel dirAssocPane = new JPanel();
   dirAssocPane.setLayout(new BoxLayout(dirAssocPane, BoxLayout.Y_AXIS));
   dirAssocPane.add(dirAssocLabel);
   dirAssocPane.add(Box.createRigidArea(new Dimension(0,5)));
   dirAssocPane.add(dirAssocField);
   dirAssocPane.add(Box.createRigidArea(new Dimension(0,5)));
   browse2Exe.setActionCommand("Browse2");
   browse2Exe.setAlignmentX(LEFT_ALIGNMENT);
   browse2Exe.setMnemonic(KeyEvent.VK_R);
   browse2Exe.addActionListener(this);
   dirAssocPane.add(browse2Exe);

   String anExe = options.getProperty("assocation.directory.executable");
   if(anExe != null)
      dirAssocField.setText(anExe);

   // creating first page
   dialog1Pane.setLayout(new BorderLayout(10,10));
   dialog1Pane.add(exeAssocPane,"Center");
   dialog1Pane.add(dirAssocPane,"South");
   dialog1Pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
   tabbedPane.addTab("Associations", dialog1Pane);

// === second page

   // add, change and delete buttons
   JPanel mlButtonPane = new JPanel(new GridLayout(0,1,5,5));
   mlButtonPane.add(mlAdd);
   mlButtonPane.add(mlChange);
   mlButtonPane.add(mlDelete);
   mlButtonPane.add(mlField);
   mlField.setAlignmentX(LEFT_ALIGNMENT);
   mlButtonPane.setMaximumSize(new Dimension(mlChange.getPreferredSize().width,mlButtonPane.getPreferredSize().height));
   mlButtonPane.setAlignmentX(LEFT_ALIGNMENT);
   mlButtonPane.setAlignmentY(TOP_ALIGNMENT);
   mlAdd.setMnemonic(KeyEvent.VK_A); mlAdd.setActionCommand("mlAdd"); mlAdd.addActionListener(this);
   mlChange.setMnemonic(KeyEvent.VK_H); mlChange.setActionCommand("mlChange"); mlChange.addActionListener(this);
   mlDelete.setMnemonic(KeyEvent.VK_D); mlDelete.setActionCommand("mlDelete"); mlDelete.addActionListener(this);

   mountLeftListModel = new DefaultListModel();

   i = 0;
   String aMountPoint = options.getProperty("mountpoint." + i);
   while(aMountPoint != null)
   {
      MountPoints anotherItem = new MountPoints(aMountPoint);
      mountLeftListModel.addElement(anotherItem);
      int j = 0;
      String aSysMountPoint = options.getProperty("mountpoint." + i + "." + j);
      while(aSysMountPoint != null)
      {
         anotherItem.sysMountPoints.addElement(aSysMountPoint);
         aSysMountPoint = options.getProperty("mountpoint." + i + "." + ++j);
      }
      aMountPoint = options.getProperty("mountpoint." + ++i);
   }

   mountLeftList = new JList(mountLeftListModel);
   mountLeftList.getSelectionModel().addListSelectionListener(this);
   mountLeftScrollList = new JScrollPane(mountLeftList);
   mountLeftScrollList.setPreferredSize(new Dimension(75,mountLeftScrollList.getPreferredSize().height));

   JPanel mountLeftPane = new JPanel();
   mountLeftPane.setLayout(new BoxLayout(mountLeftPane, BoxLayout.X_AXIS));
   mountLeftPane.add(Box.createRigidArea(new Dimension(5,0)));
   mountLeftPane.add(mountLeftScrollList);
   mountLeftPane.add(Box.createRigidArea(new Dimension(5,0)));
   mountLeftPane.add(mlButtonPane);
   mountLeftPane.add(Box.createRigidArea(new Dimension(5,0)));
   mountLeftPane.setBorder(BorderFactory.createTitledBorder("Associate ..."));

   // add, change and delete buttons
   JPanel mrButtonPane = new JPanel(new GridLayout(0,1,5,5));
   mrButtonPane.add(mrAdd);
   mrButtonPane.add(mrChange);
   mrButtonPane.add(mrDelete);
   mrButtonPane.add(mrField);
   mrField.setAlignmentX(LEFT_ALIGNMENT);
   mrButtonPane.setMaximumSize(new Dimension(mrChange.getPreferredSize().width,mrButtonPane.getPreferredSize().height));
   mrButtonPane.setAlignmentX(LEFT_ALIGNMENT);
   mrButtonPane.setAlignmentY(TOP_ALIGNMENT);
   mrAdd.setMnemonic(KeyEvent.VK_A); mrAdd.setActionCommand("mrAdd"); mrAdd.addActionListener(this);
   mrChange.setMnemonic(KeyEvent.VK_H); mrChange.setActionCommand("mrChange"); mrChange.addActionListener(this);
   mrDelete.setMnemonic(KeyEvent.VK_D); mrDelete.setActionCommand("mrDelete"); mrDelete.addActionListener(this);

   mountRightListModel = new DefaultListModel();
   mountRightList = new JList(mountRightListModel);
   mountRightList.getSelectionModel().addListSelectionListener(this);
   mountRightScrollList = new JScrollPane(mountRightList);
   mountRightScrollList.setPreferredSize(new Dimension(75,mountRightScrollList.getPreferredSize().height));


   JPanel mountRightPane = new JPanel();
   mountRightPane.setLayout(new BoxLayout(mountRightPane, BoxLayout.X_AXIS));
   mountRightPane.add(Box.createRigidArea(new Dimension(5,0)));
   mountRightPane.add(mountRightScrollList);
   mountRightPane.add(Box.createRigidArea(new Dimension(5,0)));
   mountRightPane.add(mrButtonPane);
   mountRightPane.add(Box.createRigidArea(new Dimension(5,0)));
   mountRightPane.setBorder(BorderFactory.createTitledBorder("System Mount Point"));

   // creating second page
   dialog2Pane.setLayout(new BoxLayout(dialog2Pane, BoxLayout.X_AXIS));
   dialog2Pane.add(mountLeftPane);
   dialog2Pane.add(Box.createRigidArea(new Dimension(5,0)));
   dialog2Pane.add(mountRightPane);
   dialog2Pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
   tabbedPane.addTab("Mount Points", dialog2Pane);

   if(!mountLeftListModel.isEmpty())
      mountLeftList.setSelectedIndex(0);

// == third page

   JLabel tempDirLabel = new JLabel("Temporary Directory:");
   tempDirLabel.setAlignmentX(LEFT_ALIGNMENT);
   tempDirField.setAlignmentX(LEFT_ALIGNMENT);
   tempDirField.setText(options.getProperty("temporaryDirectory"));
   tempDirField.setPreferredSize(new Dimension(200,tempDirField.getPreferredSize().height));
   Box tempDirBox = Box.createHorizontalBox();
   tempDirBox.add(tempDirLabel);
   tempDirBox.add(tempDirField);

   JLabel bufferLabel = new JLabel("Memory Buffer Size (kB):");
   bufferLabel.setAlignmentX(LEFT_ALIGNMENT);
   bufferField.setAlignmentX(LEFT_ALIGNMENT);
   bufferField.setText(options.getProperty("memoryBufferSize"));
   bufferField.setPreferredSize(new Dimension(200,bufferField.getPreferredSize().height));
   Box bufferBox = Box.createHorizontalBox();
   bufferBox.add(bufferLabel);
   bufferBox.add(bufferField);

   kludgeButton.setAlignmentX(LEFT_ALIGNMENT);
   kludgeButton.setMnemonic(KeyEvent.VK_K);
   kludgeButton.setSelected(Boolean.valueOf(options.getProperty("ibmjdkkludge")).booleanValue());
   Box kludgeBox = Box.createHorizontalBox();
   kludgeBox.add(kludgeButton);
   kludgeBox.add(Box.createGlue());

   Box field3Box = Box.createVerticalBox();
   field3Box.add(tempDirBox);
   field3Box.add(Box.createRigidArea(new Dimension(0,5)));
   field3Box.add(bufferBox);
   field3Box.add(Box.createRigidArea(new Dimension(0,5)));
   field3Box.add(kludgeBox);

   dialog3Pane.add(field3Box);
   tabbedPane.addTab("General", dialog3Pane);


// == all page stuff

   // creating OK/Cancel buttons
   buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
   buttonPane.add(ok);
   buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
   buttonPane.add(cancel);
   buttonPane.setAlignmentX(LEFT_ALIGNMENT);
   ok.addActionListener(this);
   cancel.addActionListener(this);
   ok.setMnemonic(KeyEvent.VK_O);
   cancel.setMnemonic(KeyEvent.VK_C);


   addWindowListener(new WindowAdapter()
   {
      public void windowClosing(WindowEvent e)
      {
         mainFrame.requestFocus();
      }

      boolean focusSet = false;
      public void windowActivated(WindowEvent e)
      {
         if(!focusSet)
         {
            switch(initialPage)
            {
               case 0: extField.requestFocus(); break;
               case 1: mlField.requestFocus(); break;
               case 2: tempDirField.requestFocus(); break;
            }
            focusSet = true;
         }
      }
   });

   Container dialogPane = this.getContentPane();
   dialogPane.setLayout(new BorderLayout(5,5));
   dialogPane.add(tabbedPane,"Center");
   dialogPane.add(buttonPane,"South");
//   dialogPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
   this.pack();

   tabbedPane.setSelectedIndex(initialPage);
   setLocationRelativeTo(frame);
}

MountPoints currentLeftSelection = null;

public void valueChanged(ListSelectionEvent e)
{
   if(e.getValueIsAdjusting())
      return;

   DefaultListSelectionModel selectionModel = (DefaultListSelectionModel) e.getSource();

   if(selectionModel == appList.getSelectionModel())
   {
      int index = appList.getSelectedIndex();
      if(index >= 0 && !appListModel.isEmpty())
      {
         ExtAssoc selected = (ExtAssoc) appListModel.get(index);

         extField.setText(selected.ext);
         exeField.setText(selected.exe);
      }
   }
   else if(selectionModel == mountLeftList.getSelectionModel())
   {
      int index = mountLeftList.getSelectedIndex();
      if(index >= 0 && !mountLeftListModel.isEmpty())
      {
         currentLeftSelection = (MountPoints) mountLeftListModel.get(index);
         mlField.setText(currentLeftSelection.toString());

         mountRightListModel.clear();
         mountRightListModel.ensureCapacity(currentLeftSelection.sysMountPoints.size());
         int i;
         for(i = 0; i < currentLeftSelection.sysMountPoints.size(); i++)
            mountRightListModel.addElement(currentLeftSelection.sysMountPoints.elementAt(i));
         if(i > 0)
         {
            mountRightList.setPrototypeCellValue(null);
            mountRightList.setSelectedIndex(0);
         }
      }
      else
      {
         mountRightListModel.clear();
         currentLeftSelection = null;
      }
   }
   else if(selectionModel == mountRightList.getSelectionModel())
   {
      int index = mountRightList.getSelectedIndex();
      if(index >= 0 && !mountRightListModel.isEmpty())
         mrField.setText(mountRightListModel.get(index).toString());
   }

}

public void actionPerformed(ActionEvent e)
{
   String command = e.getActionCommand();

// == all pages

   if(command == "Ok")
   {
      int i = 0;
      String anExt = options.getProperty("association.extention." + i);
      String anExe = options.getProperty("association.executable." + i);
      while(anExt != null || anExe != null)
      {
         options.remove("association.extention." + i);
         options.remove("association.executable." + i);
         i++;
         anExt = options.getProperty("association.extention." + i);
         anExe = options.getProperty("association.executable." + i);
      }

      for(i = 0; i < appListModel.getSize(); i++)
      {
         ExtAssoc anItem = (ExtAssoc) appListModel.elementAt(i);
         options.put("association.extention." + i, anItem.ext);
         options.put("association.executable." + i, anItem.exe);
      }

      try
      {
         anExe = dirAssocField.getText();
         if(!anExe.equals(""))
            options.put("assocation.directory.executable",anExe);
         else
            options.remove("assocation.directory.executable");
      }
      catch(NullPointerException ee) {}


      i = 0;
      String aMountPoint = options.getProperty("mountpoint." + i);
      while(aMountPoint != null)
      {
         options.remove("mountpoint." + i);
         int j = 0;
         String aSysMountPoint = options.getProperty("mountpoint." + i + "." + j);
         while(aSysMountPoint != null)
         {
            options.remove("mountpoint." + i + "." + j);
            aSysMountPoint = options.getProperty("mountpoint." + i + "." + ++j);
         }
         aMountPoint = options.getProperty("mountpoint." + ++i);
      }

      for(i = 0; i < mountLeftListModel.getSize(); i++)
      {
         MountPoints anItem = (MountPoints) mountLeftListModel.elementAt(i);
         options.put("mountpoint." + i, anItem.toString());
         for(int j = 0; j < anItem.sysMountPoints.size(); j++)
            options.put("mountpoint." + i + "." + j, anItem.sysMountPoints.elementAt(j).toString());
      }

      String tempDir = tempDirField.getText();
      if(tempDir.equals(""))
         options.remove("temporaryDirectory");
      else
         options.put("temporaryDirectory", tempDir);

      String bufferSize = bufferField.getText();
      if(bufferSize.equals(""))
         options.remove("memoryBufferSize");
      else
         options.put("memoryBufferSize", bufferSize);

      options.put("ibmjdkkludge",String.valueOf(kludgeButton.isSelected()));

      DiskIndexer.saveProperties();

      this.dispose();
      mainFrame.requestFocus();
   }
   else if(command == "Cancel")
   {
      this.dispose();
      mainFrame.requestFocus();
   }

// == first page

   else if(command == "Add")
   {
      ExtAssoc newEntry = new ExtAssoc(extField.getText(), exeField.getText());
      appListModel.addElement(newEntry);
      appList.setSelectedIndex(appListModel.getSize()-1);
   }
   else if(command == "Change")
   {
      int index = appList.getSelectedIndex();
      if(index > -1 && !appListModel.isEmpty())
      {
         ExtAssoc newEntry = new ExtAssoc(extField.getText(), exeField.getText());
         appListModel.set(index,newEntry);
      }
   }
   else if(command == "Delete")
   {
      int index = appList.getSelectedIndex();
      if(index > -1 && !appListModel.isEmpty())
      {
         appListModel.remove(index);
         if(index == 0 && appListModel.isEmpty()) //nothing left
         {
            extField.setText("");
            exeField.setText("");
         }
         else
            appList.setSelectedIndex(index-1);
      }
   }

   else if(command == "Browse")
   {
      int rc = exeChooser.showDialog(this,"Choose");

      if(rc == JFileChooser.APPROVE_OPTION)
      {
         File file = exeChooser.getSelectedFile();
         exeField.setText(file.getPath());
      }
   }
   else if(command == "Browse2")
   {
      int rc = exeChooser.showDialog(this,"Choose");

      if(rc == JFileChooser.APPROVE_OPTION)
      {
         File file = exeChooser.getSelectedFile();
         dirAssocField.setText(file.getPath());
      }
   }

// == second page

   else if(command == "mlAdd")
   {
      MountPoints newEntry = new MountPoints(mlField.getText());
      mountLeftListModel.addElement(newEntry);
      mountLeftList.setSelectedIndex(mountLeftListModel.getSize()-1);
   }
   else if(command == "mlChange")
   {
      int index = mountLeftList.getSelectedIndex();
      if(index > -1 && !mountLeftListModel.isEmpty())
      {
         MountPoints modifiedEntry = (MountPoints) mountLeftListModel.get(index);
         modifiedEntry.association = mlField.getText();
         mountLeftListModel.set(index,modifiedEntry);
      }
   }
   else if(command == "mlDelete")
   {
      int index = mountLeftList.getSelectedIndex();
      if(index > -1 && !mountLeftListModel.isEmpty())
      {
         mountLeftListModel.remove(index);
         if(index == 0 && mountLeftListModel.isEmpty()) //nothing left
         {
            mlField.setText("");
            mountRightListModel.clear();
         }
         else
            mountLeftList.setSelectedIndex(index-1);
      }
   }

   else if(command == "mrAdd")
   {
      if(currentLeftSelection != null)
      {
         currentLeftSelection.sysMountPoints.addElement(mrField.getText());
         mountRightListModel.addElement(mrField.getText());
         mountRightList.setSelectedIndex(mountRightListModel.getSize()-1);
      }
   }
   else if(command == "mrChange")
   {
      int index = mountRightList.getSelectedIndex();
      if(index > -1 && !mountRightListModel.isEmpty())
      {
         currentLeftSelection.sysMountPoints.setElementAt(mrField.getText(),index);
         mountRightListModel.set(index, mrField.getText());
      }
   }
   else if(command == "mrDelete")
   {
      int index = mountRightList.getSelectedIndex();
      if(index > -1 && !mountRightListModel.isEmpty())
      {
         currentLeftSelection.sysMountPoints.removeElementAt(index);
         mountRightListModel.remove(index);
         if(index == 0 && mountRightListModel.isEmpty()) //nothing left
            mrField.setText("");
         else
            mountRightList.setSelectedIndex(index-1);
      }
   }
}

   public class ExtAssoc
   {
      String ext = null,
             exe = null;

   ExtAssoc(String ext, String exe)
   {
      this.ext = ext;
      this.exe = exe;
   }

   public String toString()
   {
      return ext;
   }

   }

   public class MountPoints
   {
      Vector sysMountPoints = new Vector(10);
      String association = null;

   MountPoints(String association)
   {
      this.association = association;
   }

   public String toString()
   {
      return association;
   }

   }



}

