/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.AudioStreamChunk;
import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.ContentDescription;
import entagged.audioformats.asf.data.EncodingChunk;
import entagged.audioformats.asf.data.ExtendedContentDescription;
import entagged.audioformats.asf.data.FileHeader;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.data.StreamBitratePropertiesChunk;
import entagged.audioformats.asf.data.StreamChunk;
import java.math.BigInteger;
import java.util.Arrays;

public class AsfHeader
extends Chunk {
    private final long chunkCount;
    private ContentDescription contentDescription;
    private EncodingChunk encodingChunk;
    private ExtendedContentDescription extendedContentDescription;
    private FileHeader fileHeader;
    private StreamBitratePropertiesChunk streamBitratePropertiesChunk;
    private StreamChunk[] streamChunks;
    private Chunk[] unspecifiedChunks;

    public AsfHeader(long l, BigInteger bigInteger, long l2) {
        super(GUID.GUID_HEADER, l, bigInteger);
        this.chunkCount = l2;
        this.streamChunks = new StreamChunk[0];
        this.unspecifiedChunks = new Chunk[0];
    }

    public void addStreamChunk(StreamChunk streamChunk) {
        if (streamChunk == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        if (!Arrays.asList(this.streamChunks).contains(streamChunk)) {
            StreamChunk[] streamChunkArray = new StreamChunk[this.streamChunks.length + 1];
            System.arraycopy(this.streamChunks, 0, streamChunkArray, 0, this.streamChunks.length);
            streamChunkArray[streamChunkArray.length - 1] = streamChunk;
            this.streamChunks = streamChunkArray;
        }
    }

    public void addUnspecifiedChunk(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        if (!Arrays.asList(this.unspecifiedChunks).contains(chunk)) {
            Chunk[] chunkArray = new Chunk[this.unspecifiedChunks.length + 1];
            System.arraycopy(this.unspecifiedChunks, 0, chunkArray, 0, this.unspecifiedChunks.length);
            chunkArray[chunkArray.length - 1] = chunk;
            this.unspecifiedChunks = chunkArray;
        }
    }

    public AudioStreamChunk getAudioStreamChunk() {
        AudioStreamChunk audioStreamChunk = null;
        for (int i = 0; i < this.getStreamChunkCount() && audioStreamChunk == null; ++i) {
            StreamChunk streamChunk = this.getStreamChunk(i);
            if (!(streamChunk instanceof AudioStreamChunk)) continue;
            audioStreamChunk = (AudioStreamChunk)streamChunk;
        }
        return audioStreamChunk;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public ContentDescription getContentDescription() {
        return this.contentDescription;
    }

    public EncodingChunk getEncodingChunk() {
        return this.encodingChunk;
    }

    public ExtendedContentDescription getExtendedContentDescription() {
        return this.extendedContentDescription;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public StreamBitratePropertiesChunk getStreamBitratePropertiesChunk() {
        return this.streamBitratePropertiesChunk;
    }

    public StreamChunk getStreamChunk(int n) {
        return this.streamChunks[n];
    }

    public int getStreamChunkCount() {
        return this.streamChunks.length;
    }

    public Chunk getUnspecifiedChunk(int n) {
        return this.unspecifiedChunks[n];
    }

    public int getUnspecifiedChunkCount() {
        return this.unspecifiedChunks.length;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint());
        stringBuffer.insert(0, "\nASF Chunk\n");
        stringBuffer.append("   Contains: \"" + this.getChunkCount() + "\" chunks\n");
        stringBuffer.append(this.getFileHeader());
        stringBuffer.append(this.getExtendedContentDescription());
        stringBuffer.append(this.getEncodingChunk());
        stringBuffer.append(this.getContentDescription());
        stringBuffer.append(this.getStreamBitratePropertiesChunk());
        for (int i = 0; i < this.getStreamChunkCount(); ++i) {
            stringBuffer.append(this.getStreamChunk(i));
        }
        return stringBuffer.toString();
    }

    public void setContentDescription(ContentDescription contentDescription) {
        this.contentDescription = contentDescription;
    }

    public void setEncodingChunk(EncodingChunk encodingChunk) {
        if (encodingChunk == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.encodingChunk = encodingChunk;
    }

    public void setExtendedContentDescription(ExtendedContentDescription extendedContentDescription) {
        this.extendedContentDescription = extendedContentDescription;
    }

    public void setFileHeader(FileHeader fileHeader) {
        if (fileHeader == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.fileHeader = fileHeader;
    }

    public void setStreamBitratePropertiesChunk(StreamBitratePropertiesChunk streamBitratePropertiesChunk) {
        this.streamBitratePropertiesChunk = streamBitratePropertiesChunk;
    }
}

