/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.math.BigInteger;
import java.util.ArrayList;

public class StreamBitratePropertiesChunk
extends Chunk {
    private final ArrayList bitRates = new ArrayList();
    private final ArrayList streamNumbers = new ArrayList();

    public StreamBitratePropertiesChunk(long l, BigInteger bigInteger) {
        super(GUID.GUID_STREAM_BITRATE_PROPERTIES, l, bigInteger);
    }

    public void addBitrateRecord(int n, long l) {
        this.streamNumbers.add(new Integer(n));
        this.bitRates.add(new Long(l));
    }

    public long getAvgBitrate(int n) {
        Integer n2 = new Integer(n);
        int n3 = this.streamNumbers.indexOf(n2);
        if (n3 != -1) {
            return (Long)this.bitRates.get(n3);
        }
        return -1L;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint());
        stringBuffer.insert(0, Utils.LINE_SEPARATOR + "Stream Bitrate Properties:" + Utils.LINE_SEPARATOR);
        for (int i = 0; i < this.bitRates.size(); ++i) {
            stringBuffer.append("   Stream no. \"" + this.streamNumbers.get(i) + "\" has an average bitrate of \"" + this.bitRates.get(i) + "\"" + Utils.LINE_SEPARATOR);
        }
        stringBuffer.append(Utils.LINE_SEPARATOR);
        return stringBuffer.toString();
    }
}

