/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.math.BigInteger;

public class StreamChunk
extends Chunk {
    private boolean contentEncrypted;
    private int streamNumber;
    private long streamSpecificDataSize;
    private long timeOffset;
    private long typeSpecificDataSize;

    public StreamChunk(long l, BigInteger bigInteger) {
        super(GUID.GUID_AUDIOSTREAM, l, bigInteger);
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public long getStreamSpecificDataSize() {
        return this.streamSpecificDataSize;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getTypeSpecificDataSize() {
        return this.typeSpecificDataSize;
    }

    public boolean isContentEncrypted() {
        return this.contentEncrypted;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint());
        stringBuffer.insert(0, Utils.LINE_SEPARATOR + "Stream Data:" + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Stream number: " + this.getStreamNumber() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Type specific data size  : " + this.getTypeSpecificDataSize() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Stream specific data size: " + this.getStreamSpecificDataSize() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Time Offset              : " + this.getTimeOffset() + Utils.LINE_SEPARATOR);
        stringBuffer.append("   Content Encryption       : " + this.isContentEncrypted() + Utils.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public void setContentEncrypted(boolean bl) {
        this.contentEncrypted = bl;
    }

    public void setStreamNumber(int n) {
        this.streamNumber = n;
    }

    public void setStreamSpecificDataSize(long l) {
        this.streamSpecificDataSize = l;
    }

    public void setTimeOffset(long l) {
        this.timeOffset = l;
    }

    public void setTypeSpecificDataSize(long l) {
        this.typeSpecificDataSize = l;
    }
}

