/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.StreamChunk;
import entagged.audioformats.asf.util.Utils;
import java.math.BigInteger;

public class VideoStreamChunk
extends StreamChunk {
    private byte[] codecId;
    private long pictureHeight;
    private long pictureWidth;

    public VideoStreamChunk(long l, BigInteger bigInteger) {
        super(l, bigInteger);
    }

    public byte[] getCodecId() {
        return this.codecId;
    }

    public String getCodecIdAsString() {
        if (this.getCodecId() != null) {
            return new String(this.getCodecId());
        }
        return "Unknown";
    }

    public long getPictureHeight() {
        return this.pictureHeight;
    }

    public long getPictureWidth() {
        return this.pictureWidth;
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint().replaceAll(Utils.LINE_SEPARATOR, Utils.LINE_SEPARATOR + "   "));
        stringBuffer.insert(0, Utils.LINE_SEPARATOR + "VideoStream");
        stringBuffer.append("Video info:" + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Width  : " + this.getPictureWidth() + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Heigth : " + this.getPictureHeight() + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Codec  : " + this.getCodecIdAsString() + Utils.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public void setCodecId(byte[] byArray) {
        this.codecId = byArray;
    }

    public void setPictureHeight(long l) {
        this.pictureHeight = l;
    }

    public void setPictureWidth(long l) {
        this.pictureWidth = l;
    }
}

