/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.EncodingChunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class EncodingChunkReader {
    public static EncodingChunk read(RandomAccessFile randomAccessFile, Chunk chunk) throws IOException {
        if (randomAccessFile == null || chunk == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_ENCODING.equals(chunk.getGuid())) {
            randomAccessFile.seek(chunk.getPosition());
            return new EncodingChunkReader().parseData(randomAccessFile);
        }
        return null;
    }

    protected EncodingChunkReader() {
    }

    private EncodingChunk parseData(RandomAccessFile randomAccessFile) throws IOException {
        EncodingChunk encodingChunk = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_ENCODING.equals(gUID)) {
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            encodingChunk = new EncodingChunk(l, bigInteger);
            randomAccessFile.skipBytes(20);
            int n = Utils.readUINT16(randomAccessFile);
            for (int i = 0; i < n; ++i) {
                encodingChunk.addString(Utils.readCharacterSizedString(randomAccessFile));
            }
        }
        return encodingChunk;
    }
}

