/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.FileHeader;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class FileHeaderReader {
    public static FileHeader read(RandomAccessFile randomAccessFile, Chunk chunk) throws IOException {
        if (randomAccessFile == null || chunk == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_FILE.equals(chunk.getGuid())) {
            randomAccessFile.seek(chunk.getPosition());
            return new FileHeaderReader().parseData(randomAccessFile);
        }
        return null;
    }

    protected FileHeaderReader() {
    }

    private FileHeader parseData(RandomAccessFile randomAccessFile) throws IOException {
        FileHeader fileHeader = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_FILE.equals(gUID)) {
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            randomAccessFile.skipBytes(16);
            BigInteger bigInteger2 = Utils.readBig64(randomAccessFile);
            if ((long)bigInteger2.intValue() != randomAccessFile.length()) {
                System.err.println("Filesize of file doesn't match len of Fileheader. (" + bigInteger2.toString() + ", file: " + randomAccessFile.length() + ")");
            }
            BigInteger bigInteger3 = Utils.readBig64(randomAccessFile);
            BigInteger bigInteger4 = Utils.readBig64(randomAccessFile);
            BigInteger bigInteger5 = Utils.readBig64(randomAccessFile);
            BigInteger bigInteger6 = Utils.readBig64(randomAccessFile);
            BigInteger bigInteger7 = Utils.readBig64(randomAccessFile);
            long l2 = Utils.readUINT32(randomAccessFile);
            long l3 = Utils.readUINT32(randomAccessFile);
            long l4 = Utils.readUINT32(randomAccessFile);
            long l5 = Utils.readUINT32(randomAccessFile);
            fileHeader = new FileHeader(l, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger6, bigInteger7, bigInteger5, l2, l3, l4, l5);
        }
        return fileHeader;
    }
}

