/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.util;

import entagged.audioformats.Tag;
import entagged.audioformats.asf.util.Utils;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import java.io.UnsupportedEncodingException;
import java.util.List;

public final class AsfCopyrightField
implements TagTextField {
    public static final String FIELD_ID = "SPECIAL/WM/COPYRIGHT";
    private String value = "";

    public static TagTextField getCopyright(Tag tag) {
        TagField tagField;
        TagTextField tagTextField = null;
        List list = tag.get(FIELD_ID);
        if (list != null && list.size() > 0 && (tagField = (TagField)list.get(0)) instanceof TagTextField) {
            tagTextField = (TagTextField)tagField;
        }
        return tagTextField;
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof TagTextField) {
            this.value = ((TagTextField)tagField).getContent();
        }
    }

    public String getContent() {
        return this.value;
    }

    public String getEncoding() {
        return "UTF-16LE";
    }

    public String getId() {
        return FIELD_ID;
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        return this.value.getBytes("UTF-16LE");
    }

    public boolean isBinary() {
        return false;
    }

    public void isBinary(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("No conversion supported. Copyright is a String");
        }
    }

    public boolean isCommon() {
        return true;
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public void setContent(String string) {
        try {
            this.setString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            this.value = "Conversion Exception occured.";
        }
    }

    public void setEncoding(String string) {
        if (string == null || !string.equalsIgnoreCase("UTF-16LE")) {
            throw new UnsupportedOperationException("The encoding of Asf tags cannot be changed.(specified to be UTF-16LE)");
        }
    }

    public void setString(String string) {
        this.value = string;
        Utils.checkStringLengthNullSafe(this.value);
    }

    public String toString() {
        return "SPECIAL/WM/COPYRIGHT:\"" + this.getContent() + "\"";
    }
}

