/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.util;

import entagged.audioformats.asf.data.GUID;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.GregorianCalendar;

public class Utils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void fillChars(char[] cArray, RandomAccessFile randomAccessFile) throws IOException {
        if (cArray == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = randomAccessFile.readChar();
        }
    }

    public static byte[] getBytes(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return byArray;
    }

    public static GregorianCalendar getDateOf(BigInteger bigInteger) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1601, 0, 1);
        bigInteger = bigInteger.divide(new BigInteger("10000"));
        BigInteger bigInteger2 = new BigInteger(String.valueOf(Integer.MAX_VALUE));
        while (bigInteger.compareTo(bigInteger2) > 0) {
            gregorianCalendar.add(14, Integer.MAX_VALUE);
            bigInteger = bigInteger.subtract(bigInteger2);
        }
        gregorianCalendar.add(14, bigInteger.intValue());
        return gregorianCalendar;
    }

    public static int read7Bit(RandomAccessFile randomAccessFile) throws IOException {
        int n = randomAccessFile.read();
        return n & 0x7F;
    }

    public static BigInteger readBig64(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        randomAccessFile.readFully(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[7 - i] = byArray[i];
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return bigInteger;
    }

    public static String readCharacterSizedString(RandomAccessFile randomAccessFile) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Utils.readUINT16(randomAccessFile);
        int n2 = randomAccessFile.read();
        n2 |= randomAccessFile.read() << 8;
        do {
            if (n2 == 0) continue;
            stringBuffer.append((char)n2);
            n2 = randomAccessFile.read();
            n2 |= randomAccessFile.read() << 8;
        } while (n2 != 0 || stringBuffer.length() + 1 > n);
        if (n != stringBuffer.length() + 1) {
            throw new IllegalStateException("Invalid Data for current interpretation");
        }
        return stringBuffer.toString();
    }

    public static GUID readGUID(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        int[] nArray = new int[16];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = randomAccessFile.read();
        }
        return new GUID(nArray);
    }

    public static int readUINT16(RandomAccessFile randomAccessFile) throws IOException {
        int n = randomAccessFile.read();
        return n |= randomAccessFile.read() << 8;
    }

    public static long readUINT32(RandomAccessFile randomAccessFile) throws IOException {
        long l = 0L;
        for (int i = 0; i <= 24; i += 8) {
            l |= (long)(randomAccessFile.read() << i);
        }
        return l;
    }

    public static long readUINT64(RandomAccessFile randomAccessFile) throws IOException {
        long l = 0L;
        for (int i = 0; i <= 56; i += 8) {
            l |= (long)(randomAccessFile.read() << i);
        }
        return l;
    }

    public static String readUTF16LEStr(RandomAccessFile randomAccessFile) throws IOException {
        int n = Utils.readUINT16(randomAccessFile);
        byte[] byArray = new byte[n];
        int n2 = randomAccessFile.read(byArray);
        if (n2 == byArray.length) {
            if (byArray.length >= 2 && byArray[byArray.length - 1] == 0 && byArray[byArray.length - 2] == 0) {
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length - 2);
                byArray = byArray2;
            }
            return new String(byArray, "UTF-16LE");
        }
        throw new IllegalStateException("Invalid Data for current interpretation");
    }

    public static void checkStringLengthNullSafe(String string) throws IllegalArgumentException {
        if (string != null) {
            try {
                byte[] byArray = string.getBytes("UTF-16LE");
                if (byArray.length > 65533) {
                    throw new IllegalArgumentException("\"UTF-16LE\" representation exceeds 65535 bytes. (Including zero term character)");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }
}

