/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.id3frames.ApicId3Frame;
import entagged.audioformats.mp3.util.id3frames.CommId3Frame;
import entagged.audioformats.mp3.util.id3frames.GenericId3Frame;
import entagged.audioformats.mp3.util.id3frames.Id3Frame;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import entagged.audioformats.mp3.util.id3frames.TimeId3Frame;
import entagged.audioformats.mp3.util.id3frames.UfidId3Frame;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class Id3v24TagReader {
    private Hashtable conversion22to23;

    public Id3v24TagReader() {
        this.initConversionTable();
    }

    private String convertFromId3v22(String string) {
        String string2 = (String)this.conversion22to23.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    private Id3Frame createId3Frame(String string, byte[] byArray, byte by) throws UnsupportedEncodingException {
        if (by == Id3v2Tag.ID3V22) {
            string = this.convertFromId3v22(string);
        }
        if (string.startsWith("T") && !string.startsWith("TX")) {
            if (string.equalsIgnoreCase("TDRC")) {
                return new TimeId3Frame(string, byArray, by);
            }
            return new TextId3Frame(string, byArray, by);
        }
        if (string.startsWith("COMM")) {
            return new CommId3Frame(byArray, by);
        }
        if (string.startsWith("UFID")) {
            return new UfidId3Frame(byArray, by);
        }
        if (string.startsWith("APIC")) {
            return new ApicId3Frame(byArray, by);
        }
        return new GenericId3Frame(string, byArray, by);
    }

    private void initConversionTable() {
        this.conversion22to23 = new Hashtable(100);
        String[] stringArray = new String[]{"BUF", "CNT", "COM", "CRA", "CRM", "ETC", "EQU", "GEO", "IPL", "LNK", "MCI", "MLL", "PIC", "POP", "REV", "RVA", "SLT", "STC", "TAL", "TBP", "TCM", "TCO", "TCR", "TDA", "TDY", "TEN", "TFT", "TIM", "TKE", "TLA", "TLE", "TMT", "TOA", "TOF", "TOL", "TOR", "TOT", "TP1", "TP2", "TP3", "TP4", "TPA", "TPB", "TRC", "TRD", "TRK", "TSI", "TSS", "TT1", "TT2", "TT3", "TXT", "TXX", "TYE", "UFI", "ULT", "WAF", "WAR", "WAS", "WCM", "WCP", "WPB", "WXX"};
        String[] stringArray2 = new String[]{"RBUF", "PCNT", "COMM", "AENC", "", "ETCO", "EQUA", "GEOB", "IPLS", "LINK", "MCDI", "MLLT", "APIC", "POPM", "RVRB", "RVAD", "SYLT", "SYTC", "TALB", "TBPM", "TCOM", "TCON", "TCOP", "TDAT", "TDLY", "TENC", "TFLT", "TIME", "TKEY", "TLAN", "TLEN", "TMED", "TOPE", "TOFN", "TOLY", "TORY", "TOAL", "TPE1", "TPE2", "TPE3", "TPE4", "TPOS", "TPUB", "TSRC", "TRDA", "TRCK", "TSIZ", "TSSE", "TIT1", "TIT2", "TIT3", "TEXT", "TXXX", "TYER", "UFID", "USLT", "WOAF", "WOAR", "WOAS", "WCOM", "WCOP", "WPUB", "WXXX"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.conversion22to23.put(stringArray[i], stringArray2[i]);
        }
    }

    private int processExtendedHeader(ByteBuffer byteBuffer, byte by) {
        int n = 0;
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        if (by == Id3v2Tag.ID3V23) {
            n = this.readSize(byteBuffer, Id3v2Tag.ID3V23);
            byteBuffer.position(byteBuffer.position() + n);
        } else {
            n = this.readSyncsafeInteger(byteBuffer);
            byteBuffer.position(byteBuffer.position() + n);
        }
        return n;
    }

    public Id3v2Tag read(ByteBuffer byteBuffer, boolean[] blArray, byte by) throws UnsupportedEncodingException {
        int n = byteBuffer.limit();
        Id3v2Tag id3v2Tag = new Id3v2Tag();
        if ((by == Id3v2Tag.ID3V23 || by == Id3v2Tag.ID3V24) && blArray[1]) {
            this.processExtendedHeader(byteBuffer, by);
        }
        int n2 = by == Id3v2Tag.ID3V22 ? 3 : 4;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[n2];
            if (byteBuffer.remaining() <= n2) break;
            byteBuffer.get(byArray);
            String string = new String(byArray);
            if (byArray[0] == 0) break;
            int n3 = this.readSize(byteBuffer, by);
            if (n3 > byteBuffer.remaining() || n3 <= 0) {
                System.err.println(string + " Frame size error, skiping the rest of the tag:" + n3);
                break;
            }
            byArray = new byte[n3 + (by == Id3v2Tag.ID3V23 || by == Id3v2Tag.ID3V24 ? 2 : 0)];
            byteBuffer.get(byArray);
            if ("".equals(string)) continue;
            Id3Frame id3Frame = null;
            try {
                id3Frame = this.createId3Frame(string, byArray, by);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw unsupportedEncodingException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (id3Frame == null) continue;
            id3v2Tag.add(id3Frame);
        }
        return id3v2Tag;
    }

    private int readSize(ByteBuffer byteBuffer, int n) {
        int n2 = 0;
        if (n == Id3v2Tag.ID3V24) {
            n2 = this.readSyncsafeInteger(byteBuffer);
        } else {
            if (n == Id3v2Tag.ID3V23) {
                n2 += (byteBuffer.get() & 0xFF) << 24;
            }
            n2 += (byteBuffer.get() & 0xFF) << 16;
            n2 += (byteBuffer.get() & 0xFF) << 8;
            n2 += byteBuffer.get() & 0xFF;
        }
        return n2;
    }

    private int readSyncsafeInteger(ByteBuffer byteBuffer) {
        int n = 0;
        n += (byteBuffer.get() & 0xFF) << 21;
        n += (byteBuffer.get() & 0xFF) << 14;
        n += (byteBuffer.get() & 0xFF) << 7;
        return n += byteBuffer.get() & 0xFF;
    }
}

