/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.mp3.util.Id3v2TagCreator;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class Id3v2TagWriter {
    private Id3v2TagCreator tc = new Id3v2TagCreator();

    public RandomAccessFile delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException {
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.position(0L);
        if (!this.tagExists(fileChannel)) {
            return randomAccessFile;
        }
        fileChannel.position(6L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        fileChannel.read(byteBuffer);
        byteBuffer.rewind();
        int n = (byteBuffer.get() & 0xFF) << 21;
        n += (byteBuffer.get() & 0xFF) << 14;
        n += (byteBuffer.get() & 0xFF) << 7;
        FileChannel fileChannel2 = randomAccessFile2.getChannel();
        fileChannel2.position(0L);
        fileChannel.position((n += byteBuffer.get() & 0xFF) + 10);
        byteBuffer = ByteBuffer.allocate(4);
        int n2 = 0;
        while (fileChannel.read(byteBuffer) != -1) {
            if ((byteBuffer.get(0) & 0xFF) == 255 && (byteBuffer.get(1) & 0xE0) == 224 && (byteBuffer.get(1) & 6) != 0 && (byteBuffer.get(2) & 0xF0) != 240 && (byteBuffer.get(2) & 8) != 8) {
                fileChannel.position(fileChannel.position() - 4L);
                break;
            }
            fileChannel.position(fileChannel.position() - 3L);
            byteBuffer.rewind();
            ++n2;
        }
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size() - (long)n - 10L - (long)n2);
        return randomAccessFile2;
    }

    private boolean tagExists(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(3);
        fileChannel.position(0L);
        fileChannel.read(byteBuffer);
        String string = new String(byteBuffer.array());
        return string.equals("ID3");
    }

    private boolean canOverwrite(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(3L);
        String string = randomAccessFile.read() + "";
        return string.equals("4") || string.equals("3") || string.equals("2");
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        ByteBuffer[] byteBufferArray;
        FileChannel fileChannel = randomAccessFile.getChannel();
        int n = 0;
        if (this.tagExists(fileChannel)) {
            if (!this.canOverwrite(randomAccessFile)) {
                throw new CannotWriteException("Overwritting of this kind of ID3v2 tag not supported yet");
            }
            fileChannel.position(6L);
            byteBufferArray = ByteBuffer.allocate(4);
            fileChannel.read((ByteBuffer)byteBufferArray);
            n = (byteBufferArray.get(0) & 0xFF) << 21;
            n += (byteBufferArray.get(1) & 0xFF) << 14;
            n += (byteBufferArray.get(2) & 0xFF) << 7;
            n += byteBufferArray.get(3) & 0xFF;
            int n2 = this.tc.getTagLength(tag);
            if ((n += 10) >= n2) {
                fileChannel.position(0L);
                fileChannel.write(this.tc.convert(tag, n - n2));
                return;
            }
        }
        fileChannel.position(n);
        if (fileChannel.size() > 0xF00000L) {
            byteBufferArray = randomAccessFile2.getChannel();
            byteBufferArray.position(0L);
            byteBufferArray.write(this.tc.convert(tag, 4000));
            byteBufferArray.transferFrom(fileChannel, byteBufferArray.position(), fileChannel.size() - (long)n);
            fileChannel.close();
        } else {
            byteBufferArray = new ByteBuffer[2];
            byteBufferArray[1] = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(byteBufferArray[1]);
            byteBufferArray[1].rewind();
            byteBufferArray[0] = this.tc.convert(tag, 4000);
            fileChannel.position(0L);
            fileChannel.write(byteBufferArray);
        }
    }
}

