/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

public class MPEGFrame {
    private byte[] mpegBytes;
    private int MPEGVersion;
    private int bitrate;
    private int channelMode;
    private String emphasis;
    private boolean hasPadding;
    private boolean isCopyrighted;
    private boolean isOriginal;
    private boolean isProtected;
    private boolean isValid;
    private int layer;
    private String modeExtension;
    private int samplingRate;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int LAYER_I = 3;
    public static final int LAYER_II = 2;
    public static final int LAYER_III = 1;
    public static final int LAYER_RESERVED = 0;
    public static final int MPEG_VERSION_1 = 3;
    public static final int MPEG_VERSION_2 = 2;
    public static final int MPEG_VERSION_2_5 = 0;
    public static final int MPEG_VERSION_RESERVED = 1;
    private static final int[] MPEGVersionTable = new int[]{0, 1, 2, 3};
    private static final String[] MPEGVersionTable_String = new String[]{"MPEG Version 2.5", "reserved", "MPEG Version 2 (ISO/IEC 13818-3)", "MPEG Version 1 (ISO/IEC 11172-3)"};
    private static final int[][][] bitrateTable = new int[][][]{new int[][]{{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}}, new int[][]{{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}}};
    private static final String[] channelModeTable_String = new String[]{"Stereo", "Joint stereo (Stereo)", "Dual channel (2 mono channels)", "Single channel (Mono)"};
    private static final String[] emphasisTable = new String[]{"none", "50/15 ms", "reserved", "CCIT J.17"};
    private static final int[] layerDescriptionTable = new int[]{0, 1, 2, 3};
    private static final String[] layerDescriptionTable_String = new String[]{"reserved", "Layer III", "Layer II", "Layer I"};
    private static final String[][] modeExtensionTable = new String[][]{{"4-31", "8-31", "12-31", "16-31"}, {"off-off", "on-off", "off-on", "on-on"}};
    private static final int[][] samplingRateTable = new int[][]{{44100, 48000, 32000, 0}, {22050, 24000, 16000, 0}, {11025, 12000, 8000, 0}};
    private static final int[] SAMPLE_NUMBERS = new int[]{-1, 1152, 1152, 384};

    public MPEGFrame(byte[] byArray) {
        this.mpegBytes = byArray;
        if (this.isMPEGFrame()) {
            this.MPEGVersion = this.MPEGVersion();
            this.layer = this.layerDescription();
            this.isProtected = this.isProtected();
            this.bitrate = this.bitrate();
            this.samplingRate = this.samplingRate();
            this.hasPadding = this.hasPadding();
            this.channelMode = this.channelMode();
            this.modeExtension = this.modeExtension();
            this.isCopyrighted = this.isCopyrighted();
            this.isOriginal = this.isOriginal();
            this.emphasis = this.emphasis();
            this.isValid = true;
        } else {
            this.isValid = false;
        }
        this.mpegBytes = null;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getChannelNumber() {
        switch (this.channelMode) {
            case 2: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 0;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public int getLayerVersion() {
        return this.layer;
    }

    public int getMPEGVersion() {
        return this.MPEGVersion;
    }

    public int getPaddingLength() {
        if (this.hasPadding && this.layer != 3) {
            return 1;
        }
        if (this.hasPadding && this.layer == 3) {
            return 4;
        }
        return 0;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getFrameLength() {
        if (this.layer == 3) {
            return (12 * (this.getBitrate() * 1000) / this.getSamplingRate() + this.getPaddingLength()) * 4;
        }
        return 144 * (this.getBitrate() * 1000) / this.getSamplingRate() + this.getPaddingLength();
    }

    public int getSampleNumber() {
        int n = SAMPLE_NUMBERS[this.layer];
        return n;
    }

    public String MPEGVersionToString(int n) {
        return MPEGVersionTable_String[n];
    }

    public String channelModeToString(int n) {
        return channelModeTable_String[n];
    }

    public String layerToString(int n) {
        return layerDescriptionTable_String[n];
    }

    public String toString() {
        String string = "\n----MPEGFrame--------------------\n";
        string = string + "MPEG Version: " + this.MPEGVersionToString(this.MPEGVersion) + "\tLayer: " + this.layerToString(this.layer) + "\n";
        string = string + "Bitrate: " + this.bitrate + "\tSamp.Freq.: " + this.samplingRate + "\tChan.Mode: " + this.channelModeToString(this.channelMode) + "\n";
        string = string + "Mode Extension: " + this.modeExtension + "\tEmphasis: " + this.emphasis + "\n";
        string = string + "Padding? " + this.hasPadding + "\tProtected? " + this.isProtected + "\tCopyright? " + this.isCopyrighted + "\tOriginal? " + this.isOriginal + "\n";
        string = string + "--------------------------------";
        return string;
    }

    private boolean isCopyrighted() {
        return (this.mpegBytes[3] & 8) == 8;
    }

    private boolean isMPEGFrame() {
        return (this.mpegBytes[0] & 0xFF) == 255 && (this.mpegBytes[1] & 0xE0) == 224;
    }

    private boolean isOriginal() {
        return (this.mpegBytes[3] & 4) == 4;
    }

    private boolean isProtected() {
        return (this.mpegBytes[1] & 1) == 0;
    }

    private int MPEGVersion() {
        int n = (this.mpegBytes[1] & 0x18) >>> 3;
        return MPEGVersionTable[n];
    }

    private int bitrate() {
        int n;
        int n2 = (this.mpegBytes[2] & 0xF0) >>> 4;
        int n3 = n = this.MPEGVersion == 3 ? 0 : 1;
        int n4 = this.layer == 3 ? 0 : (this.layer == 2 ? 1 : 2);
        return bitrateTable[n][n4][n2];
    }

    private int channelMode() {
        int n = (this.mpegBytes[3] & 0xC0) >>> 6;
        return n;
    }

    private String emphasis() {
        int n = this.mpegBytes[3] & 3;
        return emphasisTable[n];
    }

    private boolean hasPadding() {
        return (this.mpegBytes[2] & 2) == 2;
    }

    private int layerDescription() {
        int n = (this.mpegBytes[1] & 6) >>> 1;
        return layerDescriptionTable[n];
    }

    private String modeExtension() {
        int n = (this.mpegBytes[3] & 0x30) >>> 4;
        int n2 = this.layer == 1 ? 1 : 0;
        return modeExtensionTable[n2][n];
    }

    private int samplingRate() {
        int n = (this.mpegBytes[2] & 0xC) >>> 2;
        int n2 = this.MPEGVersion == 3 ? 0 : (this.MPEGVersion == 2 ? 1 : 2);
        return samplingRateTable[n2][n];
    }
}

