/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util.id3frames;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.id3frames.Id3Frame;
import java.io.UnsupportedEncodingException;

public class TextId3Frame
extends Id3Frame
implements TagTextField {
    protected String content;
    protected byte encoding;
    protected String id;
    protected boolean common;

    public TextId3Frame(String string, String string2) {
        this.id = string;
        this.checkCommon();
        this.content = string2;
        this.setEncoding(Id3v2Tag.DEFAULT_ENCODING);
    }

    public TextId3Frame(String string, byte[] byArray, byte by) throws UnsupportedEncodingException {
        super(byArray, by);
        this.id = string;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals("TIT2") || this.id.equals("TALB") || this.id.equals("TPE1") || this.id.equals("TCON") || this.id.equals("TRCK") || this.id.equals("TDRC") || this.id.equals("COMM");
    }

    public String getEncoding() {
        if (this.encoding == 0) {
            return "ISO-8859-1";
        }
        if (this.encoding == 1) {
            return "UTF-16";
        }
        if (this.encoding == 2) {
            return "UTF-16BE";
        }
        if (this.encoding == 3) {
            return "UTF-8";
        }
        return "ISO-8859-1";
    }

    public void setEncoding(String string) {
        this.encoding = "ISO-8859-1".equals(string) ? (byte)0 : ("UTF-16".equals(string) ? (byte)1 : ("UTF-16BE".equals(string) ? (byte)2 : ("UTF-8".equals(string) ? (byte)3 : (byte)1)));
    }

    public String getContent() {
        return this.content;
    }

    public boolean isBinary() {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public boolean isCommon() {
        return this.common;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public boolean isEmpty() {
        return this.content.equals("");
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof TextId3Frame) {
            this.content = ((TextId3Frame)tagField).getContent();
            this.setEncoding(((TextId3Frame)tagField).getEncoding());
        }
    }

    protected void populate(byte[] byArray) throws UnsupportedEncodingException {
        this.encoding = byArray[this.flags.length];
        if (this.encoding != 0 && this.encoding != 1 && this.encoding != 2 && this.encoding != 3) {
            this.encoding = 0;
        }
        this.content = this.getString(byArray, this.flags.length + 1, byArray.length - this.flags.length - 1, this.getEncoding());
        int n = this.content.indexOf("\u0000");
        if (n != -1) {
            this.content = this.content.substring(0, n);
        }
    }

    protected byte[] build() throws UnsupportedEncodingException {
        byte[] byArray = this.getBytes(this.content, this.getEncoding());
        byte[] byArray2 = new byte[8 + this.flags.length + 1 + byArray.length];
        int n = 0;
        this.copy(this.getIdBytes(), byArray2, n);
        this.copy(this.getSize(byArray2.length - 10), byArray2, n += 4);
        this.copy(this.flags, byArray2, n += 4);
        byArray2[n += this.flags.length] = this.encoding;
        this.copy(byArray, byArray2, ++n);
        return byArray2;
    }

    public String toString() {
        return this.getContent();
    }
}

