/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp4.util;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.Utils;
import entagged.audioformats.mp4.util.Mp4TagField;
import java.io.UnsupportedEncodingException;

public class Mp4TagBinaryField
extends Mp4TagField {
    protected byte[] dataBytes;
    protected boolean isBinary = false;

    public Mp4TagBinaryField(String string) {
        super(string);
    }

    public Mp4TagBinaryField(String string, byte[] byArray) throws UnsupportedEncodingException {
        super(string, byArray);
    }

    public byte[] getRawContent() {
        byte[] byArray = this.dataBytes;
        byte[] byArray2 = new byte[24 + byArray.length];
        int n = 0;
        Utils.copy(Utils.getSizeBigEndian(byArray2.length), byArray2, n);
        Utils.copy(Utils.getDefaultBytes(this.getId()), byArray2, n += 4);
        Utils.copy(Utils.getSizeBigEndian(16 + byArray.length), byArray2, n += 4);
        Utils.copy(Utils.getDefaultBytes("data"), byArray2, n += 4);
        Utils.copy(new byte[]{0, 0, 0, (byte)(!this.isBinary() ? 1 : 0)}, byArray2, n += 4);
        Utils.copy(new byte[]{0, 0, 0, 0}, byArray2, n += 4);
        Utils.copy(byArray, byArray2, n += 4);
        n += byArray.length;
        return byArray2;
    }

    protected void build(byte[] byArray) {
        int n = Utils.getNumberBigEndian(byArray, 0, 3);
        this.dataBytes = new byte[n - 16];
        for (int i = 16; i < n; ++i) {
            this.dataBytes[i - 16] = byArray[i];
        }
        this.isBinary = (byArray[11] & 1) == 0;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public boolean isEmpty() {
        return this.dataBytes.length == 0;
    }

    public byte[] getData() {
        return this.dataBytes;
    }

    public void setData(byte[] byArray) {
        this.dataBytes = byArray;
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof Mp4TagBinaryField) {
            this.dataBytes = ((Mp4TagBinaryField)tagField).getData();
            this.isBinary = ((Mp4TagBinaryField)tagField).isBinary();
        }
    }
}

