/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp4.util;

import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.mp4.Mp4Tag;
import entagged.audioformats.mp4.util.Mp4Box;
import entagged.audioformats.mp4.util.Mp4TagBinaryField;
import entagged.audioformats.mp4.util.Mp4TagCoverField;
import entagged.audioformats.mp4.util.Mp4TagField;
import entagged.audioformats.mp4.util.Mp4TagTextField;
import entagged.audioformats.mp4.util.Mp4TagTextNumberField;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class Mp4TagReader {
    public Mp4Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        int n;
        Mp4Tag mp4Tag = new Mp4Tag();
        Mp4Box mp4Box = new Mp4Box();
        byte[] byArray = new byte[4];
        this.seek(randomAccessFile, mp4Box, "moov");
        this.seek(randomAccessFile, mp4Box, "udta");
        this.seek(randomAccessFile, mp4Box, "meta");
        randomAccessFile.read(byArray);
        if (byArray[0] != 0) {
            throw new CannotReadException();
        }
        this.seek(randomAccessFile, mp4Box, "ilst");
        int n2 = mp4Box.getOffset() - 8;
        for (int i = 0; i < n2; i += 8 + n) {
            byArray = new byte[8];
            randomAccessFile.read(byArray);
            mp4Box.update(byArray);
            n = mp4Box.getOffset() - 8;
            byArray = new byte[n];
            randomAccessFile.read(byArray);
            mp4Tag.add(this.createMp4Field(mp4Box.getId(), byArray));
        }
        System.out.println(mp4Tag);
        return mp4Tag;
    }

    private Mp4TagField createMp4Field(String string, byte[] byArray) throws UnsupportedEncodingException {
        if (string.equals("trkn") || string.equals("tmpo")) {
            return new Mp4TagTextNumberField(string, byArray);
        }
        if (string.equals("\u00a9ART") || string.equals("\u00a9alb") || string.equals("\u00a9nam") || string.equals("\u00a9day") || string.equals("\u00a9cmt") || string.equals("\u00a9gen") || string.equals("\u00a9too") || string.equals("\u00a9wrt")) {
            return new Mp4TagTextField(string, byArray);
        }
        if (string.equals("covr")) {
            return new Mp4TagCoverField(byArray);
        }
        return new Mp4TagBinaryField(string, byArray);
    }

    private void seek(RandomAccessFile randomAccessFile, Mp4Box mp4Box, String string) throws IOException {
        byte[] byArray = new byte[8];
        randomAccessFile.read(byArray);
        mp4Box.update(byArray);
        while (!mp4Box.getId().equals(string)) {
            randomAccessFile.skipBytes(mp4Box.getOffset() - 8);
            randomAccessFile.read(byArray);
            mp4Box.update(byArray);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new Mp4TagReader().read(new RandomAccessFile(new File("/home/kikidonk/test.mp4"), "r"));
    }
}

