/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

public class OggPageHeader {
    private double absoluteGranulePosition;
    private byte[] checksum;
    private byte headerTypeFlag;
    private boolean isValid = false;
    private int pageLength = 0;
    private int pageSequenceNumber;
    private int streamSerialNumber;
    private byte[] segmentTable;

    public OggPageHeader(byte[] byArray) {
        byte by = byArray[4];
        this.headerTypeFlag = byArray[5];
        if (by == 0) {
            int n;
            this.absoluteGranulePosition = 0.0;
            for (n = 0; n < 8; ++n) {
                this.absoluteGranulePosition += (double)this.u(byArray[n + 6]) * Math.pow(2.0, 8 * n);
            }
            this.streamSerialNumber = this.u(byArray[14]) + (this.u(byArray[15]) << 8) + (this.u(byArray[16]) << 16) + (this.u(byArray[17]) << 24);
            this.pageSequenceNumber = this.u(byArray[18]) + (this.u(byArray[19]) << 8) + (this.u(byArray[20]) << 16) + (this.u(byArray[21]) << 24);
            this.checksum = new byte[]{byArray[22], byArray[23], byArray[24], byArray[25]};
            this.segmentTable = new byte[byArray.length - 27];
            for (n = 0; n < this.segmentTable.length; ++n) {
                this.segmentTable[n] = byArray[27 + n];
                this.pageLength += this.u(byArray[27 + n]);
            }
            this.isValid = true;
        }
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public double getAbsoluteGranulePosition() {
        return this.absoluteGranulePosition;
    }

    public byte[] getCheckSum() {
        return this.checksum;
    }

    public byte getHeaderType() {
        return this.headerTypeFlag;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageSequence() {
        return this.pageSequenceNumber;
    }

    public int getSerialNumber() {
        return this.streamSerialNumber;
    }

    public byte[] getSegmentTable() {
        return this.segmentTable;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        String string = "Ogg Page Header:\n";
        string = string + "Is valid?: " + this.isValid + " | page length: " + this.pageLength + "\n";
        string = string + "Header type: " + this.headerTypeFlag;
        return string;
    }
}

