/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.wav.util;

public class WavFormatHeader {
    private boolean isValid = false;
    private int channels;
    private int sampleRate;
    private int bytesPerSecond;
    private int bitrate;

    public WavFormatHeader(byte[] byArray) {
        String string = new String(byArray, 0, 3);
        if (string.equals("fmt") && byArray[8] == 1) {
            this.channels = byArray[10];
            this.sampleRate = this.u(byArray[15]) * 0x1000000 + this.u(byArray[14]) * 65536 + this.u(byArray[13]) * 256 + this.u(byArray[12]);
            this.bytesPerSecond = this.u(byArray[19]) * 0x1000000 + this.u(byArray[18]) * 65536 + this.u(byArray[17]) * 256 + this.u(byArray[16]);
            this.bitrate = this.u(byArray[22]);
            this.isValid = true;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getChannelNumber() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.sampleRate;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public String toString() {
        String string = "RIFF-WAVE Header:\n";
        string = string + "Is valid?: " + this.isValid;
        return string;
    }
}

