/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.MagicCookieBaker;
import net.sf.jmp3renamer.Main;

public class DataSet
implements Serializable {
    private int id = DataManager.getNextID();
    private String title = "";
    private String artist = "";
    private String track = "";
    private String album = "";
    private String year = "";
    private String genre = "";
    private String comment = "Tag set by JMP3Renamer";
    private String composer = "";
    private String origArtist = "";
    private String copyright = "";
    private String url = "http://sf.net/projects/jmp3renamer";
    private String encodedBy = "";
    private String partOfSet = "";
    private String regex = Main.getProperty("filename");
    private boolean partOfCompilation = false;
    private static String[] partOfSetEvidence = new String[]{"cd (1/1)", "cd (1/2)", "cd(1/1)", "cd(1/2)", "disc (1/1)", "disc (1/2)", "disc(1/1)", "disc(1/2)", "cd (1)", "cd (2)", "cd(1)", "cd(2)", "disc (1)", "disc (2)", "disc(1)", "disc(2)"};

    public boolean isPartOfCompilation() {
        return this.partOfCompilation;
    }

    public void setPartOfCompilation(boolean partOfCompilation) {
        this.partOfCompilation = partOfCompilation;
        this.setRegex(partOfCompilation ? Main.getProperty("filenameCompilation") : Main.getProperty("filename"));
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setTrack(String track) {
        this.track = track.trim();
    }

    public String getTrack() {
        return this.track;
    }

    public void setAlbum(String album) {
        this.album = album;
        this.parseForPartOfSetInfo();
    }

    private void parseForPartOfSetInfo() {
        for (int i = 0; i < partOfSetEvidence.length; ++i) {
            String regex = "^.*" + partOfSetEvidence[i] + ".*$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(this.album.toLowerCase());
            if (!matcher.matches()) continue;
            this.setPartOfSet(matcher.group(1));
            return;
        }
    }

    public String getAlbum() {
        return this.album;
    }

    public void setEncodedBy(String encodedBy) {
        this.encodedBy = encodedBy;
    }

    public String getEncodedBy() {
        return this.encodedBy;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setOrigArtist(String origArtist) {
        this.origArtist = origArtist;
    }

    public String getOrigArtist() {
        return this.origArtist;
    }

    public void setComposer(String composer) {
        this.composer = composer;
    }

    public String getComposer() {
        return this.composer;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getYear() {
        return this.year;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getRegex() {
        return this.regex;
    }

    public String toString() {
        return MagicCookieBaker.evaluateDataSet(this);
    }

    public int getId() {
        return this.id;
    }

    public String getPartOfSet() {
        return this.partOfSet;
    }

    public void setPartOfSet(String partOfSet) {
        this.partOfSet = partOfSet;
    }
}

