/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataPlugin;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.gui.DatasetTable;

class DataPanel
extends JPanel
implements ActionListener,
TableModelListener,
FocusListener {
    private CardLayout cards = new CardLayout();
    private JPanel datasetPanel = new JPanel();
    private DatasetTable datasetTable = new DatasetTable(this);
    private JPanel mainPanel = new JPanel();
    private JPanel datasetFunctions = new JPanel();
    private JButton ok = new JButton(I18N.translate("ok"));
    private JComboBox wordCombo = new JComboBox();
    private JComboBox leadingZeros = new JComboBox();
    private JTextField replace = new JTextField(I18N.translate("replace"));
    private JTextField by = new JTextField(I18N.translate("by"));

    DataPanel(Main main) {
        this.initGUI();
    }

    public void addPlugin(DataPlugin plugin) {
        JComponent gui = plugin.getGUI();
        gui.setBorder(BorderFactory.createTitledBorder(plugin.getName()));
        this.mainPanel.add((Component)gui, plugin.getName());
    }

    public void removePlugin(DataPlugin plugin) {
        this.mainPanel.remove(plugin.getGUI());
    }

    private void initGUI() {
        this.mainPanel.setLayout(this.cards);
        this.datasetPanel.setLayout(new BorderLayout());
        this.datasetPanel.add((Component)new JScrollPane(this.datasetTable), "Center");
        this.leadingZeros.addItem(new Integer(0));
        this.leadingZeros.addItem(new Integer(1));
        this.leadingZeros.addItem(new Integer(2));
        this.leadingZeros.addItem(new Integer(3));
        this.leadingZeros.addItem(new Integer(4));
        this.leadingZeros.setSelectedIndex(Integer.parseInt(Main.getProperty("leading_0s")));
        this.datasetFunctions.setLayout(new GridLayout(6, 2, 10, 10));
        this.datasetFunctions.add(new JLabel("  "));
        this.datasetFunctions.add(new JLabel("  "));
        this.replace.addFocusListener(this);
        this.by.addFocusListener(this);
        this.datasetFunctions.add(this.replace);
        this.datasetFunctions.add(this.by);
        this.datasetFunctions.add(new JLabel(I18N.translate("leading_0s")));
        this.datasetFunctions.add(this.leadingZeros);
        this.datasetFunctions.add(new JLabel(I18N.translate("words")));
        this.wordCombo.addItem(I18N.translate("leave_alone"));
        this.wordCombo.addItem(I18N.translate("capitalized"));
        this.wordCombo.addItem(I18N.translate("uppercase"));
        this.wordCombo.addItem(I18N.translate("lowercase"));
        this.wordCombo.setSelectedIndex(Integer.parseInt(Main.getProperty("words")));
        this.datasetFunctions.add(this.wordCombo);
        this.datasetFunctions.add(new JLabel("  "));
        this.ok.addActionListener(this);
        this.datasetFunctions.add(this.ok);
        this.datasetFunctions.add(new JLabel("  "));
        this.datasetPanel.add((Component)this.datasetFunctions, "South");
        this.mainPanel.add((Component)this.datasetPanel, "DATASET");
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
    }

    protected void showDataset(DataSet dataset) {
        if (dataset != null) {
            this.datasetTable.showDataset(dataset);
        }
        this.cards.show(this.mainPanel, "DATASET");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            if (DataManager.getInstance().getDatasets().size() > 0) {
                this.formatDatasets();
            }
        } else {
            this.cards.show(this.mainPanel, e.getActionCommand());
        }
    }

    private void formatDatasets() {
        Integer i = (Integer)this.leadingZeros.getSelectedItem();
        Main.setProperty("LEADING_0S", i.toString());
        DataManager.getInstance().setLeadingZeros(i);
        String r = this.replace.getText();
        String b = this.by.getText();
        DataManager.getInstance().replaceBy(r, b);
        Main.setProperty("WORDS", Integer.toString(this.wordCombo.getSelectedIndex()));
        String item = (String)this.wordCombo.getSelectedItem();
        if (item.equals(I18N.translate("uppercase"))) {
            DataManager.getInstance().setWordCase(1);
        } else if (item.equals(I18N.translate("lowercase"))) {
            DataManager.getInstance().setWordCase(2);
        } else if (item.equals(I18N.translate("capitalized"))) {
            DataManager.getInstance().setWordCase(0);
        }
        DataManager.getInstance().notifyObservers();
    }

    public void tableChanged(TableModelEvent e) {
        int column = e.getColumn();
        int row = e.getLastRow();
        if (e.getType() == 0 && column == 1 && !this.datasetTable.getIgnoreTableEvent() && DataManager.getInstance().getDatasets().size() > 0) {
            int changeAll = JOptionPane.showConfirmDialog(this, I18N.translate("change_all"));
            Object value = this.datasetTable.getModel().getValueAt(row, column);
            int id = (Integer)this.datasetTable.getModel().getValueAt(14, 1);
            if (changeAll == 0) {
                Vector datasets = DataManager.getInstance().getDatasets();
                Enumeration enumeration = datasets.elements();
                while (enumeration.hasMoreElements()) {
                    DataSet dataset = (DataSet)enumeration.nextElement();
                    this.setValue(row, value, dataset);
                }
                DataManager.getInstance().setDatasets(datasets);
            } else if (changeAll == 1) {
                Vector datasets = DataManager.getInstance().getDatasets();
                Enumeration enumeration = datasets.elements();
                while (enumeration.hasMoreElements()) {
                    DataSet dataset = (DataSet)enumeration.nextElement();
                    if (dataset.getId() != id) continue;
                    this.setValue(row, value, dataset);
                }
                DataManager.getInstance().setDatasets(datasets);
            } else if (changeAll == 2) {
                TableCellEditor tce = this.datasetTable.getCellEditor(row, column);
                tce.cancelCellEditing();
                if (row == 13) {
                    DataManager.getInstance().notifyObservers();
                }
            }
        }
    }

    private void setValue(int row, Object value, DataSet dataset) {
        switch (row) {
            case 0: {
                dataset.setTitle((String)value);
                break;
            }
            case 1: {
                dataset.setArtist((String)value);
                break;
            }
            case 2: {
                dataset.setAlbum((String)value);
                break;
            }
            case 3: {
                dataset.setTrack((String)value);
                break;
            }
            case 4: {
                dataset.setYear((String)value);
                break;
            }
            case 5: {
                dataset.setGenre((String)value);
                break;
            }
            case 6: {
                dataset.setComposer((String)value);
                break;
            }
            case 7: {
                dataset.setOrigArtist((String)value);
                break;
            }
            case 8: {
                dataset.setCopyright((String)value);
                break;
            }
            case 9: {
                dataset.setUrl((String)value);
                break;
            }
            case 10: {
                dataset.setComment((String)value);
                break;
            }
            case 12: {
                dataset.setPartOfSet((String)value);
                break;
            }
            case 11: {
                dataset.setEncodedBy((String)value);
                break;
            }
            case 13: {
                dataset.setPartOfCompilation((Boolean)value);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.replace) {
            if (this.replace.getText().equals(I18N.translate("replace"))) {
                this.replace.setText("");
            }
        } else if (e.getSource() == this.by && this.by.getText().equals(I18N.translate("by"))) {
            this.by.setText("");
        }
    }

    public void focusLost(FocusEvent e) {
    }
}

