/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.logging.LogObserver;
import net.sf.jmp3renamer.logging.LoggingArchive;
import net.sf.jmp3renamer.logging.SimpleFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugConsole
extends JFrame
implements LogObserver {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$gui$DebugConsole == null ? (class$net$sf$jmp3renamer$gui$DebugConsole = DebugConsole.class$("net.sf.jmp3renamer.gui.DebugConsole")) : class$net$sf$jmp3renamer$gui$DebugConsole);
    private final boolean AUTOSCROLL = true;
    private SimpleFormatter formatter = new SimpleFormatter();
    private JScrollPane scrollpane;
    private JScrollBar scrollbar;
    private JTextPane textpane = new JTextPane();
    private Document doc = this.textpane.getDocument();
    static /* synthetic */ Class class$net$sf$jmp3renamer$gui$DebugConsole;

    public DebugConsole() {
        LoggingArchive.addObserver(this);
        this.initStyles();
        this.initGUI();
        this.showCurrentLog();
    }

    private void initStyles() {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style s = this.textpane.addStyle(Level.FINE.toString(), def);
        StyleConstants.setForeground(s, Color.GRAY);
        StyleConstants.setFontFamily(s, "monospace");
        s = this.textpane.addStyle(Level.FINER.toString(), def);
        StyleConstants.setForeground(s, Color.LIGHT_GRAY);
        StyleConstants.setFontFamily(s, "monospace");
        s = this.textpane.addStyle(Level.FINEST.toString(), def);
        StyleConstants.setForeground(s, Color.LIGHT_GRAY);
        StyleConstants.setFontFamily(s, "monospace");
        s = this.textpane.addStyle(Level.INFO.toString(), def);
        StyleConstants.setForeground(s, Color.BLACK);
        StyleConstants.setFontFamily(s, "monospace");
        s = this.textpane.addStyle(Level.WARNING.toString(), def);
        StyleConstants.setForeground(s, Color.ORANGE);
        StyleConstants.setFontFamily(s, "monospace");
        s = this.textpane.addStyle(Level.SEVERE.toString(), def);
        StyleConstants.setForeground(s, Color.RED);
        StyleConstants.setFontFamily(s, "monospace");
    }

    public void updateObserver(Object o) {
        LogRecord entry = (LogRecord)o;
        this.insertLine(entry);
    }

    private void showCurrentLog() {
        Vector log = (Vector)LoggingArchive.getLog().clone();
        Iterator i = log.iterator();
        while (i.hasNext()) {
            LogRecord entry = (LogRecord)i.next();
            this.insertLine(entry);
        }
    }

    private synchronized void insertLine(LogRecord record) {
        String line = this.formatter.format(record);
        try {
            this.doc.insertString(this.doc.getLength(), line, this.textpane.getStyle(record.getLevel().toString()));
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.insert_line"), e);
        }
        this.scrollbar.setValue(this.scrollbar.getMaximum());
    }

    private void initGUI() {
        this.textpane.setEditable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.scrollpane = new JScrollPane(this.textpane);
        this.scrollbar = this.scrollpane.getVerticalScrollBar();
        this.getContentPane().add((Component)this.scrollpane, "Center");
        this.setSize(800, 300);
        this.setTitle(I18N.translate("debug"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                DebugConsole.this.setVisible(false);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

