/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jmp3renamer.DataPlugin;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.FilePlugin;
import net.sf.jmp3renamer.GeneralPlugin;
import net.sf.jmp3renamer.JarClassLoader;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginListCreator {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$tools$PluginListCreator == null ? (class$net$sf$jmp3renamer$tools$PluginListCreator = PluginListCreator.class$("net.sf.jmp3renamer.tools.PluginListCreator")) : class$net$sf$jmp3renamer$tools$PluginListCreator);
    _PluginLoader pluginLoader = new _PluginLoader();
    static /* synthetic */ Class class$net$sf$jmp3renamer$tools$PluginListCreator;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("usage: java PluginListCreator <plugin dir> <destination dir>");
            System.exit(1);
        }
        new PluginListCreator(args[0], args[1]);
    }

    PluginListCreator(String pluginDir, String destDir) {
        File plugDir = new File(pluginDir);
        File[] plugs = plugDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getAbsolutePath().endsWith(".jar");
            }
        });
        try {
            if (plugs != null && plugs.length > 0) {
                URL[] urls = new URL[plugs.length];
                String[] names = new String[plugs.length];
                long[] sizes = new long[plugs.length];
                for (int i = 0; i < plugs.length; ++i) {
                    URL url;
                    String pluginName;
                    File f = plugs[i];
                    sizes[i] = f.length();
                    names[i] = pluginName = f.getName().substring(0, f.getName().indexOf("."));
                    this.pluginLoader.loadPlugin(plugs[i]);
                    String path = "jar:file:/" + plugDir.getAbsolutePath() + File.separator + f.getName() + "!/";
                    urls[i] = url = new URL(path);
                    logger.info("Adding jar-URL: " + url);
                }
                Plugin plugin = null;
                PrintStream ps = new PrintStream(new FileOutputStream(destDir + File.separator + "List.java"));
                ps.println("import net.sf.jmp3renamer.*;");
                ps.println("public class List implements PluginList {");
                ps.println("    public static String[][] list = {");
                for (int i = 0; i < names.length; ++i) {
                    try {
                        JarClassLoader jcl = this.pluginLoader.getLoader(names[i]);
                        Class<?> c = jcl.loadClass("net.sf.jmp3renamer.plugins." + names[i] + "." + names[i]);
                        plugin = (Plugin)c.newInstance();
                        StringBuffer sb = new StringBuffer();
                        sb.append("{\"");
                        sb.append(plugin.getName());
                        sb.append("\",\"");
                        sb.append(plugin.getAuthor());
                        sb.append("\",\"");
                        sb.append(plugin.getVersion());
                        sb.append("\",\"");
                        sb.append(plugin.getDescription());
                        sb.append("\",\"");
                        sb.append(sizes[i]);
                        sb.append("\",\"");
                        sb.append(names[i]);
                        sb.append(".jar");
                        sb.append("\"}");
                        if (i != names.length - 1) {
                            sb.append(",");
                        }
                        ps.println(sb.toString());
                        logger.info("\t" + sb.toString());
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Couldn't load plugin", e);
                    }
                }
                ps.println("};");
                ps.println("public String[][] getList() {");
                ps.println("    return list;");
                ps.println("}}");
                ps.flush();
                ps.close();
            } else {
                logger.warn("\tNo PlugIns found :-(");
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class _PluginLoader {
        Hashtable loader_hashtable = new Hashtable();
        Vector plugins = new Vector();
        private File plugDir;

        public void loadPlugin(File jarfile) {
            Plugin plugin = null;
            String name = jarfile.getName().substring(0, jarfile.getName().lastIndexOf("."));
            JarClassLoader jcl = null;
            try {
                jcl = new JarClassLoader(jarfile);
                Class<?> c = jcl.loadClass("net.sf.jmp3renamer.plugins." + name + "." + name);
                plugin = (Plugin)c.newInstance();
                if (plugin != null) {
                    this.plugins.addElement(plugin);
                    this.loader_hashtable.put(name, jcl);
                    logger.info("\tPlugIn \"" + name + "\" loaded");
                }
            }
            catch (Exception e) {
                logger.error("Error loading plugin " + jarfile + "\n" + "Seems to be corrupt and will be deleted", e);
                try {
                    jcl.closeJarFile();
                    jarfile.delete();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        public boolean unloadPlugin(String pluginName) {
            logger.debug("Trying to unload plugin: " + pluginName);
            try {
                JarClassLoader jcl = (JarClassLoader)this.loader_hashtable.get(pluginName);
                jcl.closeJarFile();
                Plugin plugin = null;
                Enumeration en = this.plugins.elements();
                while (en.hasMoreElements()) {
                    Plugin current = (Plugin)en.nextElement();
                    String uniqueName = current.getClass().getName();
                    if (!(uniqueName = uniqueName.substring(uniqueName.lastIndexOf(".") + 1, uniqueName.length())).equals(pluginName)) continue;
                    plugin = current;
                    this.plugins.remove(plugin);
                    this.loader_hashtable.remove(pluginName);
                }
                if (plugin != null) {
                    if (plugin.getType() == 0) {
                        Main.getGUI().removePlugin((DataPlugin)plugin);
                    } else if (plugin.getType() == 1) {
                        FileManager.getInstance().removeFilePlugin((FilePlugin)plugin);
                    } else if (plugin.getType() == 2) {
                        Main.getGUI().removePlugin((GeneralPlugin)plugin);
                    }
                }
                return true;
            }
            catch (Exception e) {
                logger.error("Couldn't unload PlugIn " + pluginName, e);
                return false;
            }
        }

        public Vector getPlugins() {
            return this.plugins;
        }

        public File getPluginDir() {
            if (this.plugDir == null) {
                Class<?> main = this.getClass();
                URL url = main.getResource("PluginLoader.class");
                String temp = "";
                try {
                    temp = URLDecoder.decode(url.getFile(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.debug("", e);
                }
                File jarfile = new File(temp.substring(temp.indexOf("/"), temp.indexOf("!")));
                this.plugDir = new File(jarfile.getParent() + File.separator + "plugins");
            }
            return this.plugDir;
        }

        public JarClassLoader getLoader(String pluginName) {
            return (JarClassLoader)this.loader_hashtable.get(pluginName);
        }
    }
}

