/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.MusicBrainz.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.ImageLoader;
import net.sf.jmp3renamer.plugins.MusicBrainz.Album;
import net.sf.jmp3renamer.plugins.MusicBrainz.MB_Client;
import net.sf.jmp3renamer.plugins.MusicBrainz.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicBrainzPanel
extends JPanel
implements ActionListener,
KeyListener,
MouseListener,
Observer {
    private static transient Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$MusicBrainz$gui$MusicBrainzPanel == null ? (class$net$sf$jmp3renamer$plugins$MusicBrainz$gui$MusicBrainzPanel = MusicBrainzPanel.class$("net.sf.jmp3renamer.plugins.MusicBrainz.gui.MusicBrainzPanel")) : class$net$sf$jmp3renamer$plugins$MusicBrainz$gui$MusicBrainzPanel));
    private JLabel lAlbum = new JLabel();
    private JLabel lArtist = new JLabel();
    private JScrollPane scrollpane = new JScrollPane();
    private JProgressBar progress = new JProgressBar();
    private JButton cancelButton = new JButton();
    private JTextField tAlbum = new JTextField();
    private JTextField tArtist = new JTextField();
    public DefaultListModel model = new DefaultListModel();
    public JList list = new JList(this.model);
    private Album currentAlbum;
    private MB_Client mbClient;
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$MusicBrainz$gui$MusicBrainzPanel;

    public MusicBrainzPanel() {
        this.initGUI();
        DataManager.getInstance().addObserver((Observer)this);
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lArtist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tArtist, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lAlbum, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tAlbum, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.progress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.cancelButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.scrollpane, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.lAlbum.setText(I18N.translate((String)"album"));
        this.lArtist.setText(I18N.translate((String)"artist"));
        this.progress.setVisible(false);
        this.cancelButton.setVisible(false);
        this.cancelButton.setIcon(ImageLoader.getInstance().loadImage("images/cancel.png"));
        this.cancelButton.setBorder(BorderFactory.createEmptyBorder());
        this.cancelButton.setToolTipText(I18N.translate((String)"cancel"));
        this.scrollpane.getViewport().add((Component)this.list, null);
        this.tArtist.addActionListener(this);
        this.tAlbum.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.list.addMouseListener(this);
        this.list.addKeyListener(this);
    }

    public void setRunning() {
        this.cancelButton.setVisible(true);
        this.progress.setVisible(true);
        this.progress.setStringPainted(true);
        this.progress.setString(I18N.translate((String)"getting_data"));
        this.progress.setIndeterminate(true);
        this.tAlbum.setEnabled(false);
        this.tArtist.setEnabled(false);
        this.list.setEnabled(false);
    }

    public void setEnded() {
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.progress.setValue(100);
        this.progress.setIndeterminate(false);
        this.progress.setString(I18N.translate((String)"finished"));
        this.progress.setVisible(false);
        this.cancelButton.setVisible(false);
        this.tAlbum.setEnabled(true);
        this.tArtist.setEnabled(true);
        this.list.setEnabled(true);
    }

    public void setStatus(int n) {
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.progress.setValue(n);
        this.progress.setIndeterminate(false);
    }

    public void addResult(Object object) {
        logger.debug("Adding element");
        this.model.addElement(object);
    }

    private void getTracks() {
        DataManager.getInstance().getDatasets().removeAllElements();
        this.currentAlbum = (Album)this.model.getElementAt(this.list.getSelectedIndex());
        ArrayList arrayList = this.currentAlbum.getTracks();
        this.mbClient = new MB_Client(this.currentAlbum, arrayList, 1, this);
    }

    public DataSet getNextDataSet() {
        DataSet dataSet = new DataSet();
        dataSet.setAlbum(this.currentAlbum.getTitle());
        dataSet.setArtist(this.currentAlbum.getArtist());
        dataSet.setYear(this.currentAlbum.getYear());
        return dataSet;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getSource() == this.list && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                this.getTracks();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.list && keyEvent.getKeyCode() == 10) {
            this.getTracks();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public String getArtist() {
        return null;
    }

    public String getAlbum() {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tArtist || actionEvent.getSource() == this.tAlbum) {
            this.model.removeAllElements();
            String string = QueryFactory.createFindAlbumQuery(this.tArtist.getText(), this.tAlbum.getText());
            this.mbClient = new MB_Client(string, 0, this);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.mbClient.stopThread();
            this.setEnded();
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == DataManager.getInstance()) {
            Vector vector = (Vector)object;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                DataSet dataSet = (DataSet)iterator.next();
                if (!"".equals(dataSet.getArtist())) {
                    this.tArtist.setText(dataSet.getArtist());
                }
                if ("".equals(dataSet.getAlbum())) continue;
                this.tAlbum.setText(dataSet.getAlbum());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

