/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.io.wav.WaveFile;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SoundOutputStreamImpl
implements SoundOutputStream {
    protected AudioProcessor audioProcessor;
    protected AudioFormat audioFormat;
    protected File exportFile;
    protected float currentVolume;
    protected float currentBalance;
    protected SourceDataLine sourceLine;
    protected WaveFile waveExportFile;
    protected boolean playDuringExport;
    protected boolean keepSilent;

    protected SoundOutputStreamImpl() {
    }

    public SoundOutputStreamImpl(AudioFormat audioFormat, AudioProcessor audioProcessor, File file, boolean bl, boolean bl2) {
        this();
        this.audioFormat = audioFormat;
        this.audioProcessor = audioProcessor;
        this.exportFile = file;
        this.playDuringExport = bl;
        this.keepSilent = bl2;
    }

    protected synchronized void openSourceLine() {
        if (this.audioFormat != null) {
            try {
                this.closeSourceLine();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
                if (AudioSystem.isLineSupported(info)) {
                    this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.sourceLine.open();
                    this.sourceLine.start();
                    this.setVolume(this.currentVolume);
                    this.setBalance(this.currentBalance);
                } else {
                    Log.info("Audioformat is not supported");
                }
            }
            catch (Exception exception) {
                this.sourceLine = null;
                Log.error("Error occured when opening audio device", exception);
            }
        }
    }

    protected synchronized void openAudioProcessor() {
        if (this.audioProcessor != null) {
            if (this.sourceLine != null) {
                this.audioProcessor.initializeProcessor(this.sourceLine);
                this.audioProcessor.setUseInternalCounter(this.keepSilent);
            } else {
                this.audioProcessor.initializeProcessor(this.audioFormat);
                this.audioProcessor.setUseInternalCounter(true);
            }
        }
    }

    protected synchronized void openExportFile() {
        if (this.exportFile != null) {
            this.waveExportFile = new WaveFile();
            if (this.waveExportFile.openForWrite(this.exportFile, this.audioFormat) != 0) {
                this.waveExportFile = null;
                Log.error("Creation of exportfile was NOT successfull!");
            }
        }
    }

    protected synchronized void closeSourceLine() {
        if (this.sourceLine != null) {
            this.stopLine();
            this.sourceLine.close();
            this.sourceLine = null;
        }
    }

    protected synchronized void closeAudioProcessor() {
        if (this.audioProcessor != null) {
            this.audioProcessor.stop();
        }
    }

    protected synchronized void closeExportFile() {
        if (this.waveExportFile != null) {
            this.waveExportFile.close();
        }
    }

    @Override
    public synchronized void open() {
        this.close();
        if (this.playDuringExport || this.exportFile == null) {
            this.openSourceLine();
        }
        this.openAudioProcessor();
        this.openExportFile();
    }

    @Override
    public synchronized void close() {
        this.closeSourceLine();
        this.closeAudioProcessor();
        this.closeExportFile();
    }

    @Override
    public synchronized void closeAllDevices() {
        this.close();
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.sourceLine != null && this.sourceLine.isOpen() || this.exportFile != null;
    }

    @Override
    public synchronized void startLine() {
        if (this.sourceLine != null) {
            this.sourceLine.flush();
            this.sourceLine.start();
        }
    }

    @Override
    public synchronized void stopLine() {
        if (this.sourceLine != null) {
            if (this.sourceLine.isRunning()) {
                this.sourceLine.drain();
            }
            this.sourceLine.stop();
        }
    }

    protected synchronized void writeSampleDataInternally(byte[] byArray, int n, int n2) {
        if (this.sourceLine != null && !this.keepSilent) {
            this.sourceLine.write(byArray, n, n2);
        }
        if (this.waveExportFile != null) {
            this.waveExportFile.writeSamples(byArray, n, n2);
        }
    }

    @Override
    public synchronized void writeSampleData(byte[] byArray, int n, int n2) {
        if (this.audioProcessor != null) {
            int n3 = this.audioProcessor.writeSampleData(byArray, n, n2);
            this.writeSampleDataInternally(this.audioProcessor.getResultSampleBuffer(), 0, n3);
        } else {
            this.writeSampleDataInternally(byArray, n, n2);
        }
    }

    @Override
    public synchronized void setInternalFramePosition(long l) {
        if (this.audioProcessor != null) {
            this.audioProcessor.setInternalFramePosition(l);
        }
    }

    @Override
    public synchronized void setVolume(float f) {
        this.currentVolume = f;
        if (this.sourceLine != null && this.sourceLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl floatControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
            float f2 = (float)Helpers.getDBValueFrom(f);
            if (f2 > floatControl.getMaximum()) {
                f2 = floatControl.getMaximum();
            } else if (f2 < floatControl.getMinimum()) {
                f2 = floatControl.getMinimum();
            }
            floatControl.setValue(f2);
        }
    }

    @Override
    public synchronized void setBalance(float f) {
        FloatControl floatControl;
        this.currentBalance = f;
        if (this.sourceLine != null && this.sourceLine.isControlSupported(FloatControl.Type.BALANCE) && f <= (floatControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.BALANCE)).getMaximum() && f >= floatControl.getMinimum()) {
            floatControl.setValue(f);
        }
    }

    @Override
    public synchronized void setAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessor = audioProcessor;
    }

    @Override
    public synchronized void setExportFile(File file) {
        this.exportFile = file;
    }

    @Override
    public synchronized void setWaveExportFile(WaveFile waveFile) {
        this.waveExportFile = waveFile;
    }

    @Override
    public synchronized void setPlayDuringExport(boolean bl) {
        this.playDuringExport = bl;
    }

    @Override
    public synchronized void setKeepSilent(boolean bl) {
        this.keepSilent = bl;
    }

    @Override
    public boolean matches(SoundOutputStream soundOutputStream) {
        return this.getAudioFormat().matches(soundOutputStream.getAudioFormat());
    }

    @Override
    public synchronized AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public synchronized void changeAudioFormatTo(AudioFormat audioFormat) {
        boolean bl = this.sourceLine != null && this.sourceLine.isOpen();
        this.close();
        this.audioFormat = audioFormat;
        if (bl) {
            this.open();
        }
    }
}

